$(function(){ 
	$.ajaxSetup({cache:false});	
	//公共 ajax 调用  模态化窗口	
	$("#ajax_status").ajaxStart(function () {	
		//dialog start		
		$("#ajax_status").dialog({
		autoOpen: true,
		open:function(){
		  $("span").each(function(i){
		   if (this.innerHTML=="close")
		   {
			this.style.display="none";
		   }
		  } );
    	 },
		modal:true,
		minWidth:80,
		minHeight:30,
		bgiframe:true,
		closeOnEscape:false,
		draggable:false,
		position:"center",
		resizable:false,
		stack:true			
	});//end dialog										  
		
	}).ajaxStop(function () {	
		$("#ajax_status").dialog("close");		
	})	
   
    //模式化窗口
   $("#encoder_set_outer").dialog
	({
		width:700,
		height:450,
		modal:true,
		title:'编码设置',	
		autoOpen:false,
		position:"top"
	});
	
	$("#encoder_high_set_outer").dialog
	({
		width:600,
		height:250,
		modal:true,
		title:'编码高级设置',	
		autoOpen:false,
		position:"top"
	});	
	
	$("#audio_set_outer").dialog
	({
		width:600,
		height:420,
		modal:true,
		title:'编码音频设置',	
		autoOpen:false,
		position:"top"
	});
	$("#video_resource_set_outer").dialog
	({
		width:550,
		height:230,
		modal:true,
		title:'视频源设置',	
		autoOpen:false,
		position:"top"
	});		
	
	$("#stream_info_set_outer").dialog
	({
		width:650,
		height:420,
		modal:true,
		title:'流设置',	
		autoOpen:false,
		position:"top"
	});	
	$("#stream_num_set_outer").dialog
	({
		width:300,
		height:200,
		modal:true,
		title:'流个数设置',	
		autoOpen:false,
		position:"top"
	});
	
	$("#custom_dpi_set").dialog
	({
		width:300,
		modal:true,
		title:'自定义分辨率设置',
		autoOpen:false,
		position:"top"
	});
	
	init_rtmp_port();
	init_stream_name_sel();//初使化流详情中选中的流  如  live/live1
	init_encoder_type();
	
   //在提交表单时 AJAX 向CGI通讯   
   $("#encoder_set").submit(function()
   {     
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
	                     beforeSubmit:function()
	                     {						
	                     	var num = /^\d+$/;
							var times = $("#road_num").val();
							//需要验证的通道数
							var j = parseInt(times);
												
							//验证三个通道的码流
							for(var i=1;i<(j+1); i++)
							{
								if(!num.test($("#bitrate_v"+i).val()))
								{
									alert("编码 "+i+" 码流参数格式不对!");
									return false;
								}
								else
								{
									if(!(parseInt($("#bitrate_v"+i).val())>=50 && parseInt($("#bitrate_v"+i).val())<=20000))
									{
										alert("编码 "+i+" 码流参数范围应在 50~20000 之间");
										return false;
									}									
								}
							}
							//验证三个编码的压缩率
							for(var i=1;i<(j+1); i++)
							{
								if(!num.test($("#quality"+i).val()))
								{
									alert("编码 "+i+" 压缩率参数格式不对!");
									return false;
								}
								else
								{
									if(!(parseInt($("#quality"+i).val())>=40 && parseInt($("#quality"+i).val())<=300))
									{									
										alert("编码 "+i+" 压缩率参数范围应在 40~300 之间");
										return false;
									}									
								}
							}
							//验证三个编码的帧率
							for(var i=1;i<j+1; i++)
							{
								if(!num.test($("#output_framerate"+i).val()))
								{
									alert("编码 "+i+" 帧率参数格式不对!");
									return false;
								}
								else
								{
									if(!(parseInt($("#output_framerate"+i).val())>=0 && parseInt($("#output_framerate"+i).val())<=60))
									{
										alert("编码 "+i+" 帧率参数范围应在 0~60 之间");
										return false;
									}									
								}
							}
							//验证三个编码的 I帧间隔
							for(var i=1;i<j+1; i++)
							{
								if(!num.test($("#ifrmdist"+i).val()))
								{
									alert("编码 "+i+" GOP参数格式不对!");
									return false;
								}
								else
								{
									if(!(parseInt($("#ifrmdist"+i).val())>=0 && parseInt($("#ifrmdist"+i).val())<=200))
									{
										alert("编码 "+i+" GOP参数范围在 0~200 之间");
										return false;
									}									
								}
							}
							
							//验证三个通道的分辨率 编码二最高FullD1和编码三最高到D1
							var op2 = $("#output_videosize2").val();
							var op3 = $("#output_videosize3").val();
							if(j==2)
							{
								if(cmpstr(op2,"720x576")>0)
								{
									alert("编码2视频分辨率不能超过D1(720x576)!");
									return false;
								}
							}
							else if(j==3)
							{
								if(cmpstr(op2,"720x576")>0)
								{
									alert("编码2视频分辨率不能超过D1(720x576)!");
									return false;
								}
								else if(cmpstr(op3,"704x576")>0)
								{
									alert("编码3视频分辨率不能超过D1(704x576)!");
									return false;
								}
							}
							
	                     },  
	                     success: function(data)
	                     {	
	                    	if(data != "ok")
	                    	{
	                    		alert("设置编码器参数失败!请重新尝试!");
	                    	}
	                    	else
	                    	{
	                    		var ip = $("#encode_set_ip").val();
		                     	var sign = ip.substr(ip.lastIndexOf(".")+1);
		                     	get_all_status(ip,sign);
		                     	window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
	                    	}
							$("#encoder_set_outer").dialog("close");
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 	
   });  
   
   //编码高级设置
   /*
   $("#encoder_high_set").submit(function()
   {      
     	var options = {                         
	                     url:"/cgi-bin/AMS.cgi",
	                     type:'GET',
	                     resetForm:false,
	                     //dataType:"json",
	                     beforeSubmit:function()
	                     {
				            var num = /^\d+$/;							
							//CamInfo_Contrast						
							if(!num.test($("#CamInfo_Contrast").val()))
							{
								alert("对比度参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#CamInfo_Contrast").val())>=0 && parseInt($("#CamInfo_Contrast").val())<=100))
								{
									alert("对比度参数范围应在 0~100 之间");
									return false;
								}									
							}
							//CamInfo_Brightness						
							if(!num.test($("#CamInfo_Brightness").val()))
							{
								alert("亮度参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#CamInfo_Brightness").val())>=0 && parseInt($("#CamInfo_Brightness").val())<=100))
								{
									alert("亮度参数范围应在 0~100 之间");
									return false;
								}									
							}
							//CamInfo_Saturation						
							if(!num.test($("#CamInfo_Saturation").val()))
							{
								alert("饱和度参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#CamInfo_Saturation").val())>=0 && parseInt($("#CamInfo_Saturation").val())<=100))
								{
									alert("饱和度参数范围应在 0~100 之间");
									return false;
								}									
							}
							//CamInfo_Hue						
							if(!num.test($("#CamInfo_Hue").val()))
							{
								alert("色调参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#CamInfo_Hue").val())>=0 && parseInt($("#CamInfo_Hue").val())<=100))
								{
									alert("色调参数范围应在 0~100 之间");
									return false;
								}									
							}
							//CamInfo_Sharpness						
							if(!num.test($("#CamInfo_Sharpness").val()))
							{
								alert("锐度参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#CamInfo_Sharpness").val())>=0 && parseInt($("#CamInfo_Sharpness").val())<=100))
								{
									alert("锐度参数范围应在 0~100 之间");
									return false;
								}									
							}
							if(!num.test($("#video_bound_top").val()) || !num.test($("#video_bound_right").val()) || !num.test($("#video_bound_bottom").val()) || !num.test($("#video_bound_left").val()))
							{
								alert("视频切边参数不对!");
								return false;
							}
														       
	                     },  
	                     success: function(data)
	                     {
	                    	 if(data != "ok")
		                    		alert("设置编码器参数失败!请重新尝试!");
		                    	
							$("#encoder_high_set_outer").dialog("close");				      
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 	
    });  
 	*/
   
 	 //音频视频
 	  $("#audio_set").submit(function()
  	 {      	
    	var options = {   
    				 	type: "POST",
			  			url: "/admin/live/EncoderOnlineServlet",			 
	                     resetForm:false,
	                     //dataType:"json",
						 beforeSubmit:function()
	                     {							
							var num = /^\d+$/;						
							if(!num.test($("#audio_louder").val()))
							{
								alert("声音大小参数格式不对!");
								return false;
							}
							else
							{
								if(!(parseInt($("#audio_louder").val())>=0 && parseInt($("#audio_louder").val())<=100))
								{
									alert("声音大小范围为0~100");
									return false;
								}
							}							
	                     }, 
	                     success: function(data)
	                     {
	                    	 if(data != "ok")
	                    	 {
	                    		alert("设置编码器参数失败!请重新尝试!"); 
	                    	 }
	                    	 else
	                    	 {
	                    		var ip = $("#audio_set_ip").val();
	 	                     	var sign = ip.substr(ip.lastIndexOf(".")+1);
	 	                     	get_all_status(ip,sign);	
	 	                     	window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
	                    	 }
	                     	$("#audio_set_outer").dialog("close");
	                     	
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 });  
 	
 	//视频源视频
 	 $("#video_resource_set").submit(function()
  	 {      	 
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
	                     success: function(data)
	                     {	
				     		if(data != "ok")
				     		{
				     			alert("设置编码器参数失败!请重新尝试!");
				     		}
				     		else
				     		{
				     		   var ip = $("#video_resource_set_ip").val();
		                       var sign = ip.substr(ip.lastIndexOf(".")+1);
		                       get_all_status(ip,sign);	
		                       window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
				     		}
        	
	                       $("#video_resource_set_outer").dialog("close");
	                      
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 });
	 
	 $("#stream_num_single_set").submit(function()
  	 {      	 
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
	                     success: function(data)
	                     {	
				     		if(data != "ok")
				     		{
				     			alert("设置编码器参数失败!请重新尝试!");
				     		}
				     		else
				     		{
				     		   var ip = $("#stream_num_set_ip").val();
		                       var sign = ip.substr(ip.lastIndexOf(".")+1);
		                       get_all_status(ip,sign);
		                       window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
				     		}
	                        $("#stream_num_set_outer").dialog("close");
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 });

 // HLS submit
	 $("#hls_form").submit(function()
  	 {      	 
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
						 beforeSubmit:function()
	                     {			
	                     	
	                     },  
	                     success: function(data)
	                     {
	                    	 if(data != "ok")
	                    	 {
                    			alert("设置编码器参数失败!请重新尝试!"); 
	                    	 }
	                    	 else
	                    	 {
	                    		var ip = $("#stream_hls_set_ip").val();
	 	                        var sign = ip.substr(ip.lastIndexOf(".")+1);
	 	                        get_all_status(ip,sign);   
	 	                        window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
	                    	 }
	                    	 
	                        $("#stream_info_set_outer").dialog("close");
	                       
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 }); 
	 // RTMP submit
	 $("#rtmp_form").submit(function()
  	 {      	 
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
						 beforeSubmit:function()
	                     {			
	                     	var com_str = /\w+/;
							var num = /\d+/;
							var ip = /\d+.\d+.\d+.\d+/;
							var url = /http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;											
							var rtmp = /rtmp:\/\/\d+.\d+.\d+.\d+:\d+/;
						
	                     },  
	                     success: function(data)
	                     {
	                    	 if(data != "ok")
	                    	 {
	                    		alert("设置编码器参数失败!请重新尝试!"); 
	                    	 }
	                    	 else
	                    	 {
	                    		 var ip = $("#stream_rtmp_set_ip").val();
	   	                        var sign = ip.substr(ip.lastIndexOf(".")+1);
	   	                        get_all_status(ip,sign);
	   	                        window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	
	                    	 }
	                    	 
	                        $("#stream_info_set_outer").dialog("close");
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 }); 
	  // TS submit
	 $("#ts_form").submit(function()
  	 {     	 
     	var options = {                         
	                     url:"/admin/live/EncoderOnlineServlet",
	                     type:'POST',
	                     resetForm:false,
	                     //dataType:"json",
						 beforeSubmit:function()
	                     {			
	                     	var com_str = /\w+/;
							var num = /\d+/;
							var ip = /\d+.\d+.\d+.\d+/;
							var url = /http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;											
							var rtmp = /rtmp:\/\/\d+.\d+.\d+.\d+:\d+/;
							
								if(!(ip.test($("#ts_ip").val())))
								{
									alert("TS流地址格式不符!");
									return false;
								}
								else if(!(num.test($("#ts_port").val())))
								{
									alert("TS流端口号格式不符!");
									return false;
								}
								else if(!(parseInt($("#ts_port").val())>=20 && parseInt($("#ts_port").val())<=9999))
								{
									alert("TS流端口号超出范围,20~9999!");
									return false;
								}
	                     },  
	                     success: function(data)
	                     {
	                    	 if(data != "ok")
	                    	 {
                    			alert("设置编码器参数失败!请重新尝试!"); 
	                    	 }
	                    	 else
	                    	 {
	                    	     var ip = $("#stream_ts_set_ip").val();
	   	                         var sign = ip.substr(ip.lastIndexOf(".")+1);
	   	                         get_all_status(ip,sign); 
	   	                         window.top.art.dialog({id:'dg_test34243', content:'操作成功!',time:1});	 
	                    	 }
	                    	 $("#stream_info_set_outer").dialog("close");
	                     } 
                 		};    
   			$(this).ajaxSubmit(options);   
            return false; 
	 }); 
   
   
    //初使化 自定义分辨率中的 width  height   
    var width = new Array(128,144,160,176,192,208,224,240,256,272,288,304,320,336,352,368,384,400,416,432,448,464,480,496,512,528,544,560,576,592,608,624,640,656,672,688,704,720,736,752,768,784,800,816,832,848,864,880,896,912,928,944,960,976,992,1008,1024,1040,1056,1072,1088,1104,1120,1136,1152,1168,1184,1200,1216,1232,1248,1264,1280,1296,1312,1328,1344,1360,1376,1392,1408,1424,1440,1456,1472,1488,1504,1520,1536,1552,1568,1584,1600,1616,1632,1648,1664,1680,1696,1712,1728,1744,1760,1776,1792,1808,1824,1840,1856,1872,1888,1904,1920);
	
	var height = new Array(96,104,112,120,128,136,144,152,160,168,176,184,192,200,208,216,224,232,240,248,256,264,272,280,288,296,304,312,320,328,336,344,352,360,368,376,384,392,400,408,416,424,432,440,448,456,464,472,480,488,496,504,512,520,528,536,544,552,560,568,576,584,592,600,608,616,624,632,640,648,656,664,672,680,688,696,704,712,720,728,736,744,752,760,768,776,784,792,800,808,816,824,832,840,848,856,864,872,880,888,896,904,912,920,928,936,944,952,960,968,976,984,992,1000,1008,1016,1024,1032,1040,1048,1056,1064,1072,1080);
	
	for(var i=0;i<width.length;i++)
	{
		$("#custom_dpi_x").append("<option value='"+width[i]+"'>"+width[i]+"</option>");	
	}
	for(var i=0;i<height.length;i++)
	{
		$("#custom_dpi_y").append("<option value='"+height[i]+"'>"+height[i]+"</option>");	
	}
	
	//初使化copy事件
	$("#copy1").click(function(){
	  $("#rtmp_copy").val("true");
	  $("#hls_copy").val("true");
	  $("#ts_copy").val("true");
	  $("#sync").val("true");
	  	
	})
	$("#copy2").click(function(){
	  $("#rtmp_copy").val("false");
	  $("#hls_copy").val("false");
	  $("#ts_copy").val("false");
	  $("#sync").val("false");
	})

});	

//**************** 下面是初使化 函数  在点击事件 触发时调用 *************//

// init the encoder
	function initEncoderSet(ip)
	{
		var encoderType = $("#encoderType").val();
		
		 //初使化页面通道一，通道二，通道三中的 数据  
   $.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{action:'encode_get',encoder_ip:ip,encoderType:encoderType},		 
			  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {		
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }		  
		 		//获取的数据全是数组
		 		//var video_encoder_type = obj.video_encoder_type; 类型不处理
				var road_num = obj.road_num;
		 		var compress_type = obj.compress_type; //压缩率				
				var output_videosize = obj.output_videosize;//视频分辨率
				var bitrate_type = obj.bitrate_type;	//码率方式
				var bitrate_v = obj.bitrate_v;			//码流
				var quality = obj.quality;				//压缩率
				var output_framerate = obj.output_framerate; //帧率	
				var ifrmdist = obj.ifrmdist;				 //I帧
				var audio_encoder_type = obj.audio_encoder_type; //音频类型
				var channel = obj.channel;						//声音频道
				
				//初使化 通道 数目				
				$("#road_num").val(road_num);
				TDselect(road_num);
				
				
				//初使化 压缩率方式
				for(var i=0;i<road_num && i<compress_type.length;i++)
				{
					if(compress_type[i] == 0)//压缩方式为  H264_BP 
					{
						$("#compress_type"+(i+1)).val(0);
					}
					else if(compress_type[i] == 1)//压缩方式为  H264_HP 
					{
						 $("#compress_type"+(i+1)).val(1);
					}					
				}			
				
					for(var i=0;i<road_num && i<output_videosize.length;i++)
					{
						
						if(output_videosize[i] == "720×576")//FullD1 
						{
							$("#output_videosize"+(i+1)).val("720×576");
						}
						else if(output_videosize[i] == "704x576")//D1
						{
							 $("#output_videosize"+(i+1)).val("704x576");
						}
						else if(output_videosize[i] == "352x288")//CIF
						{
							 $("#output_videosize"+(i+1)).val("352x288");
						}
						else if(output_videosize[i] == "176x144")//QCIF
						{
							 $("#output_videosize"+(i+1)).val("176x144");
						}
						else if(output_videosize[i] != "")					
						{
							$("#output_videosize"+(i+1)).prepend("<option selected='selected' value='"+output_videosize[i]+"'>"+output_videosize[i]+"</option>");
							$("#output_videosize"+(i+1)).val(output_videosize[i]);					
						}
						
					}
				
				
				//初使化 码率方式
				for(var i=0;i<road_num && i<bitrate_type.length;i++)
				{
					if(bitrate_type[i] == 1)
					{
						$("#bitrate_type"+(i+1)).val(1);
					}
					else if(bitrate_type[i] == 2)
					{
						 $("#bitrate_type"+(i+1)).val(2);
					}
					else if(bitrate_type[i] == 3)
					{
						 $("#bitrate_type"+(i+1)).val(3);
					}
					
					
				}
				
				//初使化 码流
				for(var i=0;i<road_num && i<bitrate_v.length;i++)
				{
					$("#bitrate_v"+(i+1)).val(bitrate_v[i]);
				}
				//初使化 压缩率
				for(var i=0;i<road_num && i<quality.length;i++)
				{
					$("#quality"+(i+1)).val(quality[i]);
				}
				
				//初始化 帧率 output_framerate
				for(var i=0;i<road_num && i<output_framerate.length;i++)
				{
					$("#output_framerate"+(i+1)).val(output_framerate[i]);
				}
				
				//初始化 I帧 ifrmdist
				for(var i=0;i<road_num && i<ifrmdist.length;i++)
				{
					$("#ifrmdist"+(i+1)).val(ifrmdist[i]);
				}
				
				//初始化 声音类型				
				$("#audio_encoder_type").val(audio_encoder_type);				
				
				//初始化 声音频道  //目前仅支持一种  不用处理					 	 				 	
			  }		 	
 		   })//ajax end	
	
	}
	
	//初使化每个通道 高级设置的内容  所有通道共用一个设置
	/*
	function initHighSet(ip)
	{
		  $.ajax({
			  type: "GET",
			  url: "/cgi-bin/AMS.cgi",			 
			  data:{action:'encode_high_get',encoder_id:ip},
			  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {	
			 // alert(data);
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }					
				
		 		var CamInfo_Contrast = obj.CamInfo_Contrast; //对比度				
				var CamInfo_Brightness = obj.CamInfo_Brightness;//亮度
				var CamInfo_Saturation = obj.CamInfo_Saturation;	//饱和度
				var CamInfo_Hue = obj.CamInfo_Hue;			//色调
				var CamInfo_Sharpness = obj.CamInfo_Sharpness;		//锐度			
				var CamInfo_Rotation = obj.CamInfo_Rotation;	 //图像旋转
				var caption = obj.caption;	//字幕
				var caption_x = obj.caption_x;
				var caption_y = obj.caption_y;
				var caption_content = obj.captionContent;
				
				$("#CamInfo_Contrast").val(CamInfo_Contrast);
				$("#CamInfo_Brightness").val(CamInfo_Brightness);
				$("#CamInfo_Saturation").val(CamInfo_Saturation);
				$("#CamInfo_Hue").val(CamInfo_Hue);
				$("#CamInfo_Sharpness").val(CamInfo_Sharpness);
				$("#CamInfo_Rotation").val(CamInfo_Rotation);
				
				if(caption == 0)
				{
					$("input[name=caption] :eq(0)").attr("checked",'checked');
				}
				else
				{
					$("input[name=caption] :eq(1)").attr("checked",'checked');
				}
				$("#caption_x").val(caption_x);
				$("#caption_y").val(caption_y);
				$("caption_content").val(caption_content);
				
				
				//图像旋转
				for(var i=1;i<5;i++)
				{
					 if(CamInfo_Rotation == i)
					 {
						$("#CamInfo_Rotation").val(i);	
					 }
				}			
								 	 				 	
			  }		 	
 		   })//ajax end		
	}
	*/
	function initAudioSet(ip)
	{
		var encoderType = $("#encoderType").val();
		$.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{action:'audio_get',encoder_ip:ip,encoderType:encoderType},				  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {	
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }
				 var audio_open_status = obj.audio_open_status;
				 var audio_input_type = obj.audio_input_type;
				 var audio_louder = obj.audio_louder;
				 var audio_encoder_type = obj.audio_encoder_type;
				 var audio_channel = obj.channel;
				 var audio_bitrate = obj.bitrate;
				 var audio_sampling_rate = obj.sampling_rate;				
				  //init the input type
				 audioChange(audio_input_type);
				
				 //声音是否开启
				 $("#audio_isopen").val(audio_open_status);	
				 //输入类型
				 $("#audio_input_type").val(audio_input_type);
				 //设置声音大小
				 $("#audio_louder").val(audio_louder);				 
				 //初始化 声音类型				
				 $("#audio_encoder_type").val(audio_encoder_type);	
				 //单双声道
				 $("#audio_channel").val(audio_channel);
				 //比特率
				 $("#audio_bitrate").val(audio_bitrate);
				 //采样率
				 //initialize
				setTimeout(function(){ 
  						  $("#audio_sampling_rate").val(audio_sampling_rate)
						},1000);				
				
			  }		 	
 		   })//ajax end	
	}
	function initResourceSet(ip)
	{
		var encoderType = $("#encoderType").val();
		//初使化视频源类型
		$.ajax({
				  type: "POST",
				  url: "/admin/live/EncoderOnlineServlet",		 
				  data:{action:'video_resource_type_get','encoder_ip':ip,encoderType:encoderType},			  
				  //处理CGI返回的JSON数据
				  success: function(data)
				  {	
					 var obj;
					 try
					 {
						 obj = $.parseJSON(data);
					 }
					 catch(e)
					 {
						 alert("编码器通讯失败,数据获取失败,请重新尝试!");
					 }
					var type = obj.mode;
					var status = obj.status;							
					$("#video_resource_type").val(type);	
			
					if(status=="0" || status=="")
					{
						$("#status").html("error,please check!")
					}
					else
					{
						$("#status").html("正常")
					}
				  }		 	
	 		   })//ajax end	
		
	}
	function initStreamNum(ip)
	{	
		var encoderType = $("#encoderType").val();
		 $.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{action:'stream_num_get','encoder_ip':ip,encoderType:encoderType},				  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {	
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }				  	
				 var num = obj.stream_num;
				 if(num != 0)
				 {
					$("#stream_num option").each(function(){					  
						$(this).remove();
					 });				  
					   
				 	for(var i=1;i<num+1;i++)
				 	{
						$("#stream_num").append("<option value='"+i+"'>"+i+"</option>");		 
					}
					//set default stream_id is 1
					$("#stream_id").val("1")
				 }
				 else
				 {
					$("#stream_num").append("<option selected='selected' value='1'>1</option>"); 
				 }
							
			  }		 	
 		   })//ajax end		
	}
	function initStreamNumSingle(ip)
	{	
		var encoderType = $("#encoderType").val();
		 $.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{action:'stream_num_get','encoder_ip':ip,encoderType:encoderType},				  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {	
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }			  	
				 var num = obj.stream_num;			  
				 $("#stream_num_single").val(num);							
			  }		 	
 		   })//ajax end		
	}
	
	function initStreamInfoSet(stream_id,ip)
	{
		var encoderType = $("#encoderType").val();
		//初使化
		$.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{'action':'stream_info_get','stream_id':stream_id,"encoder_ip":ip,encoderType:encoderType},			  
			  //处理CGI返回的JSON数据
			  success: function(data)
			  {		
				 var obj;
				 try
				 {
					 obj = $.parseJSON(data);
				 }
				 catch(e)
				 {
					 alert("编码器通讯失败,数据获取失败,请重新尝试!");
				 }				  
				 var s_protocol = obj.protocol;	
				 var jsonData = obj;
				 if(s_protocol == 1)
					s_protocol = "hls";
				 else if (s_protocol == 2)
					s_protocol = "rtmp";
				 else if (s_protocol == 3)
					s_protocol = "ts";
					 
				 
				 
				 //init current protocol;				
				 if(s_protocol == "rtmp")
				 {
				 	$("#protocol").val("2");
				 	$("#rtmp_stream_id").val(stream_id);
				 }
				 else if(s_protocol == "ts")
				 {				 
				 	$("#protocol").val("3");
				 	$("#ts_stream_id").val(stream_id);
				 }	
				 else if(s_protocol == "hls")
				 {
				 	$("#protocol").val("1");
				 	$("#hls_stream_id").val(stream_id);
				 }	
				
				//init the ip
				$("#stream_rtmp_set_ip").val(ip);
				$("#stream_ts_set_ip").val(ip);
				$("#stream_hls_set_ip").val(ip);
				$("#stream_info_set_ip").val(ip);		
				
				//根据流协议 初使化界面				
				protocol_select(s_protocol,jsonData);
				
				var cur_select_option = $("#stream_name").val();
				check_live_status(cur_select_option);
						
			  }		 	
 		   })//ajax end	
		
	}
	
	
	//打开与关闭不同流的视频窗口设置
	
	// encoder set
	function encoder_set_open(encoder_ip)
	{	
		$("#encoder_set_outer").dialog("open");
		initEncoderSet(encoder_ip);
		//初使化 表单中的 隐藏 ip字段
		$("#encode_set_ip").val(encoder_ip);
		$("#encode_high_set_ip").val(encoder_ip);
		
	}
	function encoder_set_close()
	{	
		$("#encoder_set_outer").dialog("close");
	}
	function encoder_high_set_open(flag)
	{
		//设置隐藏域中的 road_nu
		var ip = $("#encoder_set_ip").val();			
		initHighSet(ip);
		$("#road_num_high").val(flag);
		
		$("#encoder_high_set_outer").dialog("open");			
	}
	function encoder_high_set_close()
	{
		$("#encoder_high_set_outer").dialog("close");
	}
	// audio set
	function audio_set_open(encoder_ip)
	{	
		$("#audio_set_outer").dialog("open");
		$("#audio_set_ip").val(encoder_ip);
		initAudioSet(encoder_ip);
	}
	function audio_set_close()
	{	
		$("#audio_set_outer").dialog("close");
	}
	//video set
	function video_resource_set_open(encoder_ip)
	{	
		$("#video_resource_set_outer").dialog("open");
		$("#video_resource_set_ip").val(encoder_ip)
		initResourceSet(encoder_ip);
	}
	function video_resource_set_close()
	{	
		$("#video_resource_set_outer").dialog("close");
	}
	
	function stream_info_set_open(encoder_ip)
	{	
		$("#stream_info_set_ip").val(encoder_ip);
		$("#stream_info_set_outer").dialog("open");		
		
		initStreamNum(encoder_ip);
		
		//init the first stream
		initStreamInfoSet(1,encoder_ip);			
		
	}
	function stream_info_set_close()
	{	
		$("#stream_info_set_outer").dialog("close");
	}
	function stream_num_set_open(encoder_ip)
	{	
		$("#stream_num_set_ip").val(encoder_ip);
		$("#stream_num_set_outer").dialog("open");
		initStreamNumSingle(encoder_ip);					
	}
	function stream_num_set_close()
	{	
		$("#stream_num_set_outer").dialog("close");
	}
	
	
		
	
	

	
	
//****************下面是每个页面各自调用的函数****************************//
	
//**********audio page
function audioChange(value)
{	
	//外置
	if(value==2)
	{
		$("#audio_sampling_rate").empty();
		
		//var option1 = "<option value='11025'>11025</option>";
		var option2 = "<option value='22050'>22050</option>";
		var option3 = "<option value='44100'>44100</option>";
		var option4 = "<option value='48000'>48000</option>";
		var option5 = "<option value='50000'>50000</option>";
		var option6 = "<option value='96000'>96000</option>";
		//var option7 = "<option value='192000'>192000</option>";
		
		$("#audio_sampling_rate").prepend(option2).prepend(option3).prepend(option4).prepend(option5);
	}
	//内嵌
	if(value==1)
	{
		$("#audio_sampling_rate").empty();	
		
		//var option1 = "<option value='11025'>11025</option>";
		var option3 = "<option value='44100'>44100</option>";
		var option4 = "<option value='48000'>48000</option>";
		//var option7 = "<option value='192000'>192000</option>";
		$("#audio_sampling_rate").prepend(option3).prepend(option4);
	}
	
}

//**********encoder page
//比较两个分辨率的大小
function cmpstr(str1,str2)
{
	var index1 = str1.indexOf("x");
	var firstNum1 = str1.substring(0,index1);
	var firstNum2 = str1.substring(index1+1);
	var total1 = parseInt(firstNum1)+parseInt(firstNum2);	
	
	var index2 = str2.indexOf("x");
	var secondNum1 = str2.substring(0,index2);
	var secondNum2 = str2.substring(index2+1);
	var total2 = parseInt(secondNum1)+parseInt(secondNum2);
	
	if(total1>total2)
		return 1;
	else if(total1<total2)
		return -1;
	else if(total1==total2)
		return 0;	
}
//自定义分辨率窗口中的确定事件
function costom_dpi_sure(stream_id)
{
	var x_ = $("#custom_dpi_x").val();
	var y_ = $("#custom_dpi_y").val();
	var dpi = x_+"x"+y_;			
	var obj_option = "<option selected value='"+dpi+"'>"+dpi+"</option>";
		
	$("#trigger_custom_dpi"+stream_id).prev().prepend(obj_option);
	$("#trigger_custom_dpi"+stream_id).prev().val(dpi);
			
	$("#custom_dpi_set").dialog("close");			
}

//打开与关闭不同流的自定义分辨率窗口设置
function custom_dpi_open(flag)
{
	 $("#sure_dpi").attr("name",flag);
	 $("#custom_dpi_set").dialog("open");	
}
function custom_dpi_close()
{
	$("#custom_dpi_set").dialog("close");
}
//**********处理流详情**************
//********************************
//********************************
function protocol_select(value,json_data)
{	
	if(stream_id == undefined)
	{
		stream_id = $("#stream_id").val();
		//alert("stream_id:"+stream_id);
	}
	
	if(value == "hls" || value == "1")// HLS 流
	{		
	  $("#hls_outer").css("display","");
	  $("#rtmp_outer").css("display","none");
	  $("#ts_outer").css("display","none");
	  $("#pub_button_outer").css("display","none");
	  if(json_data != undefined)
	  {
		initHLS(json_data);
	  }
	  else 
	  {
	  	//init vid_num and init aud num
   		init_vid_num(0,"hls",$("#stream_hls_set_ip").val());
		init_aud_num(0,"hls",$("#stream_hls_set_ip").val());
	  }
	  
	}
	else if(value == "rtmp" || value == "2")//RTMS
	{
	  $("#hls_outer").css("display","none");
	  $("#rtmp_outer").css("display","");
	  $("#ts_outer").css("display","none");
	  $("#pub_button_outer").css("display","");
	  if(json_data != undefined)
	  {
	  	initRTMP(json_data);
	  }
	  else 
	  {
	  	//init vid_num and init aud num
   		init_vid_num(0,"rtmp",$("#stream_rtmp_set_ip").val());
		init_aud_num(0,"rtmp",$("#stream_rtmp_set_ip").val());
	  }
	
	}
	else if(value == "ts" || value == "3") //TS
	{
	  $("#hls_outer").css("display","none");
	  $("#rtmp_outer").css("display","none");
	  $("#ts_outer").css("display","");
	  $("#pub_button_outer").css("display","none");
	  if(json_data != undefined)
	  {
	  	initTS(json_data);
	  }
	  else 
	  {
	  	//init vid_num and init aud num
   		init_vid_num(0,"ts",$("#stream_ts_set_ip").val());
		init_aud_num(0,"ts",$("#stream_ts_set_ip").val());
	  }
	}		
}

function initHLS(data)
{
	  	 //alert(data);
	  	 var obj = data;			
		 var vid_num = obj.vid_num;
		 var aud_num = obj.aud_num;				
		 var open_close = obj.open_close;
		 var segment_length = obj.segmentLength;
		 var segment_count = obj.segment_count;
		 var m3u8Name = obj.m3u8Name;
		 var segment_prefix = obj.segment_prefix;
		 var http_prefix = obj.http_prefix;				
		
		//init vid_num and init aud num
		init_vid_num(vid_num,"hls",$("#stream_hls_set_ip").val());
		init_aud_num(aud_num,"hls",$("#stream_hls_set_ip").val());		
	   
			 
		//HLS 			
		 $("#segment_length").val(segment_length);
		 $("#segment_count").val(segment_count);
		 $("#m3u8Name").val(m3u8Name);
		 $("#segment_prefix").val(segment_prefix);
		 $("#http_prefix").val(http_prefix);
		
		//公共是打开或者是关闭
		if(open_close == 1)
		{						
			 $("#hls_open").attr("checked","checked");
			 $("#hls_close").removeAttr("checked");
		}
		else
		{
			$("#hls_open").removeAttr("checked");
			$("#hls_close").attr("checked","checked");
		}
}
function initRTMP(data)
{

  	 var obj = data;				 
	 
	 var stream_name = obj.stream_name;
	 var svraddr1 = obj.svraddr1;
	 var svraddr2 = obj.svraddr2;
	 var save = obj.save;
	 var ser_name = obj.ser_name;
	 var ser_pwd = obj.ser_pwd;
	 var vid_num = obj.vid_num;
	 var aud_num = obj.aud_num;				
	 var open_close = obj.open_close;			
		 
	//init stream name
	$("#stream_name").val($.trim(stream_name));
	
	$("#cur_svraddr1").text(svraddr1);
	$("#cur_stream_name").text(stream_name);
	
	//init rtmp addr
	var ip = $("#svraddr1").val();
	var port = $("#rtmpPort").val();
	
	var noProtocol_index = ip.indexOf("rtmp://")+7;
	var noProtocol_value =  ip.substring(noProtocol_index);							
	var last_port_index = noProtocol_value.lastIndexOf(":");
	//为流默认添加上端口号1935
	if(last_port_index==-1)
	{
		$("#svraddr1").val(ip+":"+port);
	}								
	else
	{
		$("#svraddr1").val(ip);	
	}						
	
	
	
	
					
	//svae
	 if(save == 0) //不保存
		$("#svae").val(0);
	 else if(save == 1)
	 	$("#svae").val(1);					
	//ser_name
	$("#ser_name").val($.trim(unescape(ser_name)));				
	//ser_pwd
	$("#ser_pwd").val($.trim(unescape(ser_pwd)));
	
	//init vid_num and init aud num
   	init_vid_num(vid_num,"rtmp",$("#stream_rtmp_set_ip").val());
	init_aud_num(aud_num,"rtmp",$("#stream_rtmp_set_ip").val());			
	
	//公共是打开或者是关闭
	if(open_close == 1)
	{						
		 $("#rtmp_open").attr("checked","checked");
		 $("#rtmp_close").removeAttr("checked");
	}
	else
	{
		$("#rtmp_open").removeAttr("checked");
		$("#rtmp_close").attr("checked","checked");
	}
	
}
function initTS(data)
{

  	 //alert(data);
  	 var obj = data;
	 var vid_num = obj.vid_num;
	 var aud_num = obj.aud_num;					
	 var ts_ip = obj.ts_ip;
	 var ts_port = obj.ts_port;
	 var open_close = obj.open_close;
		 
	//TS				
	$("#ts_ip").val(ts_ip);
	$("#ts_port").val(ts_port);	
	
	//init vid_num and init aud num
   init_vid_num(vid_num,"ts",$("#stream_ts_set_ip").val());
   init_aud_num(aud_num,"ts",$("#stream_ts_set_ip").val());			
	
	//公共是打开或者是关闭
	//公共是打开或者是关闭
	if(open_close == 1)
	{						
		 $("#ts_open").attr("checked","checked");
		 $("#ts_close").removeAttr("checked");
	}
	else
	{
		$("#ts_open").removeAttr("checked");
		$("#ts_close").attr("checked","checked");
	}
 			
}

function init_vid_num(vid_num,type,ip)
{
	var encoderType = $("#encoderType").val();
	
	$.ajax({
		  type: "POST",
		  url: "/admin/live/EncoderOnlineServlet",		 
		  data:{action:'road_num_get',"encoder_ip":ip,"encoderType":encoderType},			  
 		 //处理CGI返回的JSON数据
 		 success: function(data)
 		 {
			var road_num = parseInt($.trim(data));
			$("#vid_num_"+type).empty();
			$("#vid_num_"+type).prepend("<option value='-1'>无通道</option>");
		 	for(var i=0;i<road_num;i++)
			{							
				if(vid_num == i)
				{
				  $("#vid_num_"+type).prepend("<option selected='selected' value='"+i+"'>编码"+(i+1)+"</option>");								
				  setTimeout(function(){ 
							  $("#vid_num_"+type).val(vid_num); 
					},1000);							 
				}							
				else
				{
					$("#vid_num_"+type).prepend("<option value='"+i+"'>编码"+(i+1)+"</option>");
				}							
			}						
		 }
		});		
}
function init_aud_num(aud_num,type,ip)
{
	var encoderType = $("#encoderType").val();
	//aud_num
	$.ajax({
		  type: "POST",
		  url: "/admin/live/EncoderOnlineServlet",			 
		  data:{action:'audio_open',"encoder_ip":ip,"encoderType":encoderType},		 
  
 		 //处理CGI返回的JSON数据
 		 success: function(data)
 		 {			  				 		
			var audio_open_status = parseInt($.trim(data));						
			//close the audio
			if(audio_open_status == 2)
			{		
				 // set the select is empty
				  $("#aud_num_"+type).empty();			
				  $("#aud_num_"+type).prepend("<option value='-1'>无</option>");							  
			}
			//initialize
			setTimeout(function(){ 
							  $("#aud_num_"+type).val(aud_num); 
					},1000);			
		 }
		});			 	
}

function select_stream_num(stream_num)
{
		var ip = $("#stream_info_set_ip").val();	
		//init the default stream_id
		$("#stream_id").val(stream_num);
		initStreamInfoSet(stream_num,ip);		
}
function sync(flag)
{
	if(flag)
	{
		$("#sync").val("true")
	}
	else
	{
		$("#sync").val("false");
	}
}
function get_all_status(ip,sign)
{
	var flag = $("#sync").val();
	if(flag == "true")
	{
		$("div[name=status]").each(function(){	
			var ip = $(this).attr("title");
			var sign = $(this).attr("id");
			get_status(ip,sign);	
		});
	}
	else 
	{
		get_status(ip,sign);
	}
	
}

function get_status(ip,sign)
{
	
	var encoderType = $("#encoderType").val();
	if(encoderType == "local")
		return ;
	
	
	 var status = "error";	
	 var time = setInterval(function(){ 
	 
		 var count_str = $("#store_count").val();	  
		 var count = parseInt(count_str);
		 var encoderType = $("#encoderType").val();
	 
	 	$.ajax({
			  type: "POST",
			  url: "/admin/live/EncoderOnlineServlet",			 
			  data:{action:'get_status',"encoder_ip":ip,"encoderType":encoderType},  
	 		 //处理CGI返回的JSON数据
	 		 success: function(data)
	 		 {		 		  				 		
				status = data;				
				if(status == "ok")
				{				
				  $("#"+sign).css("color","#a40606");
				  $("#"+sign).text("信息设置成功");
				  clearInterval(time);
				  
				  setTimeout(function(){				  
				 	$("#"+sign).css("color","#000");
					$("#"+sign).text("无信息处理");				  
				  },5000);						
				}	
				
				if(status == "error")
				{
				  count++;
				  $("#store_count").val(count);				  
				  $("#"+sign).css("color","#a40606");
				  $("#"+sign).text("信息设置中...");
				  
				  if($("#store_count").val() == 15)
				  {
				  		clearInterval(time);				 	
				 		$("#"+sign).css("color","#a40606");
						$("#"+sign).text("信息设置失败...");
				   }		
				}		
			 }
		}); 
	 },1000)//end interval
}

function init_rtmp_port()
{
	$.ajax({
			  type: "POST",
			  url: "/admin/live/LiveServlet",			 
			  data:{action:'ip_port'},  
	 		 //处理CGI返回的JSON数据
	 		 success: function(data)
	 		 {		 
				var obj = $.parseJSON(data);
				var port = obj.port;
	 		 	$("#rtmpPort").val(port); 				 		
			 }
			 
		  });
}
/**
 * 初使化流名称选择select中的内容
 * @param cur_stream_name
 * @return
 */
function init_stream_name_sel(cur_stream_name)
{
	$.ajax({
			  type: "POST",
			  url: "/admin/live/LiveServlet",
			  async:false, //同步执行
			  data:{action:'list'},  
	 		 //处理CGI返回的JSON数据
	 		 success: function(data)
	 		 {	
	 		 	var obj = $.parseJSON(data);
	 		 	
 		 		if(obj != null && obj.length>0)
	 		 	{
	 		 		for(var i=0;i<obj.length;i++)
	 		 		{
		 		 		var live = obj[i];
		 		 		var liveStatus = live.liveStatus;
		 		 		var appName = live.appName;
		 		 		var name = live.name;
		 		 		var stream_name = appName+"/"+name;
		 		 		
		 		 		var option = "<option liveStatus='"+liveStatus+"' value='"+stream_name+"'>"+stream_name+"</option>";
		 		 		$("#stream_name").append(option);
	 		 		}
	 		 	}
	 		 	
			 }
			 
		  });
}
/**
 * 验证当前的流名称是否正在直播，如果正在直播，则发生警告
 * @param value
 * @return
 */
function check_live_status(value)
{
	var cur_select_option = value;
	
	$("#stream_name option").each(function(){
		
		if($(this).attr("value") == cur_select_option)
		{
			if($(this).attr("liveStatus") == "true")
			{
				$("#live_warn").text("当前流正在直播,可能会拒绝推流!");
			}
			else
			{
				$("#live_warn").text("");
			}
		}
	});
}
/**
 * 初使化编码器的类型,是本地编码器还是远程编码器,然后将值更新到隐藏域 <input type="encoder_type">
 * @return
 */
function init_encoder_type()
{
	var location = window.location.href;
	if(location.indexOf("customEncoderList") != -1)
	{
		$("input[name='encoderType']").each(function(){
			$(this).val("local");
		})
		
		$("#encoderType").val("local");
	}
	
}


