
/**
 *
 * @param play_url
 * @param width
 * @param height
 * @param player_type 使用什么播放器进行播放，默认为ckplayer,若有值则为混合播放即HTTP使用CKPLAYER,RTMP使用默认播放器
 * @returns {string} 返回创建播放器的DOM元素
 */
function embed_flash_player(play_url,width,height,player_type)
{
    var host = window.location.hostname;
    var port = window.location.port;
    var dom = "";


    //初使化播放器的宽度和高度
    if(width == undefined || height == undefined ||width == "" || height == "" )
    {
        width = 400;
        height = 300;
    }
    //初使化播放器的类型
    if(player_type == undefined || player_type =="")
    {
        player_type = "ckplayer";
    }
    else
    {
        player_type = "default";
    }

    //初使化swfpath路径
    var ckplayer_swfpath = "";
    var default_swfpath = "";
    if(port == "")
    {
        ckplayer_swfpath = "http://"+host+"/ckplayer/ckplayer.swf";
        default_swfpath = "http://"+host+"/StrobeMediaPlayback.swf";
    }
    else
    {
        ckplayer_swfpath = "http://"+host+":"+port+"/ckplayer/ckplayer.swf";
        default_swfpath = "http://"+host+":"+port+"/StrobeMediaPlayback.swf";
    }
    //初使化CKPLAYER播放视频类型
    var videoType = 1;//flv is 1,mp4 is 2
    if(play_url.indexOf("mp4") != -1)
    {
        videoType = 2;
    }

    //为firebug打印日志
    console.log("embed_flash_player===play_url:%s,width:%s,height:%s",play_url,width,height);

    if(player_type = "ckplayer" )
    {
       dom = get_ckplayer_dom(play_url,ckplayer_swfpath,videoType,width,height);
    }
    else if(player_type == "default")
    {
       dom = get_default_player_dom(play_url,default_swfpath,"vod",width,height);
    }

    return dom;
}

/**
 *
 * @param play_url
 * @param width
 * @param height
 * @param player_type 使用什么播放器进行播放，默认为ckplayer,若有值则为混合播放即HTTP使用CKPLAYER,RTMP使用默认播放器
 */
function init_share_player(play_url,width,height,player_type)
{
    var dom = embed_flash_player(play_url,width,height,player_type);

    dom = dom.replace(/[ ]/g,"");//去掉空格
    dom = dom.replace(/[\r\n]/g,"");//去掉回车符
    var share_dom = '<div style="margin-bottom:5px;color: #000; float: left">引用地址&nbsp;<input type="text" style="border: 1px solid #bac7d2;" value="'+dom+'" id="addr" name="addr"  size="70"></div>';
    var js = "<script>$(function(){$('#addr').focus();$('#addr').select();$('#addr').focus(function(){$(this).select()})})</script>"
    return share_dom+js;
}
/**
 * 获取CKPLAYER播放时的DOM元素
 * @param play_url
 * @param swfpath
 * @param videoType   videoType = 1;//flv videoType = 2;//mp4
 * @param width
 * @param height
 * @returns {string|*}
 */
function get_ckplayer_dom(play_url,swfpath,videoType,width,height)
{

    dom = "<object style='background:#000'  width='"+width+"' height='"+height+"' align='middle' name='StrobeMediaPlayback_object'  id='StrobeMediaPlayback_object' codebase='http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0' type='application/x-shockwave-flash' classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000' pluginspage='http://www.macromedia.com/go/getflashplayer'>";
    dom+="<param name='movie' value='"+swfpath+"' />";
    dom+="<param name='quality' value='high' />";
    dom+="<param name='bgcolor' value='#000000' />";
    dom+="<param name='allowfullscreen' value='true' />";
    dom+="<param name='flashvars'	value='f="+play_url+"&s=0&e=1&p=1&wh=4:3&h="+videoType+"' />";
    dom+="<embed style='background:#000' src='"+swfpath+"' width='"+width+"' height='"+height+"' align='middle' id='StrobeMediaPlayback_embed' quality='high'";
    dom+="bgcolor='#000000' name='StrobeMediaPlayback_embed' allowfullscreen='true'";
    dom+="pluginspage='http://www.adobe.com/go/getflashplayer' ";
    dom+="flashvars='f="+play_url+"&s=0&e=1&p=1&wh=4:3&h="+videoType+"'";
    dom+="type='application/x-shockwave-flash'>";
    dom+="</embed>";
    dom+="</object>";
    return dom;

}
/**
 * 获取默认FLASH播放器的DOM元素
 * @param play_url
 * @param swfpath
 * @param streamType  vod为点播  live为直播
 * @param width
 * @param height
 * @returns {string|*}
 */
function get_default_player_dom(play_url,swfpath,streamType,width,height)
{
    play_url = play_url.replace("|","/");
    var swfpath = "/StrobeMediaPlayback.swf";
    dom = "<object style='background:#000' wmode='transparent' width='"+width+"' height='"+height+"'  id='StrobeMediaPlayback_object_' type='application/x-shockwave-flash' classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000'>";
    dom+="<param name='movie' value='"+swfpath+"' />";
    dom+="<param name='quality' value='high' />";
    dom+="<param name='bgcolor' value='#000000' />";
    dom+="<param name='allowfullscreen' value='true' />";
    dom+="<param name='flashvars'	value='&src="+play_url+"&autoHideControlBar=true&streamType=vod&autoPlay=true' />";
    dom+="<embed style='background:#000' wmode='transparent' src='"+swfpath+"' width='"+width+"' height='"+height+"' id='StrobeMediaPlayback_embed' quality='high'";
    dom+="bgcolor='#000000' name='StrobeMediaPlayback' allowfullscreen='true'";
    dom+="pluginspage='http://www.adobe.com/go/getflashplayer'";
    dom+="flashvars='&src="+play_url+"&autoHideControlBar=true&streamType=vod&autoPlay=true'";
    dom+="type='application/x-shockwave-flash'>";
    dom+="</embed>";
    dom+="</object>";

    return dom;


}
