var compact2string = require('compact2string')
var test = require('tape')

var string2compact = require('../')

test('single', function (t) {
  var compact = string2compact('10.10.10.5:65408')
  t.deepEqual(compact, new Buffer('0A0A0A05FF80', 'hex'))
  t.end()
})

test('multi', function (t) {
  // For this test, we assume that the compact2string implementation is good and just run
  // the conversion in reverse and see if we get the same thing back
  var ips = [ '127.0.0.1:6881', '127.0.0.1:6882' ]
  t.deepEqual(compact2string.multi(string2compact(ips)), ips)
  t.end()
})

test('mutli (byte check)', function (t) {
  var compacts = string2compact([ '10.10.10.5:128', '100.56.58.99:28525' ])
  t.deepEqual(compacts, new Buffer('0A0A0A05008064383a636f6d', 'hex'))
  t.end()
})
