var Client = require('../')
var fs = require('fs')
var parseTorrent = require('parse-torrent')
var portfinder = require('portfinder')
var Server = require('../').Server
var test = require('tape')

var torrent = fs.readFileSync(__dirname + '/torrents/sintel-5gb.torrent')
var parsedTorrent = parseTorrent(torrent)
var peerId = new Buffer('01234567890123456789')

test('large torrent: client.start()', function (t) {
  t.plan(6)

  var server = new Server({ http: false })

  server.on('error', function (err) {
    t.fail(err.message)
  })

  server.on('warning', function (err) {
    t.fail(err.message)
  })

  portfinder.getPort(function (err, port) {
    t.error(err, 'found free port')
    server.listen(port)

    // remove all tracker servers except a single UDP one, for now
    parsedTorrent.announce = [ 'udp://127.0.0.1:' + port + '/announce' ]

    var client = new Client(peerId, 6881, parsedTorrent)

    client.on('error', function (err) {
      t.error(err)
    })

    client.once('update', function (data) {
      t.equal(data.announce, 'udp://127.0.0.1:' + port + '/announce')
      t.equal(typeof data.complete, 'number')
      t.equal(typeof data.incomplete, 'number')
    })

    client.start()

    client.once('peer', function (addr) {
      t.pass('there is at least one peer') // TODO: this shouldn't rely on an external server!

      client.stop()

      client.once('update', function () {
        server.close(function () {
          t.pass('server close')
        })
      })

    })
  })
})
