% AMT - Core functions
%
%   Installation and session management
%     AMT_MEX - Compile binaries (Mex/Oct interfaces)
%     AMT_STOP - Stop the AMT session and remove all AMT paths
%
%   General functions
%     AMT_CACHE - Cache variables for later or retrieves variables from cache
%     AMT_DISP - AMT-specific overload of the function 'disp'
%     AMT_EMUEXP - Emulate psychoacoustic experiments
%     AMT_FLAGS - Return the start-up flags of the AMT
%     AMT_LOAD - Load auxiliary data of a model
%     AMT_SUBDIR - Perform a recursive file search
%     AMT_EXTERN - Execute functions in an external environment (e.g., Python)
%
%   Paths and configuration
%     AMT_CONFIGURATION - Return the configuration of the AMT
%     AMT_AUXDATAPATH - Local path to the auxiliary data
%     AMT_AUXDATAURL - Return and sets the URL of the web address containing auxiliary data
%     AMT_BASEPATH - Return the base path of the AMT installation
%     AMT_VERSION - Return the version number
%     AMT_INFO - Display the license, technical requirements, status, and authors of a model or modelstage
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/core/Contents.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

