function definput=arg_verhulst2018(definput)
% ARG_VERHULST2018
%
%   #License: GPL
%   #Author: Piotr Majdak (2021)
%% General
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/defaults/arg_verhulst2018.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
definput.flags.disp = {'no_debug','debug'}; % flag to provide debugging information when model called with 'debug', see amt_disp
definput.flags.ihc  = {'ihc','no_ihc'};
definput.flags.an   = {'an','no_an'}; 
definput.flags.cn   = {'cn','no_cn'}; 
definput.flags.ic   = {'ic','no_ic'};
definput.flags.mfb  = {'no_mfb','mfb'};
definput.flags.oae    = {'oae','no_oae'};

%% Outer and middle ear
definput.flags.outerear = {'no_outerear' ,'outerear'};
definput.flags.middleear= {'middleear','no_middleear','jepsen2008'};

%% cochlear filterbank parameters

definput.keyvals.hearing_profile = 'Flat00'; % hearing profile
definput.keyvals.subject= 1; % to control randomness in cochlear irregularities
definput.keyvals.irr_on = 1; % irregularities on (1) or off (0)
definput.keyvals.non_linear_type = 'vel'; % ???
definput.keyvals.IrrPct = 0.05;
definput.keyvals.fs_up  = 100000;

%% IHC
definput.keyvals.ihc_scal_constant=0.118;

%% AN
definput.keyvals.numH = 13; % default number of high-spontaneous rate neurones
definput.keyvals.kSR_H  = 68.5; % spikes/s, spontaneous rate
definput.keyvals.kmax_H = 3000; % Peak exocytosis rate [spikes/s]

definput.keyvals.numM =  3; % default number of medium-spontaneous rate neurones
definput.keyvals.kSR_M  = 10; % spikes/s, spontaneous rate
definput.keyvals.kmax_M = 1000; % Peak exocytosis rate [spikes/s]

definput.keyvals.numL =  3; % default number of low-spontaneous rate neurones
definput.keyvals.kSR_L  = 1; % spikes/s, spontaneous rate
definput.keyvals.kmax_L = 800; % Peak exocytosis rate [spikes/s]

definput.flags.anfH = {'anfH','no_anfH'};
definput.flags.anfM = {'anfM','no_anfM'};
definput.flags.anfL = {'anfL','no_anfL'};
%% Brainstem (CN and IC)
definput.keyvals.model_version = 1.20;
definput.keyvals.version_year = 2018;
definput.keyvals.M1 = 4.2767e-14;
definput.keyvals.M3 = 5.1435e-14;
definput.keyvals.M5 = 13.3093e-14;

definput.keyvals.Tex_cn = 0.5e-3; % Tau excitation
definput.keyvals.Tin_cn = 2e-3; % Tau inhibition
definput.keyvals.dly_cn = 1e-3; % dly ms
definput.keyvals.Acn    = 1.5;
definput.keyvals.Scn    = 0.6;

definput.keyvals.Tex_ic = 0.5e-3; % Tau excitation
definput.keyvals.Tin_ic = 2e-3; % Tau inhibition
definput.keyvals.dly_ic = 2e-3; % dly ms
definput.keyvals.Aic    = 1.0;
definput.keyvals.Sic    = 1.5;
definput.keyvals.subfs  = 20000;

%% Remainings from Alejandro branch
%definput.groups.abr_verhulst2018 = {'an','cn','ic','no_e','no_disp','no_ihc'}; % default
%definput.groups.ic_verhulst2018  = {'no_ihc','no_an','no_cn','ic','no_e','no_disp'};
% definput.groups.store_all = {'an','cn','ic','e','disp','ihc','no_mfb', ...
%                              'model_version',1.2,'version_year',2018}; % default

