%DEMO_BARUMERLI2021 Demo for full sphere localization model from Barumerli et al. (2021)
%
%   DEMO_BARUMERLI2021(flag) demonstrates how to compute and visualize 
%   the baseline prediction (localizing broadband sounds with own ears) 
%   on the full sphere using the localization model from Barumerli et al. (2021).
%
%   Figure 1: Baseline prediction
% 
%      This demo computes the baseline prediction (localizing broadband 
%      sounds with own ears) for an exemplary listener (NH12).
%
%      Averaged polar and lateral accuracy
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/demos/demo_barumerli2021.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

%   See also: barumerli2021 exp_barumerli2021 barumerli2021
% AUTHOR : Roberto Barumerli

error('This demo is not fully implemented yet. Sorry!'); 

data_majdak = data_majdak2010('Learn_M');
data_majdak = data_majdak(6);

sofa_obj = SOFAload(fullfile(SOFAdbPath,'barumerli2021',['ARI_NH12_hrtf_M_dtf 256.sofa']));

[template, target] = barumerli2021_featureextraction(sofa_obj, 'pge', 'monoaural');


m = barumerli2021(...
                'template', template, ...
                'target', target, ...
                'num_exp', 2, ...
                'sigma_lateral', 0.569, ...
                'sigma_lateral_bis', 0.7, ...
                'sigma_polar', 1.25, ...
                'sigma_prior', 11.5, ...
                'sigma_sensorimotor', 11);

% metrics
% real data 
real = barumerli2021_metrics(data_majdak.mtx, 'middle_metrics');


amt_disp('ACTUAL DATA')
amt_disp(sprintf('lateral_bias [°]:\t%0.2f', real.accL))
amt_disp(sprintf('lateral_rms_error [°]:\t%0.2f', real.rmsL))
amt_disp(sprintf('elevation_bias [°]:\t%0.2f', real.accP))
amt_disp(sprintf('local_rms_polar [°]:\t%0.2f', real.rmsP))
amt_disp(sprintf('quadrant_err [%%]:\t%0.2f', real.querr))

% simulated data
sim = barumerli2021_metrics(m, 'middle_metrics');

amt_disp(sprintf('\t\t\tSIM'))
amt_disp(sprintf('lateral_bias [°]:\t%0.2f', sim.accL))
amt_disp(sprintf('lateral_rms_error [°]:\t%0.2f', sim.rmsL))
amt_disp(sprintf('elevation_bias [°]:\t%0.2f', sim.accP))
amt_disp(sprintf('local_rms_polar [°]:\t%0.2f', sim.rmsP))
amt_disp(sprintf('quadrant_err [%%]:\t%0.2f', sim.querr))


% second test
% estimate one direction
targ_az = [0; 45];
targ_el = [0; 20];
target_single = barumerli2021_featureextraction(sofa_obj, 'pge', 'monoaural','target','targ_az', targ_az, 'targ_el', targ_el);

m = barumerli2021(...
                'template', template, ...
                'target', target_single, ...
                'num_exp', 1, ...
                'sigma_lateral', 0.569, ...
                'sigma_lateral_bis', 0.7, ...
                'sigma_polar', 1.25, ...
                'sigma_prior', 11.5, ...
                'sigma_sensorimotor', 11);

for i=1:size(targ_az,1)
    fprintf('target [az,el]: [%.2f, %.2f]\n', targ_az(i), targ_el(i))
    fprintf('\tresponse [az,el]: [%.2f, %.2f]\n', m(i, 3), m(i, 4))
end
