function out = plot_langendijk2002( p,rang,tang,varargin)
%plot_langendijk2002 plots pdf-matrixes with gray colormap according to Langendijk et al. (2002)
%   Usage:  plot_langendijk2002(p,rang,tang);
%
%   Input parameters:
%     p       : pdf-matrix for all target and response positions
%     rang    : response angles
%     tang    : target angles
%
%   PLOT_LANGENDIJK2002(p,rang,tang) plots predicted probability mass vectors
%   as a function of response angles rang and target angles tang with
%   gray color coded probabilities similar to Langendijk et al. (2002).
%
%   h=PLOT_LANGENDIJK2002(...) additionally returns the figure handle.
%
%   PLOT_LANGENDIJK2002 takes the following flags at the end of the line of input
%   arguments:
%
%     'colorbar'   Display the colorbar. This is the default.
%    
%     'no_colorbar'  Do not display the colorbar.
%
%   See also: langendijk2002
%
%   References:
%     E. Langendijk and A. Bronkhorst. Contribution of spectral cues to human
%     sound localization. J. Acoust. Soc. Am., 112:1583--1596, 2002.
%     
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/plot/plot_langendijk2002.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
% AUTHOR : Robert Baumgartner, OEAW Acoustic Research Institute

    definput.flags.colorbar={'colorbar','no_colorbar'};
    
    [flags,kv]=ltfatarghelper({},definput,varargin);

    pcolor(tang,rang,p);
    set(gcf,'Colormap',getlangecolormap);
    shading interp
    axis equal
    
    set(gca,'XTick',-60:30:240,...
      'YTick',-60:30:240,...
      'XLim',[tang(1)-5,tang(end)+5],'YLim',[rang(1)-5,rang(end)+5],...
      'Box','on')
    
    xlabel('Target Angle (°)')
    ylabel('Response Angle (°)')
    
    if flags.do_colorbar
        colorbar
    end
    
    out=gcf;
    
end

function langecmap = getlangecolormap()

langecmap= [ ...
 0.00000000e+00 0.00000000e+00 0.00000000e+00
 1.29821151e-02 1.29821151e-02 1.29821151e-02
 2.59642303e-02 2.59642303e-02 2.59642303e-02
 3.89463454e-02 3.89463454e-02 3.89463454e-02
 5.19284606e-02 5.19284606e-02 5.19284606e-02
 6.49105757e-02 6.49105757e-02 6.49105757e-02
 7.78926909e-02 7.78926909e-02 7.78926909e-02
 9.08748060e-02 9.08748060e-02 9.08748060e-02
 1.03856921e-01 1.03856921e-01 1.03856921e-01
 1.16839036e-01 1.16839036e-01 1.16839036e-01
 1.29821151e-01 1.29821151e-01 1.29821151e-01
 1.42803267e-01 1.42803267e-01 1.42803267e-01
 1.55785382e-01 1.55785382e-01 1.55785382e-01
 1.68767497e-01 1.68767497e-01 1.68767497e-01
 1.81749612e-01 1.81749612e-01 1.81749612e-01
 1.94731727e-01 1.94731727e-01 1.94731727e-01
 2.07713842e-01 2.07713842e-01 2.07713842e-01
 2.20695958e-01 2.20695958e-01 2.20695958e-01
 2.33678073e-01 2.33678073e-01 2.33678073e-01
 2.46660188e-01 2.46660188e-01 2.46660188e-01
 2.59642303e-01 2.59642303e-01 2.59642303e-01
 2.72624433e-01 2.72624433e-01 2.72624433e-01
 2.85606533e-01 2.85606533e-01 2.85606533e-01
 2.98588663e-01 2.98588663e-01 2.98588663e-01
 3.11570764e-01 3.11570764e-01 3.11570764e-01
 3.24552894e-01 3.24552894e-01 3.24552894e-01
 3.37534994e-01 3.37534994e-01 3.37534994e-01
 3.50517124e-01 3.50517124e-01 3.50517124e-01
 3.63499224e-01 3.63499224e-01 3.63499224e-01
 3.76481354e-01 3.76481354e-01 3.76481354e-01
 3.89463454e-01 3.89463454e-01 3.89463454e-01
 4.02445585e-01 4.02445585e-01 4.02445585e-01
 4.15427685e-01 4.15427685e-01 4.15427685e-01
 4.28409815e-01 4.28409815e-01 4.28409815e-01
 4.41391915e-01 4.41391915e-01 4.41391915e-01
 4.54374045e-01 4.54374045e-01 4.54374045e-01
 4.67356145e-01 4.67356145e-01 4.67356145e-01
 4.80338275e-01 4.80338275e-01 4.80338275e-01
 4.93320376e-01 4.93320376e-01 4.93320376e-01
 5.06302476e-01 5.06302476e-01 5.06302476e-01
 5.19284606e-01 5.19284606e-01 5.19284606e-01
 5.32266736e-01 5.32266736e-01 5.32266736e-01
 5.45248866e-01 5.45248866e-01 5.45248866e-01
 5.58230937e-01 5.58230937e-01 5.58230937e-01
 5.71213067e-01 5.71213067e-01 5.71213067e-01
 5.84195197e-01 5.84195197e-01 5.84195197e-01
 5.97177327e-01 5.97177327e-01 5.97177327e-01
 6.10159397e-01 6.10159397e-01 6.10159397e-01
 6.23141527e-01 6.23141527e-01 6.23141527e-01
 6.36123657e-01 6.36123657e-01 6.36123657e-01
 6.42429233e-01 6.42429233e-01 6.42429233e-01
 6.48734868e-01 6.48734868e-01 6.48734868e-01
 6.55040443e-01 6.55040443e-01 6.55040443e-01
 6.61346078e-01 6.61346078e-01 6.61346078e-01
 6.67651653e-01 6.67651653e-01 6.67651653e-01
 6.73957229e-01 6.73957229e-01 6.73957229e-01
 6.80262864e-01 6.80262864e-01 6.80262864e-01
 6.86568439e-01 6.86568439e-01 6.86568439e-01
 6.92874074e-01 6.92874074e-01 6.92874074e-01
 6.99179649e-01 6.99179649e-01 6.99179649e-01
 7.05485225e-01 7.05485225e-01 7.05485225e-01
 7.11790860e-01 7.11790860e-01 7.11790860e-01
 7.18096435e-01 7.18096435e-01 7.18096435e-01
 7.24402070e-01 7.24402070e-01 7.24402070e-01
 7.30707645e-01 7.30707645e-01 7.30707645e-01
 7.37013280e-01 7.37013280e-01 7.37013280e-01
 7.43318856e-01 7.43318856e-01 7.43318856e-01
 7.49624431e-01 7.49624431e-01 7.49624431e-01
 7.55930066e-01 7.55930066e-01 7.55930066e-01
 7.62235641e-01 7.62235641e-01 7.62235641e-01
 7.68541276e-01 7.68541276e-01 7.68541276e-01
 7.74846852e-01 7.74846852e-01 7.74846852e-01
 7.81152427e-01 7.81152427e-01 7.81152427e-01
 7.87458062e-01 7.87458062e-01 7.87458062e-01
 7.93763638e-01 7.93763638e-01 7.93763638e-01
 8.00069273e-01 8.00069273e-01 8.00069273e-01
 8.06374848e-01 8.06374848e-01 8.06374848e-01
 8.12680423e-01 8.12680423e-01 8.12680423e-01
 8.18986058e-01 8.18986058e-01 8.18986058e-01
 8.25291634e-01 8.25291634e-01 8.25291634e-01
 8.31597269e-01 8.31597269e-01 8.31597269e-01
 8.37902844e-01 8.37902844e-01 8.37902844e-01
 8.44208419e-01 8.44208419e-01 8.44208419e-01
 8.50514054e-01 8.50514054e-01 8.50514054e-01
 8.56819630e-01 8.56819630e-01 8.56819630e-01
 8.63125265e-01 8.63125265e-01 8.63125265e-01
 8.69430840e-01 8.69430840e-01 8.69430840e-01
 8.75736475e-01 8.75736475e-01 8.75736475e-01
 8.82042050e-01 8.82042050e-01 8.82042050e-01
 8.88347626e-01 8.88347626e-01 8.88347626e-01
 8.94653261e-01 8.94653261e-01 8.94653261e-01
 9.00958836e-01 9.00958836e-01 9.00958836e-01
 9.07264471e-01 9.07264471e-01 9.07264471e-01
 9.13570046e-01 9.13570046e-01 9.13570046e-01
 9.19875622e-01 9.19875622e-01 9.19875622e-01
 9.26181257e-01 9.26181257e-01 9.26181257e-01
 9.32486832e-01 9.32486832e-01 9.32486832e-01
 9.38792467e-01 9.38792467e-01 9.38792467e-01
 9.45098042e-01 9.45098042e-01 9.45098042e-01
 9.45447743e-01 9.45447743e-01 9.45447743e-01
 9.45797443e-01 9.45797443e-01 9.45797443e-01
 9.46147144e-01 9.46147144e-01 9.46147144e-01
 9.46496844e-01 9.46496844e-01 9.46496844e-01
 9.46846485e-01 9.46846485e-01 9.46846485e-01
 9.47196186e-01 9.47196186e-01 9.47196186e-01
 9.47545886e-01 9.47545886e-01 9.47545886e-01
 9.47895586e-01 9.47895586e-01 9.47895586e-01
 9.48245287e-01 9.48245287e-01 9.48245287e-01
 9.48594987e-01 9.48594987e-01 9.48594987e-01
 9.48944688e-01 9.48944688e-01 9.48944688e-01
 9.49294388e-01 9.49294388e-01 9.49294388e-01
 9.49644089e-01 9.49644089e-01 9.49644089e-01
 9.49993730e-01 9.49993730e-01 9.49993730e-01
 9.50343430e-01 9.50343430e-01 9.50343430e-01
 9.50693130e-01 9.50693130e-01 9.50693130e-01
 9.51042831e-01 9.51042831e-01 9.51042831e-01
 9.51392531e-01 9.51392531e-01 9.51392531e-01
 9.51742232e-01 9.51742232e-01 9.51742232e-01
 9.52091932e-01 9.52091932e-01 9.52091932e-01
 9.52441633e-01 9.52441633e-01 9.52441633e-01
 9.52791333e-01 9.52791333e-01 9.52791333e-01
 9.53141034e-01 9.53141034e-01 9.53141034e-01
 9.53490674e-01 9.53490674e-01 9.53490674e-01
 9.53840375e-01 9.53840375e-01 9.53840375e-01
 9.54190075e-01 9.54190075e-01 9.54190075e-01
 9.54539776e-01 9.54539776e-01 9.54539776e-01
 9.54889476e-01 9.54889476e-01 9.54889476e-01
 9.55239177e-01 9.55239177e-01 9.55239177e-01
 9.55588877e-01 9.55588877e-01 9.55588877e-01
 9.55938578e-01 9.55938578e-01 9.55938578e-01
 9.56288278e-01 9.56288278e-01 9.56288278e-01
 9.56637919e-01 9.56637919e-01 9.56637919e-01
 9.56987619e-01 9.56987619e-01 9.56987619e-01
 9.57337320e-01 9.57337320e-01 9.57337320e-01
 9.57687020e-01 9.57687020e-01 9.57687020e-01
 9.58036721e-01 9.58036721e-01 9.58036721e-01
 9.58386421e-01 9.58386421e-01 9.58386421e-01
 9.58736122e-01 9.58736122e-01 9.58736122e-01
 9.59085822e-01 9.59085822e-01 9.59085822e-01
 9.59435523e-01 9.59435523e-01 9.59435523e-01
 9.59785163e-01 9.59785163e-01 9.59785163e-01
 9.60134864e-01 9.60134864e-01 9.60134864e-01
 9.60484564e-01 9.60484564e-01 9.60484564e-01
 9.60834265e-01 9.60834265e-01 9.60834265e-01
 9.61183965e-01 9.61183965e-01 9.61183965e-01
 9.61533666e-01 9.61533666e-01 9.61533666e-01
 9.61883366e-01 9.61883366e-01 9.61883366e-01
 9.62233067e-01 9.62233067e-01 9.62233067e-01
 9.62582767e-01 9.62582767e-01 9.62582767e-01
 9.62932408e-01 9.62932408e-01 9.62932408e-01
 9.63282108e-01 9.63282108e-01 9.63282108e-01
 9.63631809e-01 9.63631809e-01 9.63631809e-01
 9.63981509e-01 9.63981509e-01 9.63981509e-01
 9.64331210e-01 9.64331210e-01 9.64331210e-01
 9.64680910e-01 9.64680910e-01 9.64680910e-01
 9.65030611e-01 9.65030611e-01 9.65030611e-01
 9.65380311e-01 9.65380311e-01 9.65380311e-01
 9.65730011e-01 9.65730011e-01 9.65730011e-01
 9.66079712e-01 9.66079712e-01 9.66079712e-01
 9.66429353e-01 9.66429353e-01 9.66429353e-01
 9.66779053e-01 9.66779053e-01 9.66779053e-01
 9.67128754e-01 9.67128754e-01 9.67128754e-01
 9.67478454e-01 9.67478454e-01 9.67478454e-01
 9.67828155e-01 9.67828155e-01 9.67828155e-01
 9.68177855e-01 9.68177855e-01 9.68177855e-01
 9.68527555e-01 9.68527555e-01 9.68527555e-01
 9.68877256e-01 9.68877256e-01 9.68877256e-01
 9.69226956e-01 9.69226956e-01 9.69226956e-01
 9.69576597e-01 9.69576597e-01 9.69576597e-01
 9.69926298e-01 9.69926298e-01 9.69926298e-01
 9.70275998e-01 9.70275998e-01 9.70275998e-01
 9.70625699e-01 9.70625699e-01 9.70625699e-01
 9.70975399e-01 9.70975399e-01 9.70975399e-01
 9.71325099e-01 9.71325099e-01 9.71325099e-01
 9.71674800e-01 9.71674800e-01 9.71674800e-01
 9.72024500e-01 9.72024500e-01 9.72024500e-01
 9.72374201e-01 9.72374201e-01 9.72374201e-01
 9.72723842e-01 9.72723842e-01 9.72723842e-01
 9.73073542e-01 9.73073542e-01 9.73073542e-01
 9.73423243e-01 9.73423243e-01 9.73423243e-01
 9.73772943e-01 9.73772943e-01 9.73772943e-01
 9.74122643e-01 9.74122643e-01 9.74122643e-01
 9.74472344e-01 9.74472344e-01 9.74472344e-01
 9.74822044e-01 9.74822044e-01 9.74822044e-01
 9.75171745e-01 9.75171745e-01 9.75171745e-01
 9.75521445e-01 9.75521445e-01 9.75521445e-01
 9.75871086e-01 9.75871086e-01 9.75871086e-01
 9.76220787e-01 9.76220787e-01 9.76220787e-01
 9.76570487e-01 9.76570487e-01 9.76570487e-01
 9.76920187e-01 9.76920187e-01 9.76920187e-01
 9.77269888e-01 9.77269888e-01 9.77269888e-01
 9.77619588e-01 9.77619588e-01 9.77619588e-01
 9.77969289e-01 9.77969289e-01 9.77969289e-01
 9.78318989e-01 9.78318989e-01 9.78318989e-01
 9.78668690e-01 9.78668690e-01 9.78668690e-01
 9.79018331e-01 9.79018331e-01 9.79018331e-01
 9.79368031e-01 9.79368031e-01 9.79368031e-01
 9.79717731e-01 9.79717731e-01 9.79717731e-01
 9.80067432e-01 9.80067432e-01 9.80067432e-01
 9.80417132e-01 9.80417132e-01 9.80417132e-01
 9.80766833e-01 9.80766833e-01 9.80766833e-01
 9.81116533e-01 9.81116533e-01 9.81116533e-01
 9.81466234e-01 9.81466234e-01 9.81466234e-01
 9.81815934e-01 9.81815934e-01 9.81815934e-01
 9.82165635e-01 9.82165635e-01 9.82165635e-01
 9.82515275e-01 9.82515275e-01 9.82515275e-01
 9.82864976e-01 9.82864976e-01 9.82864976e-01
 9.83214676e-01 9.83214676e-01 9.83214676e-01
 9.83564377e-01 9.83564377e-01 9.83564377e-01
 9.83914077e-01 9.83914077e-01 9.83914077e-01
 9.84263778e-01 9.84263778e-01 9.84263778e-01
 9.84613478e-01 9.84613478e-01 9.84613478e-01
 9.84963179e-01 9.84963179e-01 9.84963179e-01
 9.85312879e-01 9.85312879e-01 9.85312879e-01
 9.85662520e-01 9.85662520e-01 9.85662520e-01
 9.86012220e-01 9.86012220e-01 9.86012220e-01
 9.86361921e-01 9.86361921e-01 9.86361921e-01
 9.86711621e-01 9.86711621e-01 9.86711621e-01
 9.87061322e-01 9.87061322e-01 9.87061322e-01
 9.87411022e-01 9.87411022e-01 9.87411022e-01
 9.87760723e-01 9.87760723e-01 9.87760723e-01
 9.88110423e-01 9.88110423e-01 9.88110423e-01
 9.88460124e-01 9.88460124e-01 9.88460124e-01
 9.88809764e-01 9.88809764e-01 9.88809764e-01
 9.89159465e-01 9.89159465e-01 9.89159465e-01
 9.89509165e-01 9.89509165e-01 9.89509165e-01
 9.89858866e-01 9.89858866e-01 9.89858866e-01
 9.90208566e-01 9.90208566e-01 9.90208566e-01
 9.90558267e-01 9.90558267e-01 9.90558267e-01
 9.90907967e-01 9.90907967e-01 9.90907967e-01
 9.91257668e-01 9.91257668e-01 9.91257668e-01
 9.91607368e-01 9.91607368e-01 9.91607368e-01
 9.91957009e-01 9.91957009e-01 9.91957009e-01
 9.92306709e-01 9.92306709e-01 9.92306709e-01
 9.92656410e-01 9.92656410e-01 9.92656410e-01
 9.93006110e-01 9.93006110e-01 9.93006110e-01
 9.93355811e-01 9.93355811e-01 9.93355811e-01
 9.93705511e-01 9.93705511e-01 9.93705511e-01
 9.94055212e-01 9.94055212e-01 9.94055212e-01
 9.94404912e-01 9.94404912e-01 9.94404912e-01
 9.94754612e-01 9.94754612e-01 9.94754612e-01
 9.95104313e-01 9.95104313e-01 9.95104313e-01
 9.95453954e-01 9.95453954e-01 9.95453954e-01
 9.95803654e-01 9.95803654e-01 9.95803654e-01
 9.96153355e-01 9.96153355e-01 9.96153355e-01
 9.96503055e-01 9.96503055e-01 9.96503055e-01
 9.96852756e-01 9.96852756e-01 9.96852756e-01
 9.97202456e-01 9.97202456e-01 9.97202456e-01
 9.97552156e-01 9.97552156e-01 9.97552156e-01
 9.97901857e-01 9.97901857e-01 9.97901857e-01
 9.98251557e-01 9.98251557e-01 9.98251557e-01
 9.98601198e-01 9.98601198e-01 9.98601198e-01
 9.98950899e-01 9.98950899e-01 9.98950899e-01
 9.99300599e-01 9.99300599e-01 9.99300599e-01
 9.99650300e-01 9.99650300e-01 9.99650300e-01
 1.00000000e+00 1.00000000e+00 1.00000000e+00 ];
end


