function L=noshearlength(Ls,a,M,lt)
%NOSHEARLENGTH  Transform length that does not require a frequency shear
%   Usage: L=noshearlength(Ls,a,M,lt)
%
%   `noshearlength(Ls,a,M,lt)` computes the next larger transform length
%   bigger or equal to *Ls* for which the shear algorithm does not require
%   a frequency side shear for a non-separable Gabor system specified by
%   *a*, *M* and *lt*. 
%
%   This property makes computation of the canonical dual and tight Gabor
%   windows |gabdual| and |gabtight| and the |dgt| for a full length window
%   faster, if this transform length is choosen.
%
%   See also: matrix2latticetype, dgt, gabdual, gabtight

Lmin=dgtlength(1,a,M,lt);

if lt(1)==0
    Lsmallest=Lmin;
else
    c=gcd(a,M);
    
    % if lt(1)>0 then ks is everything in c which is relatively prime to
    % lt(2)
        
    kmax=c;
    while 1
        z=gcd(kmax,lt(2));
        if z==1
            break;
        end;
        kmax=kmax/z;
    end;

    Lsmallest=Lmin*c./kmax;

end;

L=ceil(Ls/Lsmallest)*Lsmallest;
