function coef=plotdgt(coef,a,varargin)
%PLOTDGT  Plot DGT coefficients
%   Usage: plotdgt(coef,a);
%          plotdgt(coef,a,fs);
%          plotdgt(coef,a,fs,dynrange);
%
%   `plotdgt(coef,a)` plots the Gabor coefficients *coef*. The coefficients
%   must have been produced with a time shift of *a*.
%
%   `plotdgt(coef,a,fs)` does the same assuming a sampling rate of
%   *fs* Hz of the original signal.
%
%   `plotdgt(coef,a,fs,dynrange)` additionally limits the dynamic range.
%
%   The figure generated by this function places the zero-frequency in
%   the center of the y-axis, with positive frequencies above and
%   negative frequencies below.
%   
%   `C=plotdgt(...)` returns the processed image data used in the
%   plotting. Inputting this data directly to `imagesc` or similar
%   functions will create the plot. This is useful for custom
%   post-processing of the image data.
%
%   `plotdgt` supports all the optional parameters of |tfplot|. Please see
%   the help of |tfplot| for an exhaustive list.
%
%   See also:  dgt, tfplot, sgram, plotdgtreal

%   AUTHOR : Peter L. Søndergaard.
%   TESTING: NA
%   REFERENCE: NA

complainif_notenoughargs(nargin,2,mfilename);
complainif_notposint(a,'a',mfilename);

definput.import={'ltfattranslate','tfplot'};
[flags,kv,fs]=ltfatarghelper({'fs','dynrange'},definput,varargin);

M=size(coef,1);

% Move zero frequency to the center and Nyquist frequency to the top.
if rem(M,2)==0
  coef=circshift(coef,M/2-1);
  yr=[-1+2/M, 1];
else
  coef=circshift(coef,(M-1)/2);
  yr=[-1+2/M, 1-2/M];
end;

coef=tfplot(coef,a,yr,'argimport',flags,kv);

if nargout<1
    clear coef;
end

