function [h,g,a,info] = wfilt_mband(N)
%WFILT_MBAND  Generates 4-band coder
%   Usage: [h,g,a] = wfilt_mband(N);
%
%   `[h,g,a]=wfilt_mband(1)` returns linear-phase 4-band filters
%   from the reference.
%
%   The filters are not actually proper wavelet filters, because the
%   scaling filter is not regular, therefore it is not stable under 
%   iterations (does not converge to a scaling function). 
%   
%
%   Examples:
%   ---------
%   :::
%
%     wfiltinfo('mband1');
%
%   References:  alkin95mband
%

% AUTHOR: Zdenek Prusa

a= [4;4;4;4];

switch(N)
case 1
harr = [
[ 0.036796442259
-0.024067904384
-0.064951364125
-0.042483542576
-0.030838286810
 0.174767766545
 0.409804433561
 0.540933249858
 0.540933249858
 0.409804433561
 0.174767766545
-0.030838286810
-0.042483542576
-0.064951364125
-0.024067904384
 0.036796442259
 ],...
 [
 0.024067904384
-0.036796442259
-0.042483542576
-0.064951364125
-0.174767766545
 0.030838286810
 0.540933249858
 0.409804433561
-0.409804433561
-0.540933249858
-0.030838286810
 0.174767766545
 0.064951364125
 0.042483542576
 0.036796442259
-0.024067904384
],...
[
 0.024067904384
 0.036796442259
-0.042483542576
 0.064951364125
-0.174767766544
-0.030838286810
 0.540933249858
-0.409804433561
-0.409804433561
 0.540933249858
-0.030838286810
-0.174767766545
 0.064951364125
-0.042483542576
 0.036796442259
 0.024067904384
],...
[ 
 0.036796442259
 0.024067904384
-0.064951364125
 0.042483542576
-0.030838286810
-0.174767766545
 0.409804433561
-0.540933249858
 0.540933249858
-0.409804433561
 0.174767766545
 0.030838286810
-0.042483542576
 0.064951364125
-0.024067904384
-0.036796442259
]
];

otherwise
        error('%s: No such M-Band filters.',upper(mfilename));
end

g=mat2cell(harr,size(harr,1),ones(1,size(harr,2)));
g=cellfun(@(gEl) struct('h',gEl,'offset',-numel(gEl)/2),g,'UniformOutput',0);
h = g;

info.istight = 1;
