# Definitions of acronyms that are used on https://sfs-matlab.readthedocs.io/
#
# This uses the rst-epilog variable, which will be appended to every source
# file by sphinx, see:
# http://www.sphinx-doc.org/en/stable/config.html#confval-rst_epilog
#
# Include this into your conf.py file with
# from acronyms import rst_epilog 

acronyms = """
.. |BRIR|            replace:: :abbr:`BRIR (Binaural Room Impulse Response)`
.. |BRS|             replace:: :abbr:`BRS (Binaural Room Scanning)`
.. |FFT|             replace:: :abbr:`FFT (Fast Fourier Transform)`
.. |HOA|             replace:: :abbr:`HOA (Higher Order Ambisonics)`
.. |HRIR|            replace:: :abbr:`HRIR (Head-Related Impulse Response)`
.. |HRTF|            replace:: :abbr:`HRTF (Head-Related Transfer Function)`
.. |KEMAR|           replace:: :abbr:`KEMAR (Knowles Electronics Manikin for Acoustic Research)`
.. |LSFS|            replace:: :abbr:`LSFS (Local Sound Field Synthesis)`
.. |NFC-HOA|         replace:: :abbr:`NFC-HOA (Near-Field Compensated Higher Order Ambisonics)`
.. |SDM|             replace:: :abbr:`SDM (Spectral Division Method)`
.. |SOFA|            replace:: :abbr:`SOFA (Spatially Oriented Format for Acoustics)`
.. |SSR|             replace:: :abbr:`SSR (SoundScape Renderer)`
.. |WFS|             replace:: :abbr:`WFS (Wave Field Synthesis)`
"""

# vim: textwidth=300:
