/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.enderbook;

import com.lothrazar.enderbook.BookLocation;
import com.lothrazar.enderbook.ConfigSettings;
import com.lothrazar.enderbook.GuiButtonDelete;
import com.lothrazar.enderbook.GuiButtonNew;
import com.lothrazar.enderbook.GuiButtonTeleport;
import com.lothrazar.enderbook.ItemEnderBook;
import com.lothrazar.enderbook.ModEnderBook;
import com.lothrazar.enderbook.PacketDeleteButton;
import com.lothrazar.enderbook.PacketNewButton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEnderBook
extends GuiScreen {
    private final EntityPlayer entityPlayer;
    private ItemStack bookStack;
    final int maxNameLen = 20;
    public static int buttonIdNew;
    GuiButton buttonNew;
    GuiTextField txtNew;
    final int DELETE_OFFSET = 1000;

    public GuiEnderBook(EntityPlayer entityPlayer, ItemStack book) {
        this.entityPlayer = entityPlayer;
        this.bookStack = book;
    }

    public void func_73866_w_() {
        int xStart;
        if (!this.bookStack.func_77942_o()) {
            this.bookStack.func_77982_d(new NBTTagCompound());
        }
        int buttonID = 0;
        int w = 70;
        int h = 20;
        int ypad = 1;
        int delete_w = 20;
        int rowpad = 8;
        buttonIdNew = buttonID++;
        ArrayList<BookLocation> list = ItemEnderBook.getLocations(this.bookStack);
        this.buttonNew = new GuiButtonNew(buttonIdNew, this.field_146294_l / 2 - w, 20, w, h, buttonIdNew);
        this.field_146292_n.add(this.buttonNew);
        if (this.bookStack != null && ItemEnderBook.getLocations(this.bookStack).size() >= ConfigSettings.maximumSaved) {
            this.buttonNew.field_146124_l = false;
        }
        this.txtNew = new GuiTextField(buttonID++, this.field_146289_q, this.buttonNew.field_146128_h + this.buttonNew.field_146120_f + 20, this.buttonNew.field_146129_i, w, h);
        this.txtNew.func_146203_f(20);
        this.txtNew.func_146180_a(this.entityPlayer.field_70170_p.func_180494_b(this.entityPlayer.func_180425_c()).func_185359_l());
        this.txtNew.func_146195_b(true);
        int yStart = 45;
        int x = xStart = this.field_146294_l / 10;
        int y = yStart;
        for (int i = 0; i < list.size(); ++i) {
            String buttonText;
            BookLocation loc = list.get(i);
            String string = buttonText = loc.display == null ? I18n.func_74838_a((String)"gui.enderbook.go") : loc.display;
            if (i % ConfigSettings.btnsPerColumn == 0) {
                x += w + delete_w + rowpad;
                y = yStart;
            } else {
                y += h + ypad;
            }
            GuiButtonTeleport btn = new GuiButtonTeleport(buttonID++, x, y, w, h, buttonText, loc.id);
            btn.setTooltip(list.get(i).coordsDisplay());
            btn.field_146124_l = loc.dimension == this.entityPlayer.field_71093_bK;
            this.field_146292_n.add(btn);
            GuiButtonDelete del = new GuiButtonDelete(buttonID++, x - delete_w - 2, y, delete_w, h, "X", loc.id);
            this.field_146292_n.add(del);
        }
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_74838_a((String)"gui.enderbook.title"), this.field_146294_l / 2, 6, 0xFFFFFF);
        if (this.txtNew != null) {
            this.txtNew.func_146194_f();
        }
        super.func_73863_a(x, y, par3);
        if (ConfigSettings.showCoordTooltips) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButtonTeleport btn;
                if (!(this.field_146292_n.get(i) instanceof GuiButtonTeleport) || !(btn = (GuiButtonTeleport)((Object)this.field_146292_n.get(i))).func_146115_a() || btn.getTooltip() == null) continue;
                this.drawHoveringText(Arrays.asList(btn.getTooltip()), x, y, this.field_146289_q);
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146127_k == buttonIdNew) {
            ModEnderBook.network.sendToServer((IMessage)new PacketNewButton(this.txtNew.func_146179_b()));
        } else if (btn instanceof GuiButtonDelete) {
            ModEnderBook.network.sendToServer((IMessage)new PacketDeleteButton(((GuiButtonDelete)btn).getSlot()));
        } else if (btn instanceof GuiButtonTeleport) {
            // empty if block
        }
        this.entityPlayer.func_71053_j();
    }

    public boolean func_73868_f() {
        return ConfigSettings.doesPauseGame;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.txtNew != null) {
            this.txtNew.func_146178_a();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.txtNew != null) {
            this.txtNew.func_146201_a(par1, par2);
        }
    }

    protected void func_73864_a(int x, int y, int btn) throws IOException {
        super.func_73864_a(x, y, btn);
        if (this.txtNew != null) {
            this.txtNew.func_146192_a(x, y, btn);
        }
    }
}

