/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.enderbook;

import com.lothrazar.enderbook.BookLocation;
import com.lothrazar.enderbook.ConfigSettings;
import com.lothrazar.enderbook.GuiEnderBook;
import com.lothrazar.enderbook.UtilExperience;
import com.lothrazar.enderbook.UtilSound;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemEnderBook
extends Item {
    public static String KEY_LOC = "location";
    public static String KEY_LARGEST = "loc_largest";
    public static ItemEnderBook itemEnderBook;

    public ItemEnderBook() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78029_e);
    }

    public static ArrayList<BookLocation> getLocations(ItemStack itemStack) {
        ArrayList<BookLocation> list = new ArrayList<BookLocation>();
        int end = ItemEnderBook.getLargestSlot(itemStack);
        for (int i = 0; i <= end; ++i) {
            String KEY = KEY_LOC + "_" + i;
            String csv = itemStack.func_77978_p().func_74779_i(KEY);
            if (csv == null || csv.isEmpty()) continue;
            list.add(new BookLocation(csv));
        }
        return list;
    }

    public static int getLargestSlot(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e(KEY_LARGEST);
    }

    public static int getEmptySlotAndIncrement(ItemStack itemStack) {
        int empty = itemStack.func_77978_p().func_74762_e(KEY_LARGEST);
        if (empty == 0) {
            empty = 1;
        }
        itemStack.func_77978_p().func_74768_a(KEY_LARGEST, empty + 1);
        return empty;
    }

    private static ItemStack getPlayersBook(EntityPlayer player) {
        ItemStack book = player.func_184586_b(EnumHand.MAIN_HAND);
        if (book == null || book.func_77973_b() != itemEnderBook) {
            book = player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        return book;
    }

    public static void deleteWaypoint(EntityPlayer player, int slot) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        book.func_77978_p().func_82580_o(KEY_LOC + "_" + slot);
    }

    public static void saveCurrentLocation(EntityPlayer player, String name) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        int id = ItemEnderBook.getEmptySlotAndIncrement(book);
        BookLocation loc = new BookLocation(id, player, name);
        book.func_77978_p().func_74778_a(KEY_LOC + "_" + id, loc.toCSV());
    }

    private static BookLocation getLocation(ItemStack stack, int slot) {
        String csv = stack.func_77978_p().func_74779_i(KEY_LOC + "_" + slot);
        if (csv == null || csv.isEmpty()) {
            return null;
        }
        return new BookLocation(csv);
    }

    public static void teleport(EntityPlayer player, int slot) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        String csv = book.func_77978_p().func_74779_i(KEY_LOC + "_" + slot);
        if (csv == null || csv.isEmpty()) {
            return;
        }
        BookLocation loc = ItemEnderBook.getLocation(book, slot);
        if (player.field_71093_bK != loc.dimension) {
            return;
        }
        int cost = ConfigSettings.expCostPerTeleport;
        UtilExperience.drainExp(player, cost);
        UtilSound.playSound((Entity)player, SoundEvents.field_187544_ad, SoundCategory.PLAYERS);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            float f = 0.5f;
            p.field_71135_a.func_147364_a(loc.X - (double)f, loc.Y + 0.9, loc.Z - (double)f, p.field_70177_z, p.field_70125_A);
            BlockPos dest = new BlockPos(loc.X, loc.Y, loc.Z);
            player.field_70170_p.func_175726_f(dest).func_76630_e();
        }
        UtilSound.playSound((Entity)player, SoundEvents.field_187544_ad, SoundCategory.PLAYERS);
    }

    public static void initEnderbook() {
        itemEnderBook = new ItemEnderBook();
        String name = "book_ender";
        itemEnderBook.func_77655_b(name);
        GameRegistry.registerItem((Item)itemEnderBook, (String)name);
        if (ConfigSettings.craftNetherStar) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)itemEnderBook), (Object[])new Object[]{"ene", "ebe", "eee", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('n'), Items.field_151156_bN});
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)itemEnderBook), (Object[])new Object[]{"eee", "ebe", "eee", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('b'), Items.field_151122_aG});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)itemEnderBook), (Object[])new Object[]{new ItemStack((Item)itemEnderBook)});
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer entityPlayer, EnumHand hand) {
        if (stack == null || stack.func_77973_b() == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEnderBook(entityPlayer, stack));
        return super.func_77659_a(stack, world, entityPlayer, hand);
    }
}

