/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.IMetadataConstants;
import com.vladium.util.IConstants;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class MethodDescriptor
implements IConstants,
IMetadataConstants,
Serializable {
    private final String m_name;
    private final String m_descriptor;
    private final int m_status;
    private final int[] m_blockSizes;
    private final int[][] m_blockMap;
    private final int m_firstLine;
    private IntObjectMap m_lineMap;

    public MethodDescriptor(String name, String descriptor, int status, int[] blockSizes, int[][] blockMap, int firstLine) {
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("null input: descriptor");
        }
        if ((status & 0xE) == 0) {
            int blockCount = blockSizes.length;
            this.m_blockSizes = blockSizes;
            if ((status & 0xF) == 0) {
                if (blockMap == null || blockMap.length == 0) {
                    throw new IllegalArgumentException("null or empty input: blockMap");
                }
                this.m_blockMap = blockMap;
                this.m_firstLine = firstLine;
            } else {
                this.m_blockMap = null;
                this.m_firstLine = 0;
            }
        } else {
            this.m_blockSizes = null;
            this.m_blockMap = null;
            this.m_firstLine = 0;
        }
        this.m_name = name;
        this.m_descriptor = descriptor;
        this.m_status = status;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescriptor() {
        return this.m_descriptor;
    }

    public int getStatus() {
        return this.m_status;
    }

    public int getBlockCount() {
        return this.m_blockSizes.length;
    }

    public int[] getBlockSizes() {
        return this.m_blockSizes;
    }

    public int[][] getBlockMap() {
        return this.m_blockMap;
    }

    public IntObjectMap getLineMap() {
        IntObjectMap lineMap = this.m_lineMap;
        if (lineMap != null) {
            return lineMap;
        }
        if ((this.m_status & 0xF) == 0) {
            lineMap = new IntObjectMap();
            int[][] blockMap = this.m_blockMap;
            int blCount = blockMap.length;
            for (int bl = 0; bl < blCount; ++bl) {
                int[] lines = blockMap[bl];
                if (lines == null) continue;
                for (int line : lines) {
                    IntSet blockIDs = (IntSet)lineMap.get(line);
                    if (blockIDs == null) {
                        blockIDs = new IntSet();
                        lineMap.put(line, blockIDs);
                    }
                    blockIDs.add(bl);
                }
            }
            for (int line : lineMap.keys()) {
                int[] blockIDs = ((IntSet)lineMap.get(line)).values();
                lineMap.put(line, blockIDs);
            }
            this.m_lineMap = lineMap;
            return lineMap;
        }
        return null;
    }

    public int getFirstLine() {
        return this.m_firstLine;
    }

    public boolean hasLineNumberInfo() {
        return (this.m_status & 0xF) == 0;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer s = new StringBuffer(indent + "method [" + this.m_name + "] descriptor:");
        if ((this.m_status & 0xF) == 0) {
            for (int bl = 0; bl < this.m_blockMap.length; ++bl) {
                s.append(EOL);
                s.append(indent + "  " + "block " + bl + " (" + this.m_blockSizes[bl] + " instrs) : ");
                int[] lines = this.m_blockMap[bl];
                for (int l = 0; l < lines.length; ++l) {
                    if (l != 0) {
                        s.append(", ");
                    }
                    s.append(lines[l]);
                }
            }
            s.append(EOL);
            s.append(indent + "  " + "---");
            int[] lines = this.m_lineMap.keys();
            for (int l = 0; l < lines.length; ++l) {
                s.append(EOL);
                s.append(indent + "  " + "line " + lines[l] + ": ");
                int[] blocks = (int[])this.m_lineMap.get(lines[l]);
                for (int bl = 0; bl < blocks.length; ++bl) {
                    if (bl != 0) {
                        s.append(", ");
                    }
                    s.append(blocks[bl]);
                }
            }
        } else {
            s.append(" <no line info>");
        }
        return s.toString();
    }

    static MethodDescriptor readExternal(DataInput in) throws IOException {
        String name = in.readUTF();
        String descriptor = in.readUTF();
        int status = in.readInt();
        int[] blockSizes = null;
        Object blockMap = null;
        int firstLine = 0;
        if ((status & 0xE) == 0) {
            blockSizes = DataFactory.readIntArray(in);
            if ((status & 0xF) == 0) {
                int length = in.readInt();
                blockMap = new int[length][];
                for (int i = 0; i < length; ++i) {
                    blockMap[i] = DataFactory.readIntArray(in);
                }
                firstLine = in.readInt();
            }
        }
        return new MethodDescriptor(name, descriptor, status, blockSizes, (int[][])blockMap, firstLine);
    }

    static void writeExternal(MethodDescriptor method, DataOutput out) throws IOException {
        out.writeUTF(method.m_name);
        out.writeUTF(method.m_descriptor);
        int status = method.m_status;
        out.writeInt(status);
        if ((status & 0xE) == 0) {
            DataFactory.writeIntArray(method.m_blockSizes, out);
            if ((status & 0xF) == 0) {
                int[][] blockMap = method.m_blockMap;
                int length = blockMap.length;
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    DataFactory.writeIntArray(blockMap[i], out);
                }
                out.writeInt(method.m_firstLine);
            }
        }
    }
}

