/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TreeDragSourceEffect(Tree tree) {
        super(tree);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            int n = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
            if (OS.SendMessage(this.control.handle, n, 0, sHDRAGIMAGE) != 0) {
                dragSourceEvent.offsetX = (this.control.getStyle() & 0x8000000) != 0 ? sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x : sHDRAGIMAGE.ptOffset.x;
                dragSourceEvent.offsetY = sHDRAGIMAGE.ptOffset.y;
                int n2 = sHDRAGIMAGE.hbmpDragImage;
                if (n2 != 0) {
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(n2, BITMAP.sizeof, bITMAP);
                    int n3 = bITMAP.bmWidth;
                    int n4 = bITMAP.bmHeight;
                    int n5 = OS.GetDC(0);
                    int n6 = OS.CreateCompatibleDC(n5);
                    int n7 = OS.SelectObject(n6, n2);
                    int n8 = OS.CreateCompatibleDC(n5);
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n3;
                    bITMAPINFOHEADER.biHeight = -n4;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)32;
                    bITMAPINFOHEADER.biCompression = 0;
                    byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    int[] nArray = new int[1];
                    int n9 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
                    if (n9 == 0) {
                        SWT.error(2);
                    }
                    int n10 = OS.SelectObject(n8, n9);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(n9, BITMAP.sizeof, bITMAP2);
                    int n11 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(n8, 0, 0, n3, n4, n6, 0, 0, 0xCC0020);
                    byte[] byArray2 = new byte[n11];
                    OS.MoveMemory(byArray2, bITMAP2.bmBits, n11);
                    PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    ImageData imageData = new ImageData(n3, n4, bITMAP.bmBitsPixel, paletteData, bITMAP.bmWidthBytes, byArray2);
                    if (sHDRAGIMAGE.crColorKey == -1) {
                        byte[] byArray3 = new byte[n3 * n4];
                        int n12 = bITMAP2.bmWidthBytes - n3 * 4;
                        int n13 = 0;
                        int n14 = 3;
                        int n15 = 0;
                        while (n15 < n4) {
                            int n16 = 0;
                            while (n16 < n3) {
                                byArray3[n13++] = byArray2[n14];
                                n14 += 4;
                                ++n16;
                            }
                            n14 += n12;
                            ++n15;
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        imageData.transparentPixel = sHDRAGIMAGE.crColorKey << 8;
                    }
                    this.dragSourceImage = new Image((Device)this.control.getDisplay(), imageData);
                    OS.SelectObject(n8, n10);
                    OS.DeleteDC(n8);
                    OS.DeleteObject(n9);
                    OS.SelectObject(n6, n7);
                    OS.DeleteDC(n6);
                    OS.ReleaseDC(0, n5);
                    OS.DeleteObject(n2);
                    return this.dragSourceImage;
                }
            }
            return null;
        }
        Tree tree = (Tree)this.control;
        if (tree.isListening(40) || tree.isListening(42)) {
            return null;
        }
        TreeItem[] treeItemArray = tree.getSelection();
        if (treeItemArray.length == 0) {
            return null;
        }
        int n = OS.SendMessage(tree.handle, 4360, 0, 0);
        if (n != 0) {
            int n17 = Math.min(treeItemArray.length, 10);
            Rectangle rectangle = treeItemArray[0].getBounds(0);
            int n18 = 1;
            while (n18 < n17) {
                rectangle = rectangle.union(treeItemArray[n18].getBounds(0));
                ++n18;
            }
            n18 = OS.GetDC(tree.handle);
            int n19 = OS.CreateCompatibleDC(n18);
            int n20 = OS.CreateCompatibleBitmap(n18, rectangle.width, rectangle.height);
            int n21 = OS.SelectObject(n19, n20);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n22 = OS.GetStockObject(0);
            OS.FillRect(n19, rECT, n22);
            int n23 = 0;
            while (n23 < n17) {
                TreeItem treeItem = treeItemArray[n23];
                Rectangle rectangle2 = treeItem.getBounds(0);
                int n24 = OS.SendMessage(tree.handle, 4370, 0, treeItem.handle);
                OS.ImageList_Draw(n24, 0, n19, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(n24);
                ++n23;
            }
            OS.SelectObject(n19, n21);
            OS.DeleteDC(n19);
            OS.ReleaseDC(tree.handle, n18);
            Display display = tree.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, n20);
            return this.dragSourceImage;
        }
        return null;
    }
}

