/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutopt.cli;

import com.android.layoutopt.uix.LayoutAnalysis;
import com.android.layoutopt.uix.LayoutAnalyzer;
import java.io.File;
import java.util.ArrayList;

public class Main {
    public static void main(String[] args) {
        Parameters p = Main.checkParameters(args);
        if (!p.valid) {
            Main.displayHelpMessage();
            Main.exit();
        }
        Main.analyzeFiles(p.files);
    }

    private static void analyzeFiles(File[] files) {
        LayoutAnalyzer analyzer = new LayoutAnalyzer();
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".xml")) {
                Main.analyze(analyzer, file);
                continue;
            }
            if (!file.isDirectory()) continue;
            Main.analyzeFiles(file.listFiles());
        }
    }

    private static void analyze(LayoutAnalyzer analyzer, File file) {
        LayoutAnalysis analysis = analyzer.analyze(file);
        System.out.println(analysis.getName());
        for (LayoutAnalysis.Issue issue : analysis.getIssues()) {
            System.out.print(String.format("\t%d:%d ", issue.getStartLine(), issue.getEndLine()));
            System.out.println(issue.getDescription());
        }
    }

    private static void exit() {
        System.exit(0);
    }

    private static void displayHelpMessage() {
        System.out.println("usage: layoutopt <directories/files to analyze>");
    }

    private static Parameters checkParameters(String[] args) {
        Parameters p = new Parameters();
        if (args.length < 1) {
            p.valid = false;
        } else {
            ArrayList<File> files = new ArrayList<File>();
            for (String path : args) {
                File file = new File(path);
                if (!file.exists() || !file.isDirectory() && !file.getName().endsWith(".xml")) continue;
                files.add(file);
            }
            p.files = files.toArray(new File[files.size()]);
            p.valid = true;
        }
        return p;
    }

    private static class Parameters {
        boolean valid;
        File[] files;

        private Parameters() {
        }
    }
}

