/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class IssueRegistry {
    private static List<Category> sCategories;
    private static Map<String, Issue> sIdToIssue;
    public static final Issue PARSER_ERROR;
    public static final Issue LINT_ERROR;

    public abstract List<Issue> getIssues();

    final List<? extends Detector> createDetectors(LintClient lintClient, Configuration configuration, EnumSet<Scope> enumSet, Map<Scope, List<Detector>> map) {
        EnumSet enumSet2;
        Object throwable;
        List<Issue> list = this.getIssues();
        HashSet<Class<? extends Detector>> hashSet = new HashSet<Class<? extends Detector>>();
        HashMap<Class<? extends Detector>, Object> hashMap = new HashMap<Class<? extends Detector>, Object>();
        for (Issue object2 : list) {
            Class<? extends Detector> clazz = object2.getDetectorClass();
            throwable = object2.getScope();
            if (!hashSet.contains(clazz)) {
                if (!configuration.isEnabled(object2) || !enumSet.containsAll((Collection<?>)throwable)) continue;
                clazz = lintClient.replaceDetector(clazz);
                assert (clazz != null) : object2.getId();
                hashSet.add(clazz);
            }
            if (map == null) continue;
            enumSet2 = (EnumSet)hashMap.get(clazz);
            if (enumSet2 == null) {
                hashMap.put(clazz, throwable);
                continue;
            }
            if (enumSet2.containsAll((Collection<?>)throwable)) continue;
            EnumSet enumSet3 = EnumSet.copyOf(enumSet2);
            enumSet3.addAll(throwable);
            hashMap.put(clazz, enumSet3);
        }
        ArrayList arrayList = new ArrayList(hashSet.size());
        for (Class<? extends Detector> clazz : hashSet) {
            try {
                throwable = (Detector)clazz.newInstance();
                arrayList.add(throwable);
                if (map == null) continue;
                enumSet2 = (EnumSet)hashMap.get(clazz);
                for (Scope scope : enumSet2) {
                    List<Detector> list2 = map.get((Object)scope);
                    if (list2 == null) {
                        list2 = new ArrayList<Detector>();
                        map.put(scope, list2);
                    }
                    list2.add((Detector)throwable);
                }
            }
            catch (Throwable throwable2) {
                lintClient.log(throwable2, "Can't initialize detector %1$s", clazz.getName());
            }
        }
        return arrayList;
    }

    public final boolean isIssueId(String string) {
        return this.getIssue(string) != null;
    }

    public final boolean isCategoryName(String string) {
        for (Category category : this.getCategories()) {
            if (!category.getName().equals(string) && !category.getFullName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<Category> getCategories() {
        if (sCategories == null) {
            HashSet<Category> hashSet = new HashSet<Category>();
            for (Issue issue : this.getIssues()) {
                hashSet.add(issue.getCategory());
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            sCategories = Collections.unmodifiableList(arrayList);
        }
        return sCategories;
    }

    public final Issue getIssue(String string) {
        if (sIdToIssue == null) {
            List<Issue> list = this.getIssues();
            sIdToIssue = new HashMap<String, Issue>(list.size());
            for (Issue issue : list) {
                sIdToIssue.put(issue.getId(), issue);
            }
            sIdToIssue.put(PARSER_ERROR.getId(), PARSER_ERROR);
            sIdToIssue.put(LINT_ERROR.getId(), LINT_ERROR);
        }
        return sIdToIssue.get(string);
    }

    static {
        PARSER_ERROR = Issue.create("ParserError", "Finds files that contain fatal parser errors", "Lint will ignore any files that contain fatal parsing errors. These may contain other errors, or contain code which affects issues in other files.", Category.CORRECTNESS, 10, Severity.ERROR, null, Scope.RESOURCE_FILE_SCOPE);
        LINT_ERROR = Issue.create("LintError", "Isues related to running lint itself, such as failure to read files, etc", "This issue type represents a problem running lint itself. Examples include failure to find bytecode for source files (which means certain detectors could not be run), parsing errors in lint configuration files, etc.\nThese errors are not errors in your own code, but they are shown to make it clear that some checks were not completed.", Category.LINT, 10, Severity.ERROR, null, Scope.RESOURCE_FILE_SCOPE);
    }
}

