/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class XmlVisitor {
    private final Map<String, List<Detector.XmlScanner>> mElementToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final Map<String, List<Detector.XmlScanner>> mAttributeToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final List<Detector.XmlScanner> mDocumentDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllElementDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllAttributeDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<? extends Detector> mAllDetectors;
    private final IDomParser mParser;

    XmlVisitor(IDomParser iDomParser, List<? extends Detector> list) {
        this.mParser = iDomParser;
        this.mAllDetectors = list;
        for (Detector detector : list) {
            Object object;
            Detector.XmlScanner xmlScanner = (Detector.XmlScanner)((Object)detector);
            Collection<String> collection = xmlScanner.getApplicableAttributes();
            if (collection == Detector.XmlScanner.ALL) {
                this.mAllAttributeDetectors.add(xmlScanner);
            } else if (collection != null) {
                for (String string : collection) {
                    object = this.mAttributeToCheck.get(string);
                    if (object == null) {
                        object = new ArrayList<Detector.XmlScanner>();
                        this.mAttributeToCheck.put(string, (List<Detector.XmlScanner>)object);
                    }
                    object.add(xmlScanner);
                }
            }
            Collection<String> collection2 = xmlScanner.getApplicableElements();
            if (collection2 == Detector.XmlScanner.ALL) {
                this.mAllElementDetectors.add(xmlScanner);
            } else if (collection2 != null) {
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    List<Detector.XmlScanner> list2 = this.mElementToCheck.get(object);
                    if (list2 == null) {
                        list2 = new ArrayList<Detector.XmlScanner>();
                        this.mElementToCheck.put((String)object, list2);
                    }
                    list2.add(xmlScanner);
                }
            }
            if (collection != null && (collection.size() != 0 || collection == Detector.XmlScanner.ALL) || collection2 != null && (collection2.size() != 0 || collection2 == Detector.XmlScanner.ALL)) continue;
            this.mDocumentDetectors.add(xmlScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(XmlContext xmlContext, File file) {
        assert (LintUtils.isXmlFile(file));
        xmlContext.parser = this.mParser;
        try {
            if (xmlContext.document == null) {
                xmlContext.document = this.mParser.parseXml(xmlContext);
                if (xmlContext.document == null) {
                    return;
                }
                if (xmlContext.document.getDocumentElement() == null) {
                    return;
                }
            }
            for (Detector object : this.mAllDetectors) {
                object.beforeCheckFile(xmlContext);
            }
            for (Detector.XmlScanner xmlScanner : this.mDocumentDetectors) {
                xmlScanner.visitDocument(xmlContext, xmlContext.document);
            }
            if (this.mElementToCheck.size() > 0 || this.mAttributeToCheck.size() > 0 || this.mAllAttributeDetectors.size() > 0 || this.mAllElementDetectors.size() > 0) {
                this.visitElement(xmlContext, xmlContext.document.getDocumentElement());
            }
            for (Detector detector : this.mAllDetectors) {
                detector.afterCheckFile(xmlContext);
            }
        }
        finally {
            if (xmlContext.document != null) {
                this.mParser.dispose(xmlContext, xmlContext.document);
                xmlContext.document = null;
            }
        }
    }

    private void visitElement(XmlContext xmlContext, Element element) {
        Object object;
        Detector.XmlScanner xmlScanner;
        int n;
        int n2;
        List<Detector.XmlScanner> list = this.mElementToCheck.get(element.getTagName());
        if (list != null) {
            assert (list instanceof RandomAccess);
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                xmlScanner = list.get(n);
                xmlScanner.visitElement(xmlContext, element);
            }
        }
        if (this.mAllElementDetectors.size() > 0) {
            n2 = this.mAllElementDetectors.size();
            for (n = 0; n < n2; ++n) {
                xmlScanner = this.mAllElementDetectors.get(n);
                xmlScanner.visitElement(xmlContext, element);
            }
        }
        if (this.mAttributeToCheck.size() > 0 || this.mAllAttributeDetectors.size() > 0) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n3 = namedNodeMap.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                Detector.XmlScanner xmlScanner2;
                int n4;
                int n5;
                List<Detector.XmlScanner> list2;
                object = (Attr)namedNodeMap.item(n2);
                String string = object.getLocalName();
                if (string == null) {
                    string = object.getName();
                }
                if ((list2 = this.mAttributeToCheck.get(string)) != null) {
                    n5 = list2.size();
                    for (n4 = 0; n4 < n5; ++n4) {
                        xmlScanner2 = list2.get(n4);
                        xmlScanner2.visitAttribute(xmlContext, (Attr)object);
                    }
                }
                if (this.mAllAttributeDetectors.size() <= 0) continue;
                n5 = this.mAllAttributeDetectors.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    xmlScanner2 = this.mAllAttributeDetectors.get(n4);
                    xmlScanner2.visitAttribute(xmlContext, (Attr)object);
                }
            }
        }
        NodeList nodeList = element.getChildNodes();
        int n6 = nodeList.getLength();
        for (n2 = 0; n2 < n6; ++n2) {
            object = nodeList.item(n2);
            if (object.getNodeType() != 1) continue;
            this.visitElement(xmlContext, (Element)object);
        }
        if (list != null) {
            n6 = list.size();
            for (n2 = 0; n2 < n6; ++n2) {
                object = list.get(n2);
                object.visitElementAfter(xmlContext, element);
            }
        }
        if (this.mAllElementDetectors.size() > 0) {
            n6 = this.mAllElementDetectors.size();
            for (n2 = 0; n2 < n6; ++n2) {
                object = this.mAllElementDetectors.get(n2);
                object.visitElementAfter(xmlContext, element);
            }
        }
    }
}

