/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Category
implements Comparable<Category> {
    private final String mName;
    private final String mExplanation;
    private final int mPriority;
    private final Category mParent;
    public static final Category LINT = Category.create("Lint", 110);
    public static final Category CORRECTNESS = Category.create("Correctness", 100);
    public static final Category SECURITY = Category.create("Security", 90);
    public static final Category PERFORMANCE = Category.create("Performance", 80);
    public static final Category USABILITY = Category.create("Usability", 70);
    public static final Category A11Y = Category.create("Accessibility", 60);
    public static final Category I18N = Category.create("Internationalization", 50);
    public static final Category ICONS = Category.create(USABILITY, "Icons", null, 73);
    public static final Category TYPOGRAPHY = Category.create(USABILITY, "Typography", null, 76);
    public static final Category MESSAGES = Category.create(CORRECTNESS, "Messages", null, 95);

    private Category(Category category, String string, String string2, int n) {
        this.mParent = category;
        this.mName = string;
        this.mExplanation = string2;
        this.mPriority = n;
    }

    public static Category create(String string, int n) {
        return new Category(null, string, null, n);
    }

    public static Category create(Category category, String string, String string2, int n) {
        return new Category(category, string, null, n);
    }

    public Category getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public String getExplanation() {
        return this.mExplanation;
    }

    public String getFullName() {
        if (this.mParent != null) {
            return this.mParent.getFullName() + ':' + this.mName;
        }
        return this.mName;
    }

    @Override
    public int compareTo(Category category) {
        if (category.mPriority == this.mPriority) {
            if (this.mParent == category) {
                return 1;
            }
            if (category.mParent == this) {
                return -1;
            }
        }
        return category.mPriority - this.mPriority;
    }
}

