/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Issue
implements Comparable<Issue> {
    private final String mId;
    private final String mDescription;
    private final String mExplanation;
    private final Category mCategory;
    private final int mPriority;
    private final Severity mSeverity;
    private String mMoreInfoUrl;
    private boolean mEnabledByDefault = true;
    private final EnumSet<Scope> mScope;
    private final Class<? extends Detector> mClass;

    private Issue(String string, String string2, String string3, Category category, int n, Severity severity, Class<? extends Detector> clazz, EnumSet<Scope> enumSet) {
        this.mId = string;
        this.mDescription = string2;
        this.mExplanation = string3;
        this.mCategory = category;
        this.mPriority = n;
        this.mSeverity = severity;
        this.mClass = clazz;
        this.mScope = enumSet;
    }

    public static Issue create(String string, String string2, String string3, Category category, int n, Severity severity, Class<? extends Detector> clazz, EnumSet<Scope> enumSet) {
        return new Issue(string, string2, string3, category, n, severity, clazz, enumSet);
    }

    public String getId() {
        return this.mId;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getExplanation() {
        return this.mExplanation;
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public Severity getDefaultSeverity() {
        return this.mSeverity;
    }

    public String getMoreInfo() {
        return this.mMoreInfoUrl;
    }

    public boolean isEnabledByDefault() {
        return this.mEnabledByDefault;
    }

    public EnumSet<Scope> getScope() {
        return this.mScope;
    }

    @Override
    public int compareTo(Issue issue) {
        return this.getId().compareTo(issue.getId());
    }

    public Issue setMoreInfo(String string) {
        this.mMoreInfoUrl = string;
        return this;
    }

    public Issue setEnabledByDefault(boolean bl) {
        this.mEnabledByDefault = bl;
        return this;
    }

    public Class<? extends Detector> getDetectorClass() {
        return this.mClass;
    }

    public String toString() {
        return this.mId;
    }
}

