/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Position;
import com.google.common.annotations.Beta;
import java.io.File;

@Beta
public class Location {
    private final File mFile;
    private final Position mStart;
    private final Position mEnd;
    private String mMessage;
    private Location mSecondary;
    private Object mClientData;

    protected Location(File file, Position position, Position position2) {
        this.mFile = file;
        this.mStart = position;
        this.mEnd = position2;
    }

    public File getFile() {
        return this.mFile;
    }

    public Position getStart() {
        return this.mStart;
    }

    public Position getEnd() {
        return this.mEnd;
    }

    public Location getSecondary() {
        return this.mSecondary;
    }

    public void setSecondary(Location location) {
        this.mSecondary = location;
    }

    public void setMessage(String string) {
        this.mMessage = string;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setClientData(Object object) {
        this.mClientData = object;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public String toString() {
        return "Location [file=" + this.mFile + ", start=" + this.mStart + ", end=" + this.mEnd + ", message=" + this.mMessage + "]";
    }

    public static Location create(File file) {
        return new Location(file, null, null);
    }

    public static Location create(File file, Position position, Position position2) {
        return new Location(file, position, position2);
    }

    public static Location create(File file, String string, int n, int n2) {
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Invalid offsets");
        }
        if (string == null) {
            return new Location(file, new DefaultPosition(-1, -1, n), new DefaultPosition(-1, -1, n2));
        }
        int n3 = string.length();
        n2 = Math.min(n2, n3);
        n = Math.min(n, n2);
        DefaultPosition defaultPosition = null;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i <= n3; ++i) {
            if (i == n) {
                defaultPosition = new DefaultPosition(n4, i - n5, i);
            }
            if (i == n2) {
                DefaultPosition defaultPosition2 = new DefaultPosition(n4, i - n5, i);
                return new Location(file, defaultPosition, defaultPosition2);
            }
            char c = string.charAt(i);
            if (c != '\n') continue;
            n5 = i;
            ++n4;
        }
        return Location.create(file);
    }

    public static Location create(File file, String string, int n) {
        return Location.create(file, string, n, null, null);
    }

    public static Location create(File file, String string, int n, String string2, String string3) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if ((n3 = string.indexOf(10, n3)) == -1) {
                return Location.create(file);
            }
            ++n2;
            ++n3;
        }
        if (n == n2) {
            if (string2 != null) {
                int n4;
                int n5;
                int n6;
                int n7 = string.indexOf(string2, n3);
                if (n7 == -1) {
                    n6 = n3;
                    for (n5 = 0; n5 < 4 && (n4 = string.lastIndexOf(10, n6 - 1)) != -1 && (n7 = string.indexOf(string2, n4)) == -1 && n4 != 0; ++n5) {
                        n6 = n4;
                    }
                }
                if (n7 != -1) {
                    n6 = string.lastIndexOf(10, n7);
                    n6 = n6 == -1 ? 0 : ++n6;
                    n5 = n7 - n6;
                    if (string3 != null && (n4 = string.indexOf(string3, n3 + string2.length())) != -1) {
                        return new Location(file, new DefaultPosition(n, n5, n7), new DefaultPosition(n, -1, n4 + string3.length()));
                    }
                    return new Location(file, new DefaultPosition(n, n5, n7), new DefaultPosition(n, n5, n7 + string2.length()));
                }
            }
            DefaultPosition defaultPosition = new DefaultPosition(n, -1, n3);
            return new Location(file, defaultPosition, defaultPosition);
        }
        return Location.create(file);
    }

    public static Location reverse(Location location) {
        Location location2 = location.getSecondary();
        location.setSecondary(null);
        while (location2 != null) {
            Location location3 = location2.getSecondary();
            location2.setSecondary(location);
            location = location2;
            location2 = location3;
        }
        return location;
    }

    public static class DefaultLocationHandle
    implements Handle {
        private File mFile;
        private String mContents;
        private int mStartOffset;
        private int mEndOffset;
        private Object mClientData;

        public DefaultLocationHandle(Context context, int n, int n2) {
            this.mFile = context.file;
            this.mContents = context.getContents();
            this.mStartOffset = n;
            this.mEndOffset = n2;
        }

        public Location resolve() {
            return Location.create(this.mFile, this.mContents, this.mStartOffset, this.mEndOffset);
        }

        public void setClientData(Object object) {
            this.mClientData = object;
        }

        public Object getClientData() {
            return this.mClientData;
        }
    }

    public static interface Handle {
        public Location resolve();

        public void setClientData(Object var1);

        public Object getClientData();
    }
}

