/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlContext
extends Context {
    public IDomParser parser;
    public Document document;
    private final ResourceFolderType mFolderType;
    private static final Pattern sVersionPattern = Pattern.compile("^v(\\d+)$");

    public XmlContext(LintDriver lintDriver, Project project, Project project2, File file, ResourceFolderType resourceFolderType) {
        super(lintDriver, project, project2, file);
        this.mFolderType = resourceFolderType;
    }

    public Location getLocation(Node node) {
        if (this.parser != null) {
            return this.parser.getLocation(this, node);
        }
        return Location.create(this.file);
    }

    public void report(Issue issue, Node node, Location location, String string, Object object) {
        if (node != null && this.mDriver.isSuppressed(issue, node)) {
            return;
        }
        super.report(issue, location, string, object);
    }

    public void report(Issue issue, Location location, String string, Object object) {
        if (this.document != null && this.mDriver.isSuppressed(issue, this.document)) {
            return;
        }
        super.report(issue, location, string, object);
    }

    public ResourceFolderType getResourceFolderType() {
        return this.mFolderType;
    }

    public int getFolderVersion() {
        String[] stringArray;
        for (String string : stringArray = this.file.getParentFile().getName().split("-")) {
            Matcher matcher = sVersionPattern.matcher(string);
            if (!matcher.matches()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }
}

