/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager.internal.repository;

import com.android.sdkuilib.internal.repository.ISettingsPage;
import com.android.sdkuilib.internal.repository.UpdaterPage;
import java.util.Properties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingsPage
extends UpdaterPage
implements ISettingsPage {
    private ISettingsPage.SettingsChangedCallback mSettingsChangedCallback;
    private Group mProxySettingsGroup;
    private Group mMiscGroup;
    private Label mProxyServerLabel;
    private Label mProxyPortLabel;
    private Text mProxyServerText;
    private Text mProxyPortText;
    private Button mForceHttpCheck;
    private Button mAskAdbRestartCheck;
    private SelectionAdapter mApplyOnSelected = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SettingsPage.this.applyNewSettings();
        }
    };
    private ModifyListener mApplyOnModified = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            SettingsPage.this.applyNewSettings();
        }
    };

    public SettingsPage(Composite composite, int n) {
        super(composite, n);
        this.createContents(this);
        this.postCreate();
    }

    public String getPageTitle() {
        return "Settings";
    }

    private void createContents(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.mProxySettingsGroup = new Group((Composite)this, 0);
        this.mProxySettingsGroup.setText("Proxy Settings");
        this.mProxySettingsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mProxySettingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.mProxyServerLabel = new Label((Composite)this.mProxySettingsGroup, 0);
        this.mProxyServerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mProxyServerLabel.setText("HTTP Proxy Server");
        String string = "The DNS name or IP of the HTTP proxy server to use. When empty, no HTTP proxy is used.";
        this.mProxyServerLabel.setToolTipText(string);
        this.mProxyServerText = new Text((Composite)this.mProxySettingsGroup, 2048);
        this.mProxyServerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mProxyServerText.addModifyListener(this.mApplyOnModified);
        this.mProxyServerText.setToolTipText(string);
        this.mProxyPortLabel = new Label((Composite)this.mProxySettingsGroup, 0);
        this.mProxyPortLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mProxyPortLabel.setText("HTTP Proxy Port");
        string = "The port of the HTTP proxy server to use. When empty, the default for HTTP or HTTPS is used.";
        this.mProxyPortLabel.setToolTipText(string);
        this.mProxyPortText = new Text((Composite)this.mProxySettingsGroup, 2048);
        this.mProxyPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mProxyPortText.addModifyListener(this.mApplyOnModified);
        this.mProxyPortText.setToolTipText(string);
        this.mMiscGroup = new Group((Composite)this, 0);
        this.mMiscGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mMiscGroup.setText("Misc");
        this.mMiscGroup.setLayout((Layout)new GridLayout(2, false));
        this.mForceHttpCheck = new Button((Composite)this.mMiscGroup, 32);
        this.mForceHttpCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mForceHttpCheck.setText("Force https://... sources to be fetched using http://...");
        this.mForceHttpCheck.setToolTipText("If you are not able to connect to the official Android repository using HTTPS, enable this setting to force accessing it via HTTP.");
        this.mForceHttpCheck.addSelectionListener((SelectionListener)this.mApplyOnSelected);
        this.mAskAdbRestartCheck = new Button((Composite)this.mMiscGroup, 32);
        this.mAskAdbRestartCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mAskAdbRestartCheck.setText("Ask before restarting ADB");
        this.mAskAdbRestartCheck.setToolTipText("When checked, the user will be asked for permission to restart ADB after updating an addon-on package or a tool package.");
        this.mAskAdbRestartCheck.addSelectionListener((SelectionListener)this.mApplyOnSelected);
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
    }

    public void loadSettings(Properties properties) {
        this.mProxyServerText.setText(properties.getProperty("http.proxyHost", ""));
        this.mProxyPortText.setText(properties.getProperty("http.proxyPort", ""));
        this.mForceHttpCheck.setSelection(Boolean.parseBoolean(properties.getProperty("sdkman.force.http")));
        this.mAskAdbRestartCheck.setSelection(Boolean.parseBoolean(properties.getProperty("sdkman.ask.adb.restart")));
    }

    public void retrieveSettings(Properties properties) {
        properties.setProperty("http.proxyHost", this.mProxyServerText.getText());
        properties.setProperty("http.proxyPort", this.mProxyPortText.getText());
        properties.setProperty("sdkman.force.http", Boolean.toString(this.mForceHttpCheck.getSelection()));
        properties.setProperty("sdkman.ask.adb.restart", Boolean.toString(this.mAskAdbRestartCheck.getSelection()));
    }

    public void setOnSettingsChanged(ISettingsPage.SettingsChangedCallback settingsChangedCallback) {
        this.mSettingsChangedCallback = settingsChangedCallback;
    }

    private void applyNewSettings() {
        if (this.mSettingsChangedCallback != null) {
            this.mSettingsChangedCallback.onSettingsChanged(this);
        }
    }
}

