/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.MainFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class ImageTransferHandler
extends TransferHandler {
    private final MainFrame mainFrame;

    ImageTransferHandler(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                if (dataFlavor.isFlavorJavaFileListType()) {
                    Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)((List)object).get(0);
                    this.mainFrame.open(file).execute();
                    return true;
                }
                if (!dataFlavor.isFlavorTextType() || dataFlavor.getRepresentationClass() != String.class) continue;
                String string = dataFlavor.getMimeType();
                DataFlavor dataFlavor2 = new DataFlavor(string);
                Object object = transferable.getTransferData(dataFlavor2);
                String string2 = ImageTransferHandler.convertPath(object.toString());
                this.mainFrame.open(new File(string2)).execute();
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static String convertPath(String string) {
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        }
        if (string.indexOf(10) != -1) {
            string = string.substring(0, string.indexOf(10));
        }
        if (string.indexOf(13) != -1) {
            string = string.substring(0, string.indexOf(13));
        }
        return string;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.isFlavorJavaFileListType() && !dataFlavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }
}

