/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class SdkStatsPermissionDialog
extends Dialog {
    private static final String HEADER_TEXT = "Thanks for using the Android SDK!";
    public static final String NOTICE_TEXT = "We know you just want to get started but please read this first.";
    public static final String BODY_TEXT = "By choosing to send certain usage statistics to Google, you can help us improve the Android SDK. These usage statistics lets us measure things like active usage of the SDK, and let us know things like which versions of the SDK are in use and which tools are the most popular with developers. This limited data is not associated with personal information about you, and is examined on an aggregate basis, and is maintained in accordance with the Google Privacy Policy.";
    public static final String PRIVACY_POLICY_LINK_TEXT = "<a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>";
    public static final String CHECKBOX_TEXT = "Send usage statistics to Google.";
    public static final String FOOTER_TEXT = "If you later decide to change this setting, you can do so in the\"ddms\" tool under \"File\" > \"Preferences\" > \"Usage Stats\".";
    private static final String BUTTON_TEXT = "Proceed";
    private static final String[] LINUX_BROWSERS = new String[]{"firefox -remote openurl(%URL%,new-window)", "mozilla -remote openurl(%URL%,new-window)", "firefox %URL%", "mozilla %URL%", "kfmclient openURL %URL%", "opera -newwindow %URL%"};
    private static final boolean ALLOW_PING_DEFAULT = true;
    private boolean mAllowPing = true;

    public SdkStatsPermissionDialog(Shell shell) {
        super(shell);
        this.setBlockOnOpen(true);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, BUTTON_TEXT, true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite2, 0x1000040);
        FontData[] fontDataArray = label.getFont().getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setHeight(fontDataArray[i].getHeight() * 4 / 3);
        }
        label.setFont(new Font((Device)this.getShell().getDisplay(), fontDataArray));
        label.setLayoutData((Object)new GridData(768));
        label.setText(HEADER_TEXT);
        Label label2 = new Label(composite2, 64);
        label2.setFont(label.getFont());
        label2.setForeground(new Color((Device)this.getShell().getDisplay(), 255, 0, 0));
        label2.setLayoutData((Object)new GridData(768));
        label2.setText(NOTICE_TEXT);
        label2.pack();
        Label label3 = new Label(composite2, 64);
        GridData gridData = new GridData();
        gridData.widthHint = label2.getSize().x;
        gridData.grabExcessHorizontalSpace = true;
        label3.setLayoutData((Object)gridData);
        label3.setText(BODY_TEXT);
        Link link = new Link(composite2, 0);
        link.setText(PRIVACY_POLICY_LINK_TEXT);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SdkStatsPermissionDialog.openUrl(selectionEvent.text);
            }
        });
        final Button button = new Button(composite2, 32);
        button.setSelection(true);
        button.setText(CHECKBOX_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SdkStatsPermissionDialog.this.mAllowPing = button.getSelection();
            }
        });
        Label label4 = new Label(composite2, 64);
        gridData = new GridData();
        gridData.widthHint = label2.getSize().x;
        gridData.grabExcessHorizontalSpace = true;
        label4.setLayoutData((Object)gridData);
        label4.setText(FOOTER_TEXT);
        return composite2;
    }

    public static void openUrl(final String string) {
        if (!Program.launch((String)string)) {
            new Thread(){

                public void run() {
                    for (String string2 : LINUX_BROWSERS) {
                        string2 = string2.replaceAll("%URL%", string);
                        try {
                            Process process = Runtime.getRuntime().exec(string2);
                            if (process.waitFor() != 0) continue;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
    }

    public boolean getPingUserPreference() {
        return this.mAllowPing;
    }
}

