/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkstats.SdkStatsPermissionDialog;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SdkStatsService {
    private static final long PING_INTERVAL_MSEC = 86400000L;
    private DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    public void ping(String string, String string2) {
        this.doPing(string, string2);
    }

    public void checkUserPermissionForPing(Shell shell) {
        if (!this.mStore.hasPingId()) {
            this.askUserPermissionForPing(shell);
            this.mStore.generateNewPingId();
        }
    }

    private void askUserPermissionForPing(final Shell shell) {
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                SdkStatsPermissionDialog sdkStatsPermissionDialog = new SdkStatsPermissionDialog(shell);
                sdkStatsPermissionDialog.open();
                SdkStatsService.this.mStore.setPingOptIn(sdkStatsPermissionDialog.getPingUserPreference());
            }
        });
    }

    private void doPing(final String string, String string2) {
        long l;
        final String string3 = SdkStatsService.normalizeVersion(string, string2);
        if (!this.mStore.isPingOptIn()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - (l = this.mStore.getPingTime(string)) < 86400000L) {
            return;
        }
        this.mStore.setPingTime(string, l2);
        final long l3 = this.mStore.getPingId();
        new Thread(){

            public void run() {
                try {
                    SdkStatsService.actuallySendPing(string, string3, l3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }.start();
    }

    private static void actuallySendPing(String string, String string2, long l) throws IOException {
        String string3 = URLEncoder.encode(SdkStatsService.getOsName(), "UTF-8");
        String string4 = URLEncoder.encode(SdkStatsService.getOsArch(), "UTF-8");
        String string5 = URLEncoder.encode(SdkStatsService.getJvmInfo(), "UTF-8");
        URL uRL = new URL("http", "tools.google.com", "/service/update?as=androidsdk_" + string + "&id=" + Long.toHexString(l) + "&version=" + string2 + "&os=" + string3 + "&osa=" + string4 + "&vma=" + string5);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (httpURLConnection.getResponseCode() != 200 && httpURLConnection.getResponseCode() != 404) {
            throw new IOException(httpURLConnection.getResponseMessage() + ": " + uRL);
        }
    }

    private static String getOsName() {
        String string = System.getProperty("os.name");
        if (string == null || string.length() == 0) {
            return "unknown";
        }
        if (string.startsWith("Mac OS")) {
            string = "mac";
            String string2 = SdkStatsService.getOsVersion();
            if (string2 != null) {
                string = string + '-' + string2;
            }
        } else if (string.startsWith("Windows")) {
            string = "win";
            String string3 = SdkStatsService.getOsVersion();
            if (string3 != null) {
                string = string + '-' + string3;
            }
        } else if (string.startsWith("Linux")) {
            string = "linux";
        } else if (string.length() > 32) {
            string = string.substring(0, 32);
        }
        return string;
    }

    private static String getOsArch() {
        String string = SdkStatsService.getJvmArch();
        if ("x86_64".equals(string)) {
            return string;
        }
        if ("x86".equals(string)) {
            String string2 = SdkStatsService.getOsName();
            if (string2.startsWith("win")) {
                String string3 = System.getenv("PROCESSOR_ARCHITEW6432");
                if (string3 != null && string3.indexOf("64") != -1) {
                    return "x86_64";
                }
            } else if (string2.startsWith("linux")) {
                String string4 = System.getenv("HOSTTYPE");
                if ((string4 = SdkStatsService.sanitizeOsArch(string4)).indexOf("86") != -1) {
                    string = string4;
                }
            }
        }
        return string;
    }

    private static String getOsVersion() {
        String string;
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher matcher = pattern.matcher(string = System.getProperty("os.version"));
        if (matcher.matches()) {
            return matcher.group(1) + '.' + matcher.group(2);
        }
        return null;
    }

    private static String getJvmInfo() {
        return SdkStatsService.getJvmVersion() + '-' + SdkStatsService.getJvmArch();
    }

    private static String getJvmVersion() {
        String string = System.getProperty("java.version");
        if (string == null || string.length() == 0) {
            return "unknown";
        }
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1) + '.' + matcher.group(2);
        }
        if (string.length() > 8) {
            string = string.substring(0, 8);
        }
        return string;
    }

    private static String getJvmArch() {
        String string = System.getProperty("os.arch");
        return SdkStatsService.sanitizeOsArch(string);
    }

    private static String sanitizeOsArch(String string) {
        if (string == null || string.length() == 0) {
            return "unknown";
        }
        if (string.equalsIgnoreCase("x86_64") || string.equalsIgnoreCase("ia64") || string.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        if (string.length() == 4 && string.charAt(0) == 'i' && string.lastIndexOf("86") == 2) {
            return "x86";
        }
        if (string.equalsIgnoreCase("PowerPC")) {
            return "ppc";
        }
        if (string.length() > 32) {
            string = string.substring(0, 32);
        }
        return string;
    }

    private static String normalizeVersion(String string, String string2) {
        if (!string.matches("\\w+")) {
            throw new IllegalArgumentException("Bad app name: " + string);
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray.length > 4) {
            throw new IllegalArgumentException("Bad version: " + string2);
        }
        for (String string3 : stringArray) {
            if (string3.matches("\\d+")) continue;
            throw new IllegalArgumentException("Bad version: " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < 4; ++i) {
            stringBuffer.append('.').append(i < stringArray.length ? stringArray[i] : "0");
        }
        return stringBuffer.toString();
    }
}

