/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.IMinPlatformToolsDependency;
import com.android.sdklib.internal.repository.IMinToolsDependency;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.IPlatformDependency;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSources;
import com.android.sdklib.internal.repository.SystemImagePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.IUpdaterData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SdkUpdaterLogic {
    private final IUpdaterData mUpdaterData;

    public SdkUpdaterLogic(IUpdaterData iUpdaterData) {
        this.mUpdaterData = iUpdaterData;
    }

    public List<ArchiveInfo> getAllRemoteArchives(SdkSources sdkSources, Package[] packageArray, boolean bl) {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        SdkSource[] sdkSourceArray = sdkSources.getAllSources();
        this.fetchRemotePackages(arrayList, sdkSourceArray);
        ArrayList<Archive> arrayList2 = new ArrayList<Archive>();
        block0: for (Package archiveInfoArray2 : arrayList) {
            if (!bl && archiveInfoArray2.isObsolete()) continue;
            for (Archive archive : archiveInfoArray2.getArchives()) {
                if (!archive.isCompatible()) continue;
                for (int i = arrayList2.size() - 1; i >= 0; --i) {
                    Package package_ = arrayList2.get(i).getParentPackage();
                    if (package_.canBeUpdatedBy(archiveInfoArray2) == Package.UpdateInfo.UPDATE) {
                        arrayList2.remove(i);
                        continue;
                    }
                    if (archiveInfoArray2.canBeUpdatedBy(package_) == Package.UpdateInfo.UPDATE) continue block0;
                }
                arrayList2.add(archive);
                continue block0;
            }
        }
        ArrayList arrayList3 = new ArrayList();
        ArchiveInfo[] archiveInfoArray = this.createLocalArchives(packageArray);
        for (Archive archive : arrayList2) {
            this.insertArchive(archive, arrayList3, arrayList2, arrayList, sdkSourceArray, archiveInfoArray, false);
        }
        return arrayList3;
    }

    public List<ArchiveInfo> computeUpdates(Collection<Archive> collection, SdkSources sdkSources, Package[] packageArray, boolean bl) {
        ArrayList<ArchiveInfo> arrayList = new ArrayList<ArchiveInfo>();
        ArrayList<Package> arrayList2 = new ArrayList<Package>();
        SdkSource[] sdkSourceArray = sdkSources.getAllSources();
        ArchiveInfo[] archiveInfoArray = this.createLocalArchives(packageArray);
        if (collection == null) {
            collection = this.findUpdates(archiveInfoArray, arrayList2, sdkSourceArray, bl);
        }
        for (Archive archive : collection) {
            this.insertArchive(archive, arrayList, collection, arrayList2, sdkSourceArray, archiveInfoArray, false);
        }
        this.fixMissingLocalDependencies(arrayList, collection, arrayList2, sdkSourceArray, archiveInfoArray);
        return arrayList;
    }

    public void addNewPlatforms(Collection<ArchiveInfo> collection, SdkSources sdkSources, Package[] packageArray, boolean bl) {
        int n;
        int n2;
        ArchiveInfo[] archiveInfoArray = this.createLocalArchives(packageArray);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        if (!bl && packageArray != null) {
            for (Package package_ : packageArray) {
                int n3 = package_.getRevision();
                n2 = 0;
                n = 0;
                if (package_ instanceof IPackageVersion) {
                    AndroidVersion androidVersion = ((IPackageVersion)package_).getVersion();
                    n2 = androidVersion.getApiLevel();
                    n = androidVersion.isPreview();
                }
                float f5 = (float)(n2 * 10 + (n != 0 ? 1 : 0)) + (float)n3 / 100.0f;
                if (package_ instanceof PlatformPackage) {
                    f = Math.max(f, f5);
                    continue;
                }
                if (package_ instanceof SamplePackage) {
                    f2 = Math.max(f2, f5);
                    continue;
                }
                if (package_ instanceof AddonPackage) {
                    f3 = Math.max(f3, f5);
                    continue;
                }
                if (package_ instanceof ExtraPackage) {
                    hashMap.put(((ExtraPackage)package_).getPath(), Float.valueOf(f5));
                    continue;
                }
                if (!(package_ instanceof DocPackage)) continue;
                f4 = Math.max(f4, f5);
            }
        }
        SdkSource[] sdkSourceArray = sdkSources.getAllSources();
        ArrayList<Package> arrayList = new ArrayList<Package>();
        this.fetchRemotePackages(arrayList, sdkSourceArray);
        Package package_ = null;
        for (Package package_2 : arrayList) {
            PlatformPackage platformPackage;
            Object object;
            if (package_2.isObsolete() && !bl) continue;
            n2 = package_2.getRevision();
            n = 0;
            boolean bl2 = false;
            if (package_2 instanceof IPackageVersion) {
                AndroidVersion androidVersion = ((IPackageVersion)package_2).getVersion();
                n = androidVersion.getApiLevel();
                bl2 = androidVersion.isPreview();
            }
            float f6 = (float)(n * 10 + (bl2 ? 1 : 0)) + (float)n2 / 100.0f;
            boolean bl3 = false;
            if (package_2 instanceof PlatformPackage) {
                bl3 = f6 > f;
            } else if (package_2 instanceof SamplePackage) {
                bl3 = f6 > f2;
            } else if (package_2 instanceof AddonPackage) {
                bl3 = f6 > f3;
            } else if (package_2 instanceof ExtraPackage) {
                object = ((ExtraPackage)package_2).getPath();
                bl3 = !hashMap.containsKey(object) || f6 > ((Float)hashMap.get(object)).floatValue();
            } else if (package_2 instanceof DocPackage && f6 > f4) {
                package_ = package_2;
                f4 = f6;
            }
            if (bl3) {
                object = package_2.getArchives();
                int n4 = ((Archive[])object).length;
                for (int i = 0; i < n4; ++i) {
                    platformPackage = object[i];
                    if (!platformPackage.isCompatible()) continue;
                    this.insertArchive((Archive)platformPackage, collection, null, arrayList, sdkSourceArray, archiveInfoArray, true);
                }
            }
            if (!(package_2 instanceof PlatformPackage) || !(f6 >= f) || (object = (PlatformPackage)package_2).getIncludedAbi() != null) continue;
            for (Package package_3 : arrayList) {
                if (!(package_3 instanceof SystemImagePackage) || package_3.isObsolete() && !bl || !(platformPackage = (SystemImagePackage)package_3).getVersion().equals((Object)object.getVersion())) continue;
                for (Archive archive : platformPackage.getArchives()) {
                    if (!archive.isCompatible()) continue;
                    this.insertArchive(archive, collection, null, arrayList, sdkSourceArray, archiveInfoArray, true);
                }
            }
        }
        if (package_ != null) {
            for (Archive archive : package_.getArchives()) {
                if (!archive.isCompatible()) continue;
                this.insertArchive(archive, collection, null, arrayList, sdkSourceArray, archiveInfoArray, true);
            }
        }
    }

    protected ArchiveInfo[] createLocalArchives(Package[] packageArray) {
        if (packageArray != null) {
            ArrayList<LocalArchiveInfo> arrayList = new ArrayList<LocalArchiveInfo>();
            for (Package package_ : packageArray) {
                for (Archive archive : package_.getArchives()) {
                    if (archive == null || !archive.isCompatible()) continue;
                    arrayList.add(new LocalArchiveInfo(archive));
                }
            }
            return arrayList.toArray(new ArchiveInfo[arrayList.size()]);
        }
        return new ArchiveInfo[0];
    }

    private Collection<Archive> findUpdates(ArchiveInfo[] archiveInfoArray, Collection<Package> collection, SdkSource[] sdkSourceArray, boolean bl) {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        this.fetchRemotePackages(collection, sdkSourceArray);
        for (ArchiveInfo archiveInfo : archiveInfoArray) {
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null) continue;
            Package package_ = archive.getParentPackage();
            block1: for (Package package_2 : collection) {
                if (!bl && package_2.isObsolete() || package_.canBeUpdatedBy(package_2) != Package.UpdateInfo.UPDATE) continue;
                for (Archive archive2 : package_2.getArchives()) {
                    if (!archive2.isCompatible()) continue;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Package package_3 = arrayList.get(i).getParentPackage();
                        if (package_3.canBeUpdatedBy(package_2) == Package.UpdateInfo.UPDATE) {
                            arrayList.remove(i);
                            continue;
                        }
                        if (package_2.canBeUpdatedBy(package_3) == Package.UpdateInfo.UPDATE) continue block1;
                    }
                    arrayList.add(archive2);
                    continue block1;
                }
            }
        }
        return arrayList;
    }

    private void fixMissingLocalDependencies(Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        block0: for (ArchiveInfo archiveInfo : archiveInfoArray) {
            Package package_;
            Archive archive = archiveInfo.getNewArchive();
            Package package_2 = package_ = archive == null ? null : archive.getParentPackage();
            if (package_ == null) continue;
            for (ArchiveInfo archiveInfo2 : collection) {
                if (archiveInfo2.getReplaced() != archive) continue;
                continue block0;
            }
            ArchiveInfo[] archiveInfoArray3 = this.findDependency(package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray);
            if (archiveInfoArray3 == null) continue;
            for (ArchiveInfo archiveInfo3 : archiveInfoArray3) {
                archiveInfo3.addDependencyFor(archiveInfo);
            }
        }
    }

    private ArchiveInfo insertArchive(Archive archive, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray, boolean bl) {
        Archive archive2;
        Package package_ = archive.getParentPackage();
        Archive archive3 = null;
        for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
            Package object;
            archive2 = archiveInfo2.getNewArchive();
            if (archive2 == null || (object = archive2.getParentPackage()).canBeUpdatedBy(package_) != Package.UpdateInfo.UPDATE) continue;
            archive3 = archive2;
        }
        ArchiveInfo[] archiveInfoArray2 = this.findDependency(package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray);
        ArchiveInfo archiveInfo = null;
        for (ArchiveInfo archiveInfo2 : collection) {
            archive2 = archiveInfo2.getNewArchive();
            if (archive2 == null || !archive2.getParentPackage().sameItemAs(archive.getParentPackage())) continue;
            archiveInfo = archiveInfo2;
            break;
        }
        if (archiveInfo == null) {
            archiveInfo = new ArchiveInfo(archive, archive3, archiveInfoArray2);
            collection.add(archiveInfo);
        }
        if (archiveInfoArray2 != null) {
            for (ArchiveInfo archiveInfo2 : archiveInfoArray2) {
                archiveInfo2.addDependencyFor(archiveInfo);
            }
        }
        return archiveInfo;
    }

    private ArchiveInfo[] findDependency(Package package_, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        Object[] objectArray;
        HashSet<Object[]> hashSet = new HashSet<Object[]>();
        if (package_ instanceof IPlatformDependency && (objectArray = this.findPlatformDependency((IPlatformDependency)package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray)) != null) {
            hashSet.add(objectArray);
        }
        if (package_ instanceof IMinToolsDependency && (objectArray = this.findToolsDependency((IMinToolsDependency)package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray)) != null) {
            hashSet.add(objectArray);
        }
        if (package_ instanceof IMinPlatformToolsDependency && (objectArray = this.findPlatformToolsDependency((IMinPlatformToolsDependency)package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray)) != null) {
            hashSet.add(objectArray);
        }
        if (package_ instanceof IMinApiLevelDependency && (objectArray = this.findMinApiLevelDependency((IMinApiLevelDependency)package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray)) != null) {
            hashSet.add(objectArray);
        }
        if (package_ instanceof IExactApiLevelDependency && (objectArray = this.findExactApiLevelDependency((IExactApiLevelDependency)package_, collection, collection2, collection3, sdkSourceArray, archiveInfoArray)) != null) {
            hashSet.add(objectArray);
        }
        if (hashSet.size() > 0) {
            objectArray = hashSet.toArray(new ArchiveInfo[hashSet.size()]);
            Arrays.sort(objectArray);
            return objectArray;
        }
        return null;
    }

    protected ArchiveInfo findToolsDependency(IMinToolsDependency iMinToolsDependency, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        int n = iMinToolsDependency.getMinToolsRevision();
        if (n == 0) {
            return null;
        }
        for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
            Package package_2;
            Archive archive = archiveInfo2.getNewArchive();
            if (archive == null || !((package_2 = archive.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)package_2).getRevision() < n) continue;
            return null;
        }
        for (ArchiveInfo archiveInfo : collection) {
            ArchiveInfo archiveInfo2;
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null || !((archiveInfo2 = archive.getParentPackage()) instanceof ToolPackage) || ((ToolPackage)archiveInfo2).getRevision() < n) continue;
            return archiveInfo;
        }
        if (collection2 != null) {
            for (Archive archive : collection2) {
                Package package_ = archive.getParentPackage();
                if (!(package_ instanceof ToolPackage) || ((ToolPackage)package_).getRevision() < n) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        this.fetchRemotePackages(collection3, sdkSourceArray);
        for (Package package_ : collection3) {
            if (!(package_ instanceof ToolPackage) || ((ToolPackage)package_).getRevision() < n) continue;
            for (Archive archive : package_.getArchives()) {
                if (!archive.isCompatible()) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        return new MissingArchiveInfo("Tools", n);
    }

    protected ArchiveInfo findPlatformToolsDependency(IMinPlatformToolsDependency iMinPlatformToolsDependency, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        int n = iMinPlatformToolsDependency.getMinPlatformToolsRevision();
        boolean bl = false;
        ArchiveInfo archiveInfo = null;
        Archive archive = null;
        if (n == 0) {
            bl = true;
        }
        for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
            Package package_;
            Archive archive2 = archiveInfo2.getNewArchive();
            if (archive2 == null || !((package_ = archive2.getParentPackage()) instanceof PlatformToolPackage)) continue;
            int n2 = ((PlatformToolPackage)package_).getRevision();
            if (bl && n2 > n) {
                n = n2;
                archiveInfo = archiveInfo2;
                continue;
            }
            if (bl || n2 < n) continue;
            return null;
        }
        for (ArchiveInfo archiveInfo3 : collection) {
            ArchiveInfo archiveInfo2;
            Archive archive3 = archiveInfo3.getNewArchive();
            if (archive3 == null || !((archiveInfo2 = archive3.getParentPackage()) instanceof PlatformToolPackage)) continue;
            int n3 = ((PlatformToolPackage)archiveInfo2).getRevision();
            if (bl && n3 > n) {
                n = n3;
                archiveInfo = archiveInfo3;
                continue;
            }
            if (bl || n3 < n) continue;
            return archiveInfo3;
        }
        if (collection2 != null) {
            for (Archive archive4 : collection2) {
                Package package_ = archive4.getParentPackage();
                if (!(package_ instanceof PlatformToolPackage)) continue;
                int n4 = ((PlatformToolPackage)package_).getRevision();
                if (bl && n4 > n) {
                    n = n4;
                    archiveInfo = null;
                    archive = archive4;
                    continue;
                }
                if (bl || n4 < n) continue;
                return this.insertArchive(archive4, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        this.fetchRemotePackages(collection3, sdkSourceArray);
        for (Package package_ : collection3) {
            int n5;
            if (!(package_ instanceof PlatformToolPackage) || (n5 = ((PlatformToolPackage)package_).getRevision()) < n) continue;
            for (Archive archive5 : package_.getArchives()) {
                if (!archive5.isCompatible()) continue;
                if (bl && n5 > n) {
                    n = n5;
                    archiveInfo = null;
                    archive = archive5;
                    continue;
                }
                if (bl || n5 < n) continue;
                return this.insertArchive(archive5, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        if (bl) {
            if (archive != null) {
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
            if (archiveInfo != null) {
                return archiveInfo;
            }
        }
        return new MissingArchiveInfo("Platform-tools", n);
    }

    protected ArchiveInfo findPlatformDependency(IPlatformDependency iPlatformDependency, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        AndroidVersion androidVersion = iPlatformDependency.getVersion();
        for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
            Package package_2;
            Archive archive = archiveInfo2.getNewArchive();
            if (archive == null || !((package_2 = archive.getParentPackage()) instanceof PlatformPackage) || !androidVersion.equals((Object)((PlatformPackage)package_2).getVersion())) continue;
            return null;
        }
        for (ArchiveInfo archiveInfo : collection) {
            ArchiveInfo archiveInfo2;
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null || !((archiveInfo2 = archive.getParentPackage()) instanceof PlatformPackage) || !androidVersion.equals((Object)((PlatformPackage)archiveInfo2).getVersion())) continue;
            return archiveInfo;
        }
        if (collection2 != null) {
            for (Archive archive : collection2) {
                Package package_ = archive.getParentPackage();
                if (!(package_ instanceof PlatformPackage) || !androidVersion.equals((Object)((PlatformPackage)package_).getVersion())) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        this.fetchRemotePackages(collection3, sdkSourceArray);
        for (Package package_ : collection3) {
            if (!(package_ instanceof PlatformPackage) || !androidVersion.equals((Object)((PlatformPackage)package_).getVersion())) continue;
            for (Archive archive : package_.getArchives()) {
                if (!archive.isCompatible()) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        return new MissingPlatformArchiveInfo(iPlatformDependency.getVersion());
    }

    protected ArchiveInfo findMinApiLevelDependency(IMinApiLevelDependency iMinApiLevelDependency, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        Package package_;
        int n = iMinApiLevelDependency.getMinApiLevel();
        if (n == 0) {
            return null;
        }
        for (ArchiveInfo object : archiveInfoArray) {
            Archive archive = object.getNewArchive();
            if (archive == null || !((package_ = archive.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)package_).getVersion().isGreaterOrEqualThan(n)) continue;
            return null;
        }
        int n2 = 0;
        ArchiveInfo iterator = null;
        for (ArchiveInfo archiveInfo : collection) {
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null || !((package_ = archive.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)package_).getVersion().isGreaterOrEqualThan(n) || n <= n2) continue;
            n2 = n;
            iterator = archiveInfo;
        }
        if (iterator != null) {
            return iterator;
        }
        n2 = 0;
        Archive archive2 = null;
        if (collection2 != null) {
            for (Archive archive : collection2) {
                package_ = archive.getParentPackage();
                if (!(package_ instanceof PlatformPackage) || !((PlatformPackage)package_).getVersion().isGreaterOrEqualThan(n) || n <= n2) continue;
                n2 = n;
                archive2 = archive;
            }
        }
        this.fetchRemotePackages(collection3, sdkSourceArray);
        for (Package package_2 : collection3) {
            if (!(package_2 instanceof PlatformPackage) || !((PlatformPackage)package_2).getVersion().isGreaterOrEqualThan(n) || n <= n2) continue;
            for (Archive archive : package_2.getArchives()) {
                if (!archive.isCompatible()) continue;
                n2 = n;
                archive2 = archive;
            }
        }
        if (archive2 != null) {
            return this.insertArchive(archive2, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
        }
        return new MissingPlatformArchiveInfo(new AndroidVersion(n, null));
    }

    protected ArchiveInfo findExactApiLevelDependency(IExactApiLevelDependency iExactApiLevelDependency, Collection<ArchiveInfo> collection, Collection<Archive> collection2, Collection<Package> collection3, SdkSource[] sdkSourceArray, ArchiveInfo[] archiveInfoArray) {
        int n = iExactApiLevelDependency.getExactApiLevel();
        if (n == 0) {
            return null;
        }
        for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
            Package package_2;
            Archive archive = archiveInfo2.getNewArchive();
            if (archive == null || !((package_2 = archive.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)package_2).getVersion().equals(n)) continue;
            return null;
        }
        for (ArchiveInfo archiveInfo : collection) {
            ArchiveInfo archiveInfo2;
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null || !((archiveInfo2 = archive.getParentPackage()) instanceof PlatformPackage) || !((PlatformPackage)archiveInfo2).getVersion().equals(n)) continue;
            return archiveInfo;
        }
        if (collection2 != null) {
            for (Archive archive : collection2) {
                Package package_ = archive.getParentPackage();
                if (!(package_ instanceof PlatformPackage) || !((PlatformPackage)package_).getVersion().equals(n)) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        this.fetchRemotePackages(collection3, sdkSourceArray);
        for (Package package_ : collection3) {
            if (!(package_ instanceof PlatformPackage) || !((PlatformPackage)package_).getVersion().equals(n)) continue;
            for (Archive archive : package_.getArchives()) {
                if (!archive.isCompatible()) continue;
                return this.insertArchive(archive, collection, collection2, collection3, sdkSourceArray, archiveInfoArray, true);
            }
        }
        return new MissingPlatformArchiveInfo(new AndroidVersion(n, null));
    }

    protected void fetchRemotePackages(final Collection<Package> collection, final SdkSource[] sdkSourceArray) {
        if (collection.size() > 0) {
            return;
        }
        boolean bl = false;
        for (SdkSource sdkSource : sdkSourceArray) {
            Package[] packageArray = sdkSource.getPackages();
            if (packageArray == null) {
                bl = true;
                continue;
            }
            block1: for (Package package_ : packageArray) {
                for (Archive archive : package_.getArchives()) {
                    if (!archive.isCompatible() || collection.contains(package_)) continue;
                    collection.add(package_);
                    continue block1;
                }
            }
        }
        if (!bl) {
            return;
        }
        final boolean bl2 = this.mUpdaterData.getSettingsController().getForceHttp();
        this.mUpdaterData.getTaskFactory().start("Refresh Sources", new ITask(){

            public void run(ITaskMonitor iTaskMonitor) {
                for (SdkSource sdkSource : sdkSourceArray) {
                    Package[] packageArray = sdkSource.getPackages();
                    if (packageArray == null) {
                        sdkSource.load(iTaskMonitor, bl2);
                        packageArray = sdkSource.getPackages();
                    }
                    if (packageArray == null) continue;
                    block1: for (Package package_ : packageArray) {
                        for (Archive archive : package_.getArchives()) {
                            if (!archive.isCompatible() || collection.contains(package_)) continue;
                            collection.add(package_);
                            continue block1;
                        }
                    }
                }
            }
        });
    }

    private static class MissingArchiveInfo
    extends ArchiveInfo {
        private final int mRevision;
        private final String mTitle;
        public static final String TITLE_TOOL = "Tools";
        public static final String TITLE_PLATFORM_TOOL = "Platform-tools";

        public MissingArchiveInfo(String string, int n) {
            super(null, null, null);
            this.mTitle = string;
            this.mRevision = n;
        }

        public boolean isAccepted() {
            return false;
        }

        public boolean isRejected() {
            return true;
        }

        public String getShortDescription() {
            return String.format("Missing Android SDK %1$s, revision %2$d", this.mTitle, this.mRevision);
        }
    }

    private static class MissingPlatformArchiveInfo
    extends ArchiveInfo {
        private final AndroidVersion mVersion;

        public MissingPlatformArchiveInfo(AndroidVersion androidVersion) {
            super(null, null, null);
            this.mVersion = androidVersion;
        }

        public boolean isAccepted() {
            return false;
        }

        public boolean isRejected() {
            return true;
        }

        public String getShortDescription() {
            return String.format("Missing SDK Platform Android%1$s, API %2$d", this.mVersion.isPreview() ? " Preview" : "", this.mVersion.getApiLevel());
        }
    }

    private static class LocalArchiveInfo
    extends ArchiveInfo {
        public LocalArchiveInfo(Archive archive) {
            super(archive, null, null);
        }

        public boolean isAccepted() {
            return true;
        }

        public boolean isRejected() {
            return false;
        }
    }
}

