/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdkuilib.internal.repository.ISettingsPage;
import com.android.sdkuilib.internal.repository.UpdaterData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SettingsController {
    private static final String SETTINGS_FILENAME = "androidtool.cfg";
    private final Properties mProperties = new Properties();
    private ISettingsPage mSettingsPage;
    private final UpdaterData mUpdaterData;

    public SettingsController(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
    }

    public boolean getForceHttp() {
        return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.force.http"));
    }

    public boolean getAskBeforeAdbRestart() {
        return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.ask.adb.restart"));
    }

    public boolean getShowUpdateOnly() {
        String string = this.mProperties.getProperty("sdkman.show.update.only");
        if (string == null) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    public void setShowUpdateOnly(boolean bl) {
        this.setSetting("sdkman.show.update.only", bl);
    }

    public int getMonitorDensity() {
        String string = this.mProperties.getProperty("sdkman.monitor.density", null);
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setMonitorDensity(int n) {
        this.mProperties.setProperty("sdkman.monitor.density", Integer.toString(n));
    }

    void setSetting(String string, boolean bl) {
        this.mProperties.setProperty(string, Boolean.toString(bl));
    }

    public void setSettingsPage(ISettingsPage iSettingsPage) {
        this.mSettingsPage = iSettingsPage;
        if (iSettingsPage != null) {
            iSettingsPage.loadSettings(this.mProperties);
            iSettingsPage.setOnSettingsChanged(new ISettingsPage.SettingsChangedCallback(){

                public void onSettingsChanged(ISettingsPage iSettingsPage) {
                    SettingsController.this.onSettingsChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        FileInputStream fileInputStream = null;
        String string = null;
        try {
            String string2 = AndroidLocation.getFolder();
            File file = new File(string2, SETTINGS_FILENAME);
            string = file.getPath();
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                this.mProperties.load(fileInputStream);
                this.setShowUpdateOnly(this.getShowUpdateOnly());
                this.setSetting("sdkman.ask.adb.restart", this.getAskBeforeAdbRestart());
            }
        }
        catch (Exception exception) {
            ISdkLog iSdkLog = this.mUpdaterData.getSdkLog();
            if (iSdkLog != null) {
                iSdkLog.error((Throwable)exception, "Failed to load settings from .android folder. Path is '%1$s'.", new Object[]{string});
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        FileOutputStream fileOutputStream = null;
        String string = null;
        try {
            String string2 = AndroidLocation.getFolder();
            File file = new File(string2, SETTINGS_FILENAME);
            string = file.getPath();
            fileOutputStream = new FileOutputStream(file);
            this.mProperties.store(fileOutputStream, "## Settings for Android Tool");
        }
        catch (Exception exception) {
            ISdkLog iSdkLog = this.mUpdaterData.getSdkLog();
            if (iSdkLog != null) {
                iSdkLog.error((Throwable)exception, "Failed to save settings at '%1$s'", new Object[]{string});
            }
            String string3 = null;
            string3 = exception instanceof FileNotFoundException ? "File not found" : (exception instanceof AndroidLocation.AndroidLocationException ? ".android folder not found, please define ANDROID_SDK_HOME" : (exception.getMessage() != null ? String.format("%1$s: %2$s", exception.getClass().getSimpleName(), exception.getMessage()) : exception.getClass().getName()));
            MessageDialog.openInformation((Shell)this.mUpdaterData.getWindowShell(), (String)"SDK Manager Settings", (String)String.format("The Android SDK and AVD Manager failed to save its settings (%1$s) at %2$s", string3, string));
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void onSettingsChanged() {
        if (this.mSettingsPage == null) {
            return;
        }
        String string = this.mProperties.getProperty("sdkman.force.http", Boolean.FALSE.toString());
        this.mSettingsPage.retrieveSettings(this.mProperties);
        this.applySettings();
        this.saveSettings();
        String string2 = this.mProperties.getProperty("sdkman.force.http", Boolean.FALSE.toString());
        if (!string2.equals(string)) {
            this.mUpdaterData.refreshSources(false);
        }
    }

    public void applySettings() {
        Properties properties = System.getProperties();
        String string = this.mProperties.getProperty("http.proxyHost", "");
        String string2 = this.mProperties.getProperty("http.proxyPort", "");
        properties.setProperty("http.proxyHost", string);
        properties.setProperty("http.proxyPort", string2);
        properties.setProperty("https.proxyHost", string);
        properties.setProperty("https.proxyPort", string2);
    }
}

