/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.AdbWrapper;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.AddonsListFetcher;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.ArchiveInstaller;
import com.android.sdklib.internal.repository.ArchiveReplacement;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SdkAddonSource;
import com.android.sdklib.internal.repository.SdkRepoSource;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import com.android.sdklib.internal.repository.SdkSources;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.repository.SdkAddonConstants;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdklib.util.LineUtil;
import com.android.sdklib.util.SparseIntArray;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.IUpdaterData;
import com.android.sdkuilib.internal.repository.SdkUpdaterChooserDialog;
import com.android.sdkuilib.internal.repository.SdkUpdaterLogic;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.repository.ISdkChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdaterData
implements IUpdaterData {
    public static final int NO_TOOLS_MSG = 0;
    public static final int TOOLS_MSG_UPDATED_FROM_ADT = 1;
    public static final int TOOLS_MSG_UPDATED_FROM_SDKMAN = 2;
    private String mOsSdkRoot;
    private final ISdkLog mSdkLog;
    private ITaskFactory mTaskFactory;
    private SdkManager mSdkManager;
    private AvdManager mAvdManager;
    private final LocalSdkParser mLocalSdkParser = new LocalSdkParser();
    private final SdkSources mSources = new SdkSources();
    private ImageFactory mImageFactory;
    private final SettingsController mSettingsController;
    private final ArrayList<ISdkChangeListener> mListeners = new ArrayList();
    private Shell mWindowShell;
    private AndroidLocation.AndroidLocationException mAvdManagerInitError;
    private int mStateFetchRemoteAddonsList;

    public UpdaterData(String string, ISdkLog iSdkLog) {
        this.mOsSdkRoot = string;
        this.mSdkLog = iSdkLog;
        this.mSettingsController = new SettingsController(this);
        this.initSdk();
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    public void setTaskFactory(ITaskFactory iTaskFactory) {
        this.mTaskFactory = iTaskFactory;
    }

    @Override
    public ITaskFactory getTaskFactory() {
        return this.mTaskFactory;
    }

    public SdkSources getSources() {
        return this.mSources;
    }

    public LocalSdkParser getLocalSdkParser() {
        return this.mLocalSdkParser;
    }

    @Override
    public ISdkLog getSdkLog() {
        return this.mSdkLog;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    @Override
    public ImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    @Override
    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    @Override
    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    @Override
    public SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    public void addListeners(ISdkChangeListener iSdkChangeListener) {
        if (!this.mListeners.contains(iSdkChangeListener)) {
            this.mListeners.add(iSdkChangeListener);
        }
    }

    public void removeListener(ISdkChangeListener iSdkChangeListener) {
        this.mListeners.remove(iSdkChangeListener);
    }

    public void setWindowShell(Shell shell) {
        this.mWindowShell = shell;
    }

    @Override
    public Shell getWindowShell() {
        return this.mWindowShell;
    }

    public boolean checkIfInitFailed() {
        if (this.mAvdManagerInitError != null) {
            String string = SdkConstants.currentPlatform() == 2 ? "%USERPROFILE%" : "~";
            String string2 = String.format("The AVD manager normally uses the user's profile directory to store AVD files. However it failed to find the default profile directory. \nTo fix this, please set the environment variable ANDROID_SDK_HOME to a valid path such as \"%s\".", string);
            if (this.mWindowShell != null) {
                MessageDialog.openError((Shell)this.mWindowShell, (String)"Android Virtual Devices Manager", (String)string2);
            } else {
                this.mSdkLog.error(null, "%s", new Object[]{string2});
            }
            return true;
        }
        return false;
    }

    protected void initSdk() {
        this.setSdkManager(SdkManager.createManager((String)this.mOsSdkRoot, (ISdkLog)this.mSdkLog));
        try {
            this.mAvdManager = null;
            this.mAvdManager = new AvdManager(this.mSdkManager, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            this.mSdkLog.error((Throwable)androidLocationException, "Unable to read AVDs: " + androidLocationException.getMessage(), new Object[0]);
            this.mAvdManagerInitError = androidLocationException;
        }
        this.broadcastOnSdkReload();
    }

    protected void setSdkManager(SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        this.mLocalSdkParser.clearPackages();
        this.broadcastOnSdkReload();
    }

    public void reloadAvds() {
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                this.mSdkLog.error((Throwable)androidLocationException, null, new Object[0]);
            }
        }
    }

    public void setupDefaultSources() {
        SdkSources sdkSources = this.getSources();
        String string = System.getenv("SDK_TEST_BASE_URL");
        if (string == null || string.length() <= 0 || !string.endsWith("/")) {
            string = "https://dl-ssl.google.com/android/repository/";
        }
        sdkSources.add(SdkSourceCategory.ANDROID_REPO, (SdkSource)new SdkRepoSource(string, SdkSourceCategory.ANDROID_REPO.getUiName()));
        sdkSources.loadUserAddons(this.getSdkLog());
    }

    public Package[] getInstalledPackages(ITaskMonitor iTaskMonitor) {
        LocalSdkParser localSdkParser = this.getLocalSdkParser();
        Package[] packageArray = localSdkParser.getPackages();
        if (packageArray == null) {
            packageArray = localSdkParser.parseSdk(this.getOsSdkRoot(), this.getSdkManager(), iTaskMonitor);
        }
        return packageArray;
    }

    protected List<Archive> installArchives(final List<ArchiveInfo> list, final int n) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final ArrayList<Archive> arrayList = new ArrayList<Archive>();
        final boolean bl = this.getSettingsController().getForceHttp();
        Collections.sort(list, new InstallOrderComparator());
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ITaskMonitor iTaskMonitor) {
                iTaskMonitor.setProgressMax(1 + list.size() * 200);
                iTaskMonitor.setDescription("Preparing to install archives", new Object[0]);
                boolean bl5 = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (Package package_ : UpdaterData.this.getInstalledPackages(iTaskMonitor.createSubMonitor(1))) {
                    for (Archive archive : package_.getArchives()) {
                        hashSet.add(archive);
                    }
                }
                int n4 = 0;
                block12: for (ArchiveInfo archiveInfo : list) {
                    Object object;
                    Package package_;
                    package_ = archiveInfo.getNewArchive();
                    if (package_ == null) continue;
                    int n2 = iTaskMonitor.getProgress() + 200;
                    try {
                        if (iTaskMonitor.isCancelRequested()) break;
                        ArchiveInstaller archiveInstaller = archiveInfo.getDependsOn();
                        if (archiveInstaller != null) {
                            object = archiveInstaller;
                            int n3 = ((ArchiveInfo[])object).length;
                            for (int i = 0; i < n3; ++i) {
                                ArchiveInstaller archiveInstaller2 = object[i];
                                Archive archive = archiveInstaller2.getNewArchive();
                                if (archive == null) {
                                    iTaskMonitor.log("Skipping '%1$s'; it depends on a missing package.", new Object[]{package_.getParentPackage().getShortDescription()});
                                    continue block12;
                                }
                                if (hashSet.contains(archive)) continue;
                                iTaskMonitor.logError("Skipping '%1$s'; it depends on '%2$s' which was not installed.", new Object[]{package_.getParentPackage().getShortDescription(), archiveInstaller2.getShortDescription()});
                                continue block12;
                            }
                        }
                        if (!bl4) {
                            bl4 = true;
                            UpdaterData.this.broadcastPreInstallHook();
                        }
                        if (!(object = UpdaterData.this.createArchiveInstaler()).install((ArchiveReplacement)archiveInfo, UpdaterData.this.mOsSdkRoot, bl, UpdaterData.this.mSdkManager, iTaskMonitor)) continue;
                        arrayList.add(package_);
                        hashSet.add(package_);
                        ++n4;
                        hashSet.remove(archiveInfo.getReplaced());
                        if (package_.getParentPackage() instanceof AddonPackage) {
                            bl5 = true;
                            continue;
                        }
                        if (package_.getParentPackage() instanceof ToolPackage) {
                            bl2 = true;
                            continue;
                        }
                        if (!(package_.getParentPackage() instanceof PlatformToolPackage)) continue;
                        bl3 = true;
                    }
                    catch (Throwable throwable) {
                        object = throwable.getMessage();
                        if (object != null) {
                            object = String.format("Unexpected Error installing '%1$s': %2$s: %3$s", package_.getParentPackage().getShortDescription(), throwable.getClass().getCanonicalName(), object);
                        } else {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
                            object = String.format("Unexpected Error installing '%1$s'\n%2$s", package_.getParentPackage().getShortDescription(), byteArrayOutputStream.toString());
                        }
                        iTaskMonitor.log("%1$s", new Object[]{object});
                        UpdaterData.this.mSdkLog.error(throwable, "%1$s", new Object[]{object});
                    }
                    finally {
                        iTaskMonitor.incProgress(n2 - iTaskMonitor.getProgress());
                    }
                }
                if (bl5) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        iTaskMonitor.log("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception exception) {
                        UpdaterData.this.mSdkLog.error((Throwable)exception, "Update ADB failed", new Object[0]);
                        iTaskMonitor.logError("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (bl4) {
                    UpdaterData.this.broadcastPostInstallHook();
                }
                if (bl5 || bl3) {
                    UpdaterData.this.askForAdbRestart(iTaskMonitor);
                }
                if (bl2) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted(n);
                }
                if (n4 == 0) {
                    iTaskMonitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    iTaskMonitor.setDescription("Done. %1$d %2$s installed.", new Object[]{n4, n4 == 1 ? "package" : "packages"});
                    UpdaterData.this.reloadSdk();
                }
            }
        });
        return arrayList;
    }

    private void askForAdbRestart(ITaskMonitor iTaskMonitor) {
        Shell shell;
        final boolean[] blArray = new boolean[]{true};
        if (this.getWindowShell() != null && this.getSettingsController().getAskBeforeAdbRestart() && (shell = this.getWindowShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!shell.isDisposed()) {
                        blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)"ADB Restart", (String)"A package that depends on ADB has been updated. \nDo you want to restart ADB now?");
                    }
                }
            });
        }
        if (blArray[0]) {
            shell = new AdbWrapper(this.getOsSdkRoot(), iTaskMonitor);
            shell.stopAdb();
            shell.startAdb();
        }
    }

    private void notifyToolsNeedsToBeRestarted(int n) {
        String string = null;
        if ((n & 1) != 0) {
            string = "The Android SDK and AVD Manager that you are currently using has been updated. Please also run Eclipse > Help > Check for Updates to see if the Android plug-in needs to be updated.";
        } else if ((n & 2) != 0) {
            string = "The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you use Eclipse, please run Help > Check for Updates to see if the Android plug-in needs to be updated.";
        }
        final String string2 = string;
        final Shell shell = this.getWindowShell();
        if (string2 != null && shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!shell.isDisposed()) {
                        MessageDialog.openInformation((Shell)shell, (String)"Android Tools Updated", (String)string2);
                    }
                }
            });
        }
    }

    public List<Archive> updateOrInstallAll_WithGUI(Collection<Archive> collection, boolean bl, int n) {
        SdkUpdaterLogic sdkUpdaterLogic = new SdkUpdaterLogic(this);
        List<ArchiveInfo> list = sdkUpdaterLogic.computeUpdates(collection, this.getSources(), this.getLocalSdkParser().getPackages(), bl);
        if (collection == null) {
            this.loadRemoteAddonsList((ITaskMonitor)new NullTaskMonitor(this.getSdkLog()));
            sdkUpdaterLogic.addNewPlatforms(list, this.getSources(), this.getLocalSdkParser().getPackages(), bl);
        }
        Collections.sort(list);
        SdkUpdaterChooserDialog sdkUpdaterChooserDialog = new SdkUpdaterChooserDialog(this.getWindowShell(), this, list);
        sdkUpdaterChooserDialog.open();
        ArrayList<ArchiveInfo> arrayList = sdkUpdaterChooserDialog.getResult();
        if (arrayList != null && arrayList.size() > 0) {
            return this.installArchives(arrayList, n);
        }
        return null;
    }

    private List<ArchiveInfo> getRemoteArchives_NoGUI(boolean bl) {
        List<ArchiveInfo> list;
        this.refreshSources(true);
        this.loadRemoteAddonsList((ITaskMonitor)new NullTaskMonitor(this.getSdkLog()));
        SdkUpdaterLogic sdkUpdaterLogic = new SdkUpdaterLogic(this);
        if (bl) {
            list = sdkUpdaterLogic.getAllRemoteArchives(this.getSources(), this.getLocalSdkParser().getPackages(), bl);
        } else {
            list = sdkUpdaterLogic.computeUpdates(null, this.getSources(), this.getLocalSdkParser().getPackages(), bl);
            sdkUpdaterLogic.addNewPlatforms(list, this.getSources(), this.getLocalSdkParser().getPackages(), bl);
        }
        Collections.sort(list);
        return list;
    }

    public void listRemotePackages_NoGUI(boolean bl, boolean bl2) {
        List<ArchiveInfo> list = this.getRemoteArchives_NoGUI(bl);
        this.mSdkLog.printf("Packages available for installation or update: %1$d\n", new Object[]{list.size()});
        int n = 1;
        for (ArchiveInfo archiveInfo : list) {
            Package package_;
            Archive archive = archiveInfo.getNewArchive();
            if (archive == null || (package_ = archive.getParentPackage()) == null) continue;
            if (bl2) {
                this.mSdkLog.printf("----------\n", new Object[0]);
                this.mSdkLog.printf("id: %1$d or \"%2$s\"\n", new Object[]{n, package_.installId()});
                this.mSdkLog.printf("     Type: %1$s\n", new Object[]{package_.getClass().getSimpleName().replaceAll("Package", "")});
                String string = LineUtil.reformatLine((String)"     Desc: %s\n", (Object[])new Object[]{package_.getLongDescription()});
                this.mSdkLog.printf("%s", new Object[]{string});
            } else {
                this.mSdkLog.printf("%1$ 4d- %2$s\n", new Object[]{n, package_.getShortDescription()});
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Archive> updateOrInstallAll_NoGUI(Collection<String> collection, boolean bl, boolean bl2) {
        Object object;
        List<ArchiveInfo> list = this.getRemoteArchives_NoGUI(bl);
        if (collection != null && collection.size() > 0 && list != null && list.size() > 0) {
            int n;
            Object object2;
            Object object3 = new HashMap<String, Class<? extends Package>>();
            this.mapFilterToPackageClass((HashMap<String, Class<? extends Package>>)object3, SdkRepoConstants.NODES);
            this.mapFilterToPackageClass((HashMap<String, Class<? extends Package>>)object3, SdkAddonConstants.NODES);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (ArchiveInfo archiveInfo : list) {
                String string;
                Object object4;
                object2 = archiveInfo.getNewArchive();
                if (object2 == null || (object4 = object2.getParentPackage()) == null || (string = object4.installId()) == null || string.length() <= 0 || hashMap.containsKey(string)) continue;
                hashMap.put(string, object4);
            }
            object = new HashSet();
            SparseIntArray sparseIntArray = new SparseIntArray();
            object2 = new HashSet();
            for (String string : collection) {
                if (hashMap.containsKey(string)) {
                    object2.add(string);
                    continue;
                }
                if (string.replaceAll("[0-9]+", "").length() == 0) {
                    n = Integer.parseInt(string);
                    sparseIntArray.put(n, n);
                    continue;
                }
                if (((HashMap)object3).containsKey(string)) {
                    ((HashSet)object).add(((HashMap)object3).get(string));
                    continue;
                }
                this.mSdkLog.error(null, "Ignoring unknown package filter '%1$s'", new Object[]{string});
            }
            object3 = null;
            Object var6_7 = null;
            int n2 = 1;
            Iterator<ArchiveInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                Package package_;
                n = 0;
                ArchiveInfo archiveInfo = iterator.next();
                Archive archive = archiveInfo.getNewArchive();
                if (archive != null && (package_ = archive.getParentPackage()) != null) {
                    if (object2.contains(package_.installId()) || ((HashSet)object).contains(package_.getClass()) || sparseIntArray.get(n2) > 0) {
                        n = 1;
                    }
                    ++n2;
                }
                if (n != 0) continue;
                iterator.remove();
            }
            if (list.size() == 0) {
                this.mSdkLog.printf(LineUtil.reflowLine((String)"Warning: The package filter removed all packages. There is nothing to install.\nPlease consider trying to update again without a package filter.\n"), new Object[0]);
                return null;
            }
        }
        if (list != null && list.size() > 0) {
            if (!bl2) return this.installArchives(list, 0);
            this.mSdkLog.printf("Packages selected for install:\n", new Object[0]);
            for (ArchiveInfo archiveInfo : list) {
                Package package_;
                object = archiveInfo.getNewArchive();
                if (object == null || (package_ = object.getParentPackage()) == null) continue;
                this.mSdkLog.printf("- %1$s\n", new Object[]{package_.getShortDescription()});
            }
            this.mSdkLog.printf("\nDry mode is on so nothing is actually being installed.\n", new Object[0]);
            return null;
        } else {
            this.mSdkLog.printf("There is nothing to install or update.\n", new Object[0]);
        }
        return null;
    }

    private void mapFilterToPackageClass(HashMap<String, Class<? extends Package>> hashMap, String[] stringArray) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = Package.class.getPackage().getName();
        block2: for (String string2 : stringArray) {
            String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            int n = string3.indexOf(45);
            if (n > 0) {
                string3 = string3.replaceFirst("-", "");
            }
            for (int i = 0; i < 2; ++i) {
                String string4 = string + '.' + string3 + "Package";
                try {
                    Class<?> clazz = classLoader.loadClass(string4);
                    if (clazz != null) {
                        hashMap.put(string2, clazz);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (i != 0 || n <= 0) continue block2;
                string3 = string3.substring(0, n) + string3.substring(n, n + 1).toUpperCase() + string3.substring(n + 1);
            }
        }
    }

    public void refreshSources(final boolean bl) {
        assert (this.mTaskFactory != null);
        final boolean bl2 = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Refresh Sources", new ITask(){

            public void run(ITaskMonitor iTaskMonitor) {
                if (UpdaterData.this.mStateFetchRemoteAddonsList <= 0) {
                    UpdaterData.this.loadRemoteAddonsListInTask(iTaskMonitor);
                }
                SdkSource[] sdkSourceArray = UpdaterData.this.mSources.getAllSources();
                iTaskMonitor.setDescription("Refresh Sources", new Object[0]);
                iTaskMonitor.setProgressMax(iTaskMonitor.getProgress() + sdkSourceArray.length);
                for (SdkSource sdkSource : sdkSourceArray) {
                    if (bl || sdkSource.getPackages() != null || sdkSource.getFetchError() != null) {
                        sdkSource.load(iTaskMonitor.createSubMonitor(1), bl2);
                    }
                    iTaskMonitor.incProgress(1);
                }
            }
        });
    }

    public void loadRemoteAddonsList(ITaskMonitor iTaskMonitor) {
        if (this.mStateFetchRemoteAddonsList != 0) {
            return;
        }
        this.mTaskFactory.start("Load Add-ons List", iTaskMonitor, new ITask(){

            public void run(ITaskMonitor iTaskMonitor) {
                UpdaterData.this.loadRemoteAddonsListInTask(iTaskMonitor);
            }
        });
    }

    private void loadRemoteAddonsListInTask(ITaskMonitor iTaskMonitor) {
        this.mStateFetchRemoteAddonsList = -1;
        String string = "https://dl-ssl.google.com/android/repository/addons_list-1.xml";
        String string2 = System.getenv("SDK_TEST_BASE_URL");
        if (string2 != null) {
            if (string2.length() > 0 && string2.endsWith("/")) {
                if (string.startsWith("https://dl-ssl.google.com/android/repository/")) {
                    string = string2 + string.substring("https://dl-ssl.google.com/android/repository/".length());
                }
            } else {
                iTaskMonitor.logError("Ignoring invalid SDK_TEST_BASE_URL: %1$s", new Object[]{string2});
            }
        }
        if (this.getSettingsController().getForceHttp()) {
            string = string.replaceAll("https://", "http://");
        }
        boolean bl = System.getenv("SDK_SKIP_3RD_PARTIES") == null;
        AddonsListFetcher addonsListFetcher = new AddonsListFetcher();
        AddonsListFetcher.Site[] siteArray = addonsListFetcher.fetch(iTaskMonitor, string);
        if (siteArray != null) {
            this.mSources.removeAll(SdkSourceCategory.ADDONS_3RD_PARTY);
            if (bl) {
                for (AddonsListFetcher.Site site : siteArray) {
                    this.mSources.add(SdkSourceCategory.ADDONS_3RD_PARTY, (SdkSource)new SdkAddonSource(site.getUrl(), site.getUiName()));
                }
            }
            this.mStateFetchRemoteAddonsList = 1;
        }
        iTaskMonitor.setDescription("Fetched Add-ons List successfully", new Object[0]);
    }

    public void broadcastOnSdkLoaded() {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (ISdkChangeListener iSdkChangeListener : UpdaterData.this.mListeners) {
                        try {
                            iSdkChangeListener.onSdkLoaded();
                        }
                        catch (Throwable throwable) {
                            UpdaterData.this.mSdkLog.error(throwable, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastOnSdkReload() {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (ISdkChangeListener iSdkChangeListener : UpdaterData.this.mListeners) {
                        try {
                            iSdkChangeListener.onSdkReload();
                        }
                        catch (Throwable throwable) {
                            UpdaterData.this.mSdkLog.error(throwable, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPreInstallHook() {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (ISdkChangeListener iSdkChangeListener : UpdaterData.this.mListeners) {
                        try {
                            iSdkChangeListener.preInstallHook();
                        }
                        catch (Throwable throwable) {
                            UpdaterData.this.mSdkLog.error(throwable, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPostInstallHook() {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (ISdkChangeListener iSdkChangeListener : UpdaterData.this.mListeners) {
                        try {
                            iSdkChangeListener.postInstallHook();
                        }
                        catch (Throwable throwable) {
                            UpdaterData.this.mSdkLog.error(throwable, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    protected ArchiveInstaller createArchiveInstaler() {
        return new ArchiveInstaller();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallOrderComparator
    implements Comparator<ArchiveInfo> {
        private final Map<ArchiveInfo, Integer> mOrders = new HashMap<ArchiveInfo, Integer>();

        private InstallOrderComparator() {
        }

        @Override
        public int compare(ArchiveInfo archiveInfo, ArchiveInfo archiveInfo2) {
            int n = this.getDependencyOrder(archiveInfo);
            int n2 = this.getDependencyOrder(archiveInfo2);
            return n - n2;
        }

        private int getDependencyOrder(ArchiveInfo archiveInfo) {
            if (archiveInfo == null) {
                return 0;
            }
            Integer n = this.mOrders.get(archiveInfo);
            if (n != null) {
                return n;
            }
            ArchiveInfo[] archiveInfoArray = archiveInfo.getDependsOn();
            if (archiveInfoArray == null) {
                return 0;
            }
            int n2 = archiveInfoArray.length;
            for (ArchiveInfo archiveInfo2 : archiveInfoArray) {
                n2 += this.getDependencyOrder(archiveInfo2);
            }
            this.mOrders.put(archiveInfo, n2);
            return n2;
        }
    }
}

