/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman1;

import com.android.prefs.AndroidLocation;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.UpdaterPage;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import com.android.sdkuilib.repository.ISdkChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AvdManagerPage
extends UpdaterPage
implements ISdkChangeListener {
    private AvdSelector mAvdSelector;
    private final UpdaterData mUpdaterData;

    public AvdManagerPage(Composite composite, int n, UpdaterData updaterData) {
        super(composite, n);
        this.mUpdaterData = updaterData;
        this.mUpdaterData.addListeners(this);
        this.createContents(this);
        this.postCreate();
    }

    private void createContents(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        try {
            if (this.mUpdaterData != null && this.mUpdaterData.getAvdManager() != null) {
                label.setText(String.format("List of existing Android Virtual Devices located at %s", this.mUpdaterData.getAvdManager().getBaseAvdFolder()));
            } else {
                label.setText("Error: cannot find the AVD folder location.\r\n Please set the 'ANDROID_SDK_HOME' env variable.");
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            label.setText(androidLocationException.getMessage());
        }
        this.mAvdSelector = new AvdSelector(composite, this.mUpdaterData.getOsSdkRoot(), this.mUpdaterData.getAvdManager(), AvdSelector.DisplayMode.MANAGER, this.mUpdaterData.getSdkLog());
        this.mAvdSelector.setSettingsController(this.mUpdaterData.getSettingsController());
    }

    public void dispose() {
        this.mUpdaterData.removeListener(this);
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
    }

    public void onSdkLoaded() {
        this.onSdkReload();
    }

    public void onSdkReload() {
        this.mAvdSelector.refresh(false);
    }

    public void preInstallHook() {
    }

    public void postInstallHook() {
    }
}

