/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman2;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.SdkAddonSource;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import com.android.sdklib.internal.repository.SdkSources;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.SwtBaseDialog;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AddonSitesDialog
extends SwtBaseDialog {
    private final UpdaterData mUpdaterData;
    private Table mTable;
    private TableViewer mTableViewer;
    private Button mButtonNew;
    private Button mButtonDelete;
    private Button mButtonClose;
    private Label mlabel;
    private Button mButtonEdit;
    private TableColumn mColumnUrl;

    public AddonSitesDialog(Shell shell, UpdaterData updaterData) {
        super(shell, 65536, "Add-on Sites");
        this.mUpdaterData = updaterData;
    }

    protected void createContents() {
        Shell shell = this.getShell();
        shell.setMinimumSize(new Point(450, 300));
        shell.setSize(450, 300);
        this.setWindowImage(shell);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        shell.setLayout((Layout)gridLayout);
        this.mlabel = new Label((Composite)shell, 0);
        this.mlabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mlabel.setText("This dialog lets you manage the URLs of external add-on sites to be used.\n\nAdd-on sites can provide new add-ons or \"user\" packages.\nThey cannot provide standard Android platforms, docs or samples packages.\nAdding a URL here will not allow you to clone an official Android repository.");
        this.mTableViewer = new TableViewer((Composite)shell, 67584);
        this.mTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AddonSitesDialog.this.on_TableViewer_selectionChanged(selectionChangedEvent);
            }
        });
        this.mTable = this.mTableViewer.getTable();
        this.mTable.setLinesVisible(false);
        this.mTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                AddonSitesDialog.this.on_Table_mouseUp(mouseEvent);
            }
        });
        this.mTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.mTableViewer, 0);
        this.mColumnUrl = tableViewerColumn.getColumn();
        this.mColumnUrl.setWidth(100);
        this.mColumnUrl.setText("New Column");
        this.mButtonNew = new Button((Composite)shell, 0);
        this.mButtonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddonSitesDialog.this.newOrEdit(false);
            }
        });
        this.mButtonNew.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mButtonNew.setText("New...");
        this.mButtonEdit = new Button((Composite)shell, 0);
        this.mButtonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddonSitesDialog.this.newOrEdit(true);
            }
        });
        this.mButtonEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mButtonEdit.setText("Edit...");
        this.mButtonDelete = new Button((Composite)shell, 0);
        this.mButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddonSitesDialog.this.on_ButtonDelete_widgetSelected(selectionEvent);
            }
        });
        this.mButtonDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mButtonDelete.setText("Delete...");
        new Label((Composite)shell, 0);
        this.mButtonClose = new Button((Composite)shell, 0);
        this.mButtonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddonSitesDialog.this.on_ButtonClose_widgetSelected(selectionEvent);
            }
        });
        this.mButtonClose.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        this.mButtonClose.setText("Close");
        this.adjustColumnsWidth(this.mTable, this.mColumnUrl);
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imageFactory;
        String string = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            string = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imageFactory = this.mUpdaterData.getImageFactory()) != null) {
            shell.setImage(imageFactory.getImageByName(string));
        }
    }

    private void adjustColumnsWidth(final Table table, final TableColumn tableColumn) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = table.getClientArea();
                tableColumn.setWidth(rectangle.width * 100 / 100);
            }
        });
    }

    private void newOrEdit(final boolean bl) {
        String string;
        String string2;
        SdkSources sdkSources = this.mUpdaterData.getSources();
        final SdkSource[] sdkSourceArray = sdkSources.getAllSources();
        String string3 = bl ? "Edit Add-on Site URL" : "Add Add-on Site URL";
        String string4 = "Please enter the URL of the addon.xml:";
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mTableViewer.getSelection();
        String string5 = string2 = !bl || iStructuredSelection.isEmpty() ? null : iStructuredSelection.getFirstElement().toString();
        if (bl && string2 == null) {
            return;
        }
        InputDialog inputDialog = new InputDialog(this.getShell(), string3, string4, string2, new IInputValidator(){

            public String isValid(String string) {
                String string22 = string = string == null ? null : string.trim();
                if (string == null || string.length() == 0) {
                    return "Error: URL field is empty. Please enter a URL.";
                }
                if (!(string.startsWith("file://") || string.startsWith("ftp://") || string.startsWith("http://") || string.startsWith("https://"))) {
                    return "Error: The URL must start by one of file://, ftp://, http:// or https://";
                }
                if (bl && string.equals(string2)) {
                    return null;
                }
                for (SdkSource sdkSource : sdkSourceArray) {
                    if (!string.equalsIgnoreCase(sdkSource.getUrl())) continue;
                    return "Error: This site is already listed.";
                }
                return null;
            }
        });
        if (inputDialog.open() == 0 && !(string = inputDialog.getValue().trim()).equals(string2)) {
            if (bl && string2 != null) {
                for (SdkAddonSource sdkAddonSource : sdkSources.getSources(SdkSourceCategory.USER_ADDONS)) {
                    if (!string2.equals(sdkAddonSource.getUrl())) continue;
                    sdkSources.remove((SdkSource)sdkAddonSource);
                    break;
                }
            }
            SdkAddonSource sdkAddonSource = new SdkAddonSource(string, null);
            sdkSources.add(SdkSourceCategory.USER_ADDONS, (SdkSource)sdkAddonSource);
            this.setReturnValue(true);
            this.loadList();
            StructuredSelection structuredSelection = new StructuredSelection((Object)sdkAddonSource);
            this.mTableViewer.setSelection((ISelection)structuredSelection, true);
        }
    }

    private void on_ButtonDelete_widgetSelected(SelectionEvent selectionEvent) {
        String string;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mTableViewer.getSelection();
        String string2 = string = iStructuredSelection.isEmpty() ? null : iStructuredSelection.getFirstElement().toString();
        if (string == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.getShell(), 65732);
        messageBox.setText("Delete add-on site");
        messageBox.setMessage(String.format("Do you want to delete the URL %1$s?", string));
        if (messageBox.open() == 64) {
            SdkSources sdkSources = this.mUpdaterData.getSources();
            for (SdkSource sdkSource : sdkSources.getSources(SdkSourceCategory.USER_ADDONS)) {
                if (!string.equals(sdkSource.getUrl())) continue;
                sdkSources.remove(sdkSource);
                this.setReturnValue(true);
                this.loadList();
            }
        }
    }

    private void on_ButtonClose_widgetSelected(SelectionEvent selectionEvent) {
        this.close();
    }

    private void on_Table_mouseUp(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        if (this.mTable.getItem(point) == null) {
            this.mTable.deselectAll();
            this.on_TableViewer_selectionChanged(null);
        }
    }

    private void on_TableViewer_selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = this.mTableViewer.getSelection();
        this.mButtonDelete.setEnabled(!iSelection.isEmpty());
        this.mButtonEdit.setEnabled(!iSelection.isEmpty());
    }

    protected void postCreate() {
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mTableViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        this.loadList();
    }

    private void loadList() {
        if (this.mUpdaterData != null) {
            Object[] objectArray = this.mUpdaterData.getSources().getSources(SdkSourceCategory.USER_ADDONS);
            Arrays.sort(objectArray);
            ISelection iSelection = this.mTableViewer.getSelection();
            this.mTableViewer.setInput((Object)objectArray);
            this.mTableViewer.refresh();
            this.on_TableViewer_selectionChanged(null);
            if (iSelection != null && !iSelection.isEmpty()) {
                this.mTableViewer.setSelection(iSelection, true);
            }
        }
    }

    private static class SourcesContentProvider
    implements IStructuredContentProvider {
        private SourcesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            if (object instanceof SdkSource[]) {
                return (Object[])object;
            }
            return new Object[0];
        }
    }
}

