/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman2;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.sdkman2.PackageLoader;
import com.android.sdkuilib.internal.repository.sdkman2.SdkLogAdapter;
import com.android.sdkuilib.internal.tasks.ProgressView;
import com.android.sdkuilib.internal.tasks.ProgressViewFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import com.android.util.Pair;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdtUpdateDialog
extends SwtBaseDialog {
    public static final int USE_MAX_REMOTE_API_LEVEL = 0;
    private static final String APP_NAME = "Android SDK Manager";
    private final UpdaterData mUpdaterData;
    private Boolean mResultCode = Boolean.FALSE;
    private Map<Package, File> mResultPaths = null;
    private SettingsController mSettingsController;
    private PackageFilter mPackageFilter;
    private PackageLoader mPackageMananger;
    private ProgressBar mProgressBar;
    private Label mStatusText;

    public AdtUpdateDialog(Shell shell, ISdkLog iSdkLog, String string) {
        super(shell, 0, APP_NAME);
        this.mUpdaterData = new UpdaterData(string, iSdkLog);
    }

    public Pair<Boolean, File> installExtraPackage(String string, String string2) {
        this.mPackageFilter = AdtUpdateDialog.createExtraFilter(string, string2);
        this.open();
        File file = null;
        if (this.mResultPaths != null) {
            for (Map.Entry<Package, File> entry : this.mResultPaths.entrySet()) {
                if (!(entry.getKey() instanceof ExtraPackage)) continue;
                file = entry.getValue();
                break;
            }
        }
        return Pair.of((Object)this.mResultCode, file);
    }

    public Pair<Boolean, File> installPlatformPackage(int n) {
        this.mPackageFilter = AdtUpdateDialog.createPlatformFilter(n);
        this.open();
        File file = null;
        if (this.mResultPaths != null) {
            for (Map.Entry<Package, File> entry : this.mResultPaths.entrySet()) {
                if (!(entry.getKey() instanceof PlatformPackage)) continue;
                file = entry.getValue();
                break;
            }
        }
        return Pair.of((Object)this.mResultCode, file);
    }

    public boolean installNewSdk(Set<Integer> set) {
        this.mPackageFilter = AdtUpdateDialog.createNewSdkFilter(set);
        this.open();
        return this.mResultCode;
    }

    @Override
    protected void createContents() {
        Shell shell = this.getShell();
        shell.setMinimumSize(new Point(450, 100));
        shell.setSize(450, 100);
        this.mUpdaterData.setWindowShell(shell);
        GridLayoutBuilder.create((Composite)shell).columns(1);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataBuilder.create((Control)composite).fill().grab();
        this.mProgressBar = new ProgressBar(composite, 0);
        GridDataBuilder.create((Control)this.mProgressBar).hFill().hGrab();
        this.mStatusText = new Label(composite, 0);
        this.mStatusText.setText("Status Placeholder");
        GridDataBuilder.create((Control)this.mStatusText).hFill().hGrab();
    }

    @Override
    protected void postCreate() {
        ProgressViewFactory progressViewFactory = new ProgressViewFactory();
        progressViewFactory.setProgressView(new ProgressView(this.mStatusText, this.mProgressBar, null, new SdkLogAdapter(this.mUpdaterData.getSdkLog())));
        this.mUpdaterData.setTaskFactory(progressViewFactory);
        this.setupSources();
        this.initializeSettings();
        if (this.mUpdaterData.checkIfInitFailed()) {
            this.close();
            return;
        }
        this.mUpdaterData.broadcastOnSdkLoaded();
        this.mPackageMananger = new PackageLoader(this.mUpdaterData);
    }

    @Override
    protected void eventLoop() {
        this.mPackageMananger.loadPackagesWithInstallTask(this.mPackageFilter.installFlags(), new PackageLoader.IAutoInstallTask(){

            @Override
            public Package[] filterLoadedSource(SdkSource sdkSource, Package[] packageArray) {
                for (Package package_ : packageArray) {
                    AdtUpdateDialog.this.mPackageFilter.visit(package_);
                }
                return packageArray;
            }

            @Override
            public boolean acceptPackage(Package package_) {
                return AdtUpdateDialog.this.mPackageFilter.accept(package_);
            }

            @Override
            public void setResult(boolean bl, Map<Package, File> map) {
                AdtUpdateDialog.this.mResultCode = bl;
                AdtUpdateDialog.this.mResultPaths = map;
            }

            @Override
            public void taskCompleted() {
                AdtUpdateDialog.this.close();
            }
        });
        super.eventLoop();
    }

    private void setupSources() {
        this.mUpdaterData.setupDefaultSources();
    }

    private void initializeSettings() {
        this.mSettingsController = this.mUpdaterData.getSettingsController();
        this.mSettingsController.loadSettings();
        this.mSettingsController.applySettings();
    }

    public static PackageFilter createExtraFilter(final String string, final String string2) {
        return new PackageFilter(){
            String mVendor;
            String mPath;
            {
                this.mVendor = string;
                this.mPath = string2;
            }

            boolean accept(Package package_) {
                ExtraPackage extraPackage;
                if (package_ instanceof ExtraPackage && (extraPackage = (ExtraPackage)package_).getVendorId().equals(this.mVendor)) {
                    if (extraPackage.getPath().equals(this.mPath)) {
                        return true;
                    }
                    for (String string3 : extraPackage.getOldPaths()) {
                        if (!string3.equals(this.mPath)) continue;
                        return true;
                    }
                }
                return false;
            }

            void visit(Package package_) {
            }

            int installFlags() {
                return 1;
            }
        };
    }

    public static PackageFilter createPlatformFilter(final int n) {
        return new PackageFilter(){
            int mApiLevel;
            boolean mFindMaxApi;
            {
                this.mApiLevel = n;
                this.mFindMaxApi = n == 0;
            }

            boolean accept(Package package_) {
                if (package_ instanceof PlatformPackage) {
                    PlatformPackage platformPackage = (PlatformPackage)package_;
                    AndroidVersion androidVersion = platformPackage.getVersion();
                    return !androidVersion.isPreview() && androidVersion.getApiLevel() == this.mApiLevel;
                }
                return false;
            }

            void visit(Package package_) {
                int n2;
                PlatformPackage platformPackage;
                AndroidVersion androidVersion;
                if (this.mFindMaxApi && package_ instanceof PlatformPackage && !package_.isLocal() && !(androidVersion = (platformPackage = (PlatformPackage)package_).getVersion()).isPreview() && (n2 = androidVersion.getApiLevel()) > this.mApiLevel) {
                    this.mApiLevel = n2;
                }
            }

            int installFlags() {
                return 1;
            }
        };
    }

    public static PackageFilter createNewSdkFilter(final Set<Integer> set) {
        return new PackageFilter(){
            int mMaxApiLevel;
            boolean mFindMaxApi;
            boolean mNeedTools;
            boolean mNeedPlatformTools;
            {
                this.mFindMaxApi = set.contains(0);
                this.mNeedTools = true;
                this.mNeedPlatformTools = true;
            }

            boolean accept(Package package_) {
                if (!package_.isLocal()) {
                    if (package_ instanceof PlatformPackage) {
                        PlatformPackage platformPackage = (PlatformPackage)package_;
                        AndroidVersion androidVersion = platformPackage.getVersion();
                        if (!androidVersion.isPreview()) {
                            int n = androidVersion.getApiLevel();
                            if (this.mFindMaxApi && n == this.mMaxApiLevel || n > 0 && set.contains(n)) {
                                return true;
                            }
                        }
                    } else {
                        if (this.mNeedTools && package_ instanceof ToolPackage) {
                            this.mNeedTools = false;
                            return true;
                        }
                        if (this.mNeedPlatformTools && package_ instanceof PlatformToolPackage) {
                            this.mNeedPlatformTools = false;
                            return true;
                        }
                    }
                }
                return false;
            }

            void visit(Package package_) {
                int n;
                PlatformPackage platformPackage;
                AndroidVersion androidVersion;
                if (this.mFindMaxApi && package_ instanceof PlatformPackage && !package_.isLocal() && !(androidVersion = (platformPackage = (PlatformPackage)package_).getVersion()).isPreview() && (n = androidVersion.getApiLevel()) > this.mMaxApiLevel) {
                    this.mMaxApiLevel = n;
                }
            }

            int installFlags() {
                return 0;
            }
        };
    }

    private static abstract class PackageFilter {
        private PackageFilter() {
        }

        abstract int installFlags();

        abstract void visit(Package var1);

        abstract boolean accept(Package var1);
    }
}

