/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman2;

import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdkuilib.internal.repository.ISettingsPage;
import com.android.sdkuilib.internal.repository.MenuBarWrapper;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.UpdaterPage;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.sdkman1.AvdManagerPage;
import com.android.sdkuilib.internal.repository.sdkman2.SdkUpdaterWindowImpl2;
import com.android.sdkuilib.internal.repository.sdkman2.ShellSizeAndPos;
import com.android.sdkuilib.repository.AvdManagerWindow;
import com.android.sdkuilib.repository.ISdkChangeListener;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import com.android.util.Pair;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvdManagerWindowImpl1 {
    private static final String APP_NAME = "Android Virtual Device Manager";
    private static final String APP_NAME_MAC_MENU = "AVD Manager";
    private static final String SIZE_POS_PREFIX = "avdman1";
    private final Shell mParentShell;
    private final AvdManagerWindow.AvdInvocationContext mContext;
    private final UpdaterData mUpdaterData;
    private ArrayList<Pair<Class<? extends UpdaterPage>, UpdaterPage.Purpose>> mExtraPages;
    private boolean mRequestAutoUpdate;
    protected Shell mShell;
    private AvdManagerPage mAvdPage;
    private SettingsController mSettingsController;

    public AvdManagerWindowImpl1(Shell shell, ISdkLog iSdkLog, String string, AvdManagerWindow.AvdInvocationContext avdInvocationContext) {
        this.mParentShell = shell;
        this.mContext = avdInvocationContext;
        this.mUpdaterData = new UpdaterData(string, iSdkLog);
    }

    public AvdManagerWindowImpl1(Shell shell, UpdaterData updaterData, AvdManagerWindow.AvdInvocationContext avdInvocationContext) {
        this.mParentShell = shell;
        this.mContext = avdInvocationContext;
        this.mUpdaterData = updaterData;
    }

    public void open() {
        if (this.mParentShell == null) {
            Display.setAppName((String)APP_NAME);
        }
        this.createShell();
        this.preCreateContent();
        this.createContents();
        this.createMenuBar();
        this.mShell.open();
        this.mShell.layout();
        boolean bl = this.postCreateContent();
        if (bl && this.mContext == AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            Display display = Display.getDefault();
            while (!this.mShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.dispose();
        }
    }

    private void createShell() {
        int n = 1264;
        if (this.mContext != AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            n |= 0x10000;
        }
        this.mShell = new Shell(this.mParentShell, n);
        this.mShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ShellSizeAndPos.saveSizeAndPos(AvdManagerWindowImpl1.this.mShell, AvdManagerWindowImpl1.SIZE_POS_PREFIX);
                if (AvdManagerWindowImpl1.this.mContext != AvdManagerWindow.AvdInvocationContext.SDK_MANAGER) {
                    AvdManagerWindowImpl1.this.onAndroidSdkUpdaterDispose();
                }
            }
        });
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mShell.setLayout((Layout)gridLayout);
        this.mShell.setMinimumSize(new Point(500, 300));
        this.mShell.setSize(700, 500);
        this.mShell.setText(APP_NAME);
        ShellSizeAndPos.loadSizeAndPos(this.mShell, SIZE_POS_PREFIX);
    }

    private void createContents() {
        this.mAvdPage = new AvdManagerPage((Composite)this.mShell, 0, this.mUpdaterData);
        this.mAvdPage.setLayoutData(new GridData(4, 4, true, true, 2, 1));
    }

    private void createMenuBar() {
        if (this.mContext != AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            return;
        }
        Menu menu = new Menu((Decorations)this.mShell, 2);
        this.mShell.setMenuBar(menu);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Tools");
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 0);
        menuItem2.setText("Manage SDK...");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AvdManagerWindowImpl1.this.onSdkManager();
            }
        });
        if (this.mContext != AvdManagerWindow.AvdInvocationContext.IDE) {
            try {
                new MenuBarWrapper(APP_NAME_MAC_MENU, menu2){

                    public void onPreferencesMenuSelected() {
                        AvdManagerWindowImpl1.this.showRegisteredPage(UpdaterPage.Purpose.SETTINGS);
                    }

                    public void onAboutMenuSelected() {
                        AvdManagerWindowImpl1.this.showRegisteredPage(UpdaterPage.Purpose.ABOUT_BOX);
                    }

                    public void printError(String string, Object ... objectArray) {
                        if (AvdManagerWindowImpl1.this.mUpdaterData != null) {
                            AvdManagerWindowImpl1.this.mUpdaterData.getSdkLog().error(null, string, objectArray);
                        }
                    }
                };
            }
            catch (Exception exception) {
                this.mUpdaterData.getSdkLog().error((Throwable)exception, "Failed to setup menu bar", new Object[0]);
                exception.printStackTrace();
            }
        }
    }

    public void registerPage(Class<? extends UpdaterPage> clazz, UpdaterPage.Purpose purpose) {
        if (this.mExtraPages == null) {
            this.mExtraPages = new ArrayList();
        }
        Pair pair = Pair.of(clazz, (Object)((Object)purpose));
        this.mExtraPages.add((Pair<Class<? extends UpdaterPage>, UpdaterPage.Purpose>)pair);
    }

    public void setInitialPage(Class<? extends Composite> clazz) {
    }

    public void setRequestAutoUpdate(boolean bl) {
        this.mRequestAutoUpdate = bl;
    }

    public void addListener(ISdkChangeListener iSdkChangeListener) {
        this.mUpdaterData.addListeners(iSdkChangeListener);
    }

    public void removeListener(ISdkChangeListener iSdkChangeListener) {
        this.mUpdaterData.removeListener(iSdkChangeListener);
    }

    private void preCreateContent() {
        this.mUpdaterData.setWindowShell(this.mShell);
        this.mUpdaterData.setImageFactory(new ImageFactory(this.mShell.getDisplay()));
    }

    private boolean postCreateContent() {
        this.setWindowImage(this.mShell);
        this.setupSources();
        this.initializeSettings();
        if (this.mUpdaterData.checkIfInitFailed()) {
            return false;
        }
        this.mUpdaterData.broadcastOnSdkLoaded();
        if (this.mRequestAutoUpdate) {
            this.mUpdaterData.updateOrInstallAll_WithGUI(null, false, this.mContext == AvdManagerWindow.AvdInvocationContext.IDE ? 1 : 2);
        }
        return true;
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imageFactory;
        String string = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            string = "android_icon_128.png";
        }
        if (this.mUpdaterData != null && (imageFactory = this.mUpdaterData.getImageFactory()) != null) {
            shell.setImage(imageFactory.getImageByName(string));
        }
    }

    private void dispose() {
        this.mUpdaterData.getSources().saveUserAddons(this.mUpdaterData.getSdkLog());
    }

    private void onAndroidSdkUpdaterDispose() {
        ImageFactory imageFactory;
        if (this.mUpdaterData != null && (imageFactory = this.mUpdaterData.getImageFactory()) != null) {
            imageFactory.dispose();
        }
    }

    private void setupSources() {
        this.mUpdaterData.setupDefaultSources();
    }

    private void initializeSettings() {
        this.mSettingsController = this.mUpdaterData.getSettingsController();
        this.mSettingsController.loadSettings();
        this.mSettingsController.applySettings();
    }

    private void showRegisteredPage(UpdaterPage.Purpose purpose) {
        if (this.mExtraPages == null) {
            return;
        }
        Class clazz = null;
        for (Pair<Class<? extends UpdaterPage>, UpdaterPage.Purpose> pair : this.mExtraPages) {
            if (pair.getSecond() != purpose) continue;
            clazz = (Class)pair.getFirst();
            break;
        }
        if (clazz != null) {
            PageDialog pageDialog = new PageDialog(this.mShell, clazz, purpose == UpdaterPage.Purpose.SETTINGS);
            pageDialog.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSdkManager() {
        ITaskFactory iTaskFactory = this.mUpdaterData.getTaskFactory();
        try {
            SdkUpdaterWindowImpl2 sdkUpdaterWindowImpl2 = new SdkUpdaterWindowImpl2(this.mShell, this.mUpdaterData, SdkUpdaterWindow.SdkInvocationContext.AVD_MANAGER);
            for (Pair<Class<? extends UpdaterPage>, UpdaterPage.Purpose> pair : this.mExtraPages) {
                sdkUpdaterWindowImpl2.registerPage((Class)pair.getFirst(), (UpdaterPage.Purpose)((Object)pair.getSecond()));
            }
            sdkUpdaterWindowImpl2.open();
        }
        catch (Exception exception) {
            this.mUpdaterData.getSdkLog().error((Throwable)exception, "SDK Manager window error", new Object[0]);
        }
        finally {
            this.mUpdaterData.setTaskFactory(iTaskFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PageDialog
    extends SwtBaseDialog {
        private final Class<? extends UpdaterPage> mPageClass;
        private final boolean mIsSettingsPage;

        protected PageDialog(Shell shell, Class<? extends UpdaterPage> clazz, boolean bl) {
            super(shell, 65536, null);
            this.mPageClass = clazz;
            this.mIsSettingsPage = bl;
        }

        @Override
        protected void createContents() {
            GridLayout gridLayout;
            Shell shell = this.getShell();
            AvdManagerWindowImpl1.this.setWindowImage(shell);
            GridLayoutBuilder.create((Composite)shell).columns(2);
            UpdaterPage updaterPage = UpdaterPage.newInstance(this.mPageClass, (Composite)shell, 0, AvdManagerWindowImpl1.this.mUpdaterData.getSdkLog());
            GridDataBuilder.create((Control)updaterPage).fill().grab().hSpan(2);
            if (updaterPage.getLayout() instanceof GridLayout) {
                gridLayout = (GridLayout)updaterPage.getLayout();
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
            }
            if (this.mIsSettingsPage && updaterPage instanceof ISettingsPage) {
                AvdManagerWindowImpl1.this.mSettingsController.setSettingsPage((ISettingsPage)((Object)updaterPage));
            }
            this.getShell().setText(String.format("%1$s - %2$s", AvdManagerWindowImpl1.APP_NAME, updaterPage.getPageTitle()));
            gridLayout = new Label((Composite)shell, 0);
            GridDataBuilder.create((Control)gridLayout).hFill().hGrab();
            Button button = new Button((Composite)shell, 8);
            button.setText("Close");
            GridDataBuilder.create((Control)button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PageDialog.this.close();
                }
            });
        }

        @Override
        protected void postCreate() {
        }

        @Override
        protected void close() {
            if (this.mIsSettingsPage) {
                AvdManagerWindowImpl1.this.mSettingsController.setSettingsPage(null);
            }
            super.close();
        }
    }
}

