/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman2;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SystemImagePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.util.SparseArray;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.sdkman2.PackageLoader;
import com.android.sdkuilib.internal.repository.sdkman2.PkgCategory;
import com.android.sdkuilib.internal.repository.sdkman2.PkgCategoryApi;
import com.android.sdkuilib.internal.repository.sdkman2.PkgCategorySource;
import com.android.sdkuilib.internal.repository.sdkman2.PkgItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackagesDiffLogic {
    private final PackageLoader mPackageLoader;
    private final UpdaterData mUpdaterData;
    private boolean mFirstLoadComplete = true;
    private final UpdateOpApi mOpApi = new UpdateOpApi();
    private final UpdateOpSource mOpSource = new UpdateOpSource();
    private static final PkgItem.PkgState[] PKG_STATES = new PkgItem.PkgState[]{PkgItem.PkgState.INSTALLED, PkgItem.PkgState.NEW};

    public PackagesDiffLogic(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
        this.mPackageLoader = new PackageLoader(updaterData);
    }

    public PackageLoader getPackageLoader() {
        return this.mPackageLoader;
    }

    public void clear() {
        this.mFirstLoadComplete = true;
        this.mOpApi.clear();
        this.mOpSource.clear();
    }

    public boolean isFirstLoadComplete() {
        boolean bl = this.mFirstLoadComplete;
        this.mFirstLoadComplete = false;
        return bl;
    }

    public void checkNewUpdateItems(boolean bl, boolean bl2, boolean bl3, int n) {
        Package package_;
        Object object;
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray();
        for (PkgItem object2 : this.getAllPkgItems(true, true)) {
            if (!object2.hasCompatibleArchive()) continue;
            int pkgItem = 0;
            object = object2.getMainPackage();
            if (object instanceof IPackageVersion) {
                pkgItem = ((IPackageVersion)object).getVersion().getApiLevel();
            }
            if (bl3 && pkgItem > 0) {
                n2 = Math.max(n2, pkgItem);
                if (object2.getState() == PkgItem.PkgState.INSTALLED) {
                    hashSet.add(pkgItem);
                }
                if ((package_ = (Package)sparseArray.get(pkgItem)) == null) {
                    package_ = new ArrayList();
                    sparseArray.put(pkgItem, package_);
                }
                package_.add(object2);
            }
            if ((!bl || object2.getState() != PkgItem.PkgState.NEW) && (!bl2 || !object2.hasUpdatePkg())) continue;
            object2.setChecked(true);
        }
        List list = (List)sparseArray.get(n2);
        if (bl3 && n2 > 0 && list != null) {
            if (!hashSet.contains(n2)) {
                Iterator bl4 = list.iterator();
                while (bl4.hasNext()) {
                    PkgItem pkgItem = (PkgItem)bl4.next();
                    if (pkgItem.getState() != PkgItem.PkgState.NEW && !pkgItem.hasUpdatePkg()) continue;
                    pkgItem.setChecked(true);
                }
            } else {
                boolean bl4;
                boolean bl5;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PkgItem pkgItem = (PkgItem)iterator.next();
                    object = pkgItem.getMainPackage();
                    if (!(object instanceof PlatformPackage) || pkgItem.getState() != PkgItem.PkgState.NEW) continue;
                    pkgItem.setChecked(true);
                    break;
                }
                boolean bl6 = false;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    object = (PkgItem)iterator2.next();
                    package_ = ((PkgItem)object).getMainPackage();
                    if (package_ instanceof PlatformPackage && ((PkgItem)object).getState() == PkgItem.PkgState.INSTALLED) {
                        boolean bl7;
                        if (((PkgItem)object).hasUpdatePkg() && ((PkgItem)object).isChecked()) {
                            package_ = ((PkgItem)object).getUpdatePkg();
                            if (package_ instanceof PlatformPackage) {
                                bl7 = ((PlatformPackage)package_).getIncludedAbi() != null;
                            }
                        } else {
                            boolean bl8 = bl7 = ((PlatformPackage)package_).getIncludedAbi() != null;
                        }
                        if (bl7) break;
                    }
                    if (!(package_ instanceof SystemImagePackage) || ((PkgItem)object).getState() != PkgItem.PkgState.INSTALLED) continue;
                    bl5 = true;
                    break;
                }
                if (!bl5) {
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        object = (PkgItem)iterator2.next();
                        package_ = ((PkgItem)object).getMainPackage();
                        if (!(package_ instanceof PlatformPackage)) continue;
                        if (((PkgItem)object).getState() == PkgItem.PkgState.NEW && ((PlatformPackage)package_).getIncludedAbi() != null) {
                            ((PkgItem)object).setChecked(true);
                            bl4 = true;
                            continue;
                        }
                        if (!((PkgItem)object).hasUpdatePkg() || !((package_ = ((PkgItem)object).getUpdatePkg()) instanceof PlatformPackage) || ((PlatformPackage)package_).getIncludedAbi() == null) continue;
                        ((PkgItem)object).setChecked(true);
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        object = (PkgItem)iterator2.next();
                        package_ = ((PkgItem)object).getMainPackage();
                        if (!(package_ instanceof SystemImagePackage) || ((PkgItem)object).getState() != PkgItem.PkgState.NEW) continue;
                        ((PkgItem)object).setChecked(true);
                    }
                }
            }
        }
        if (bl3 && n == 2) {
            for (PkgItem pkgItem : this.getAllPkgItems(true, true)) {
                object = pkgItem.getMainPackage();
                if (!(object instanceof ExtraPackage) || pkgItem.getState() != PkgItem.PkgState.NEW || !(package_ = (ExtraPackage)object).getVendorId().equals("google") || !package_.getPath().equals("usb_driver")) continue;
                pkgItem.setChecked(true);
            }
        }
    }

    public void uncheckAllItems() {
        for (PkgItem pkgItem : this.getAllPkgItems(true, true)) {
            pkgItem.setChecked(false);
        }
    }

    public List<PkgCategory> getCategories(boolean bl) {
        return bl ? this.mOpApi.getCategories() : this.mOpSource.getCategories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PkgItem> getAllPkgItems(boolean bl, boolean bl2) {
        List<PkgCategory> list;
        List<PkgCategory> list2;
        ArrayList<PkgItem> arrayList = new ArrayList<PkgItem>();
        if (bl) {
            list = list2 = this.getCategories(true);
            synchronized (list) {
                for (PkgCategory pkgCategory : list2) {
                    arrayList.addAll(pkgCategory.getItems());
                }
            }
        }
        if (bl2) {
            list = list2 = this.getCategories(false);
            synchronized (list) {
                for (PkgCategory pkgCategory : list2) {
                    arrayList.addAll(pkgCategory.getItems());
                }
            }
        }
        return arrayList;
    }

    public void updateStart() {
        this.mOpApi.updateStart();
        this.mOpSource.updateStart();
    }

    public boolean updateSourcePackages(boolean bl, SdkSource sdkSource, Package[] packageArray) {
        boolean bl2 = this.mOpApi.updateSourcePackages(sdkSource, packageArray);
        boolean bl3 = this.mOpSource.updateSourcePackages(sdkSource, packageArray);
        return bl ? bl2 : bl3;
    }

    public boolean updateEnd(boolean bl) {
        boolean bl2 = this.mOpApi.updateEnd();
        boolean bl3 = this.mOpSource.updateEnd();
        return bl ? bl2 : bl3;
    }

    private boolean processLocals(UpdateOp updateOp, Package[] packageArray) {
        boolean bl = false;
        List<PkgCategory> list = updateOp.getCategories();
        HashSet<PkgItem> hashSet = new HashSet<PkgItem>();
        block0: for (Package object : packageArray) {
            for (PkgCategory pkgCategory : list) {
                for (PkgItem pkgItem : pkgCategory.getItems()) {
                    if (pkgItem.getState() != PkgItem.PkgState.INSTALLED || !pkgItem.isSameMainPackageAs(object)) continue;
                    updateOp.keep(pkgItem);
                    updateOp.keep(pkgCategory);
                    hashSet.add(pkgItem);
                    continue block0;
                }
            }
            hashSet.add(this.addNewItem(updateOp, object, PkgItem.PkgState.INSTALLED));
            bl = true;
        }
        for (PkgCategory pkgCategory : list) {
            Iterator<PkgItem> iterator = pkgCategory.getItems().iterator();
            while (iterator.hasNext()) {
                PkgItem pkgItem = iterator.next();
                if (pkgItem.getState() != PkgItem.PkgState.INSTALLED || hashSet.contains(pkgItem)) continue;
                iterator.remove();
                bl = true;
            }
        }
        if (bl) {
            updateOp.postCategoryItemsChanged();
        }
        return bl;
    }

    private boolean processSource(UpdateOp updateOp, SdkSource sdkSource, Package[] packageArray) {
        boolean bl = false;
        List<PkgCategory> list = updateOp.getCategories();
        block4: for (Package package_ : packageArray) {
            for (PkgCategory pkgCategory : list) {
                for (PkgItem.PkgState pkgState : PKG_STATES) {
                    Iterator<PkgItem> iterator = pkgCategory.getItems().iterator();
                    while (iterator.hasNext()) {
                        Package package_2;
                        PkgItem pkgItem = iterator.next();
                        if (pkgItem.getState() != pkgState || !(package_2 = pkgItem.getMainPackage()).sameItemAs(package_)) continue;
                        if (pkgItem.isSameMainPackageAs(package_)) {
                            updateOp.keep(pkgItem);
                            updateOp.keep(pkgCategory);
                            continue block4;
                        }
                        if (pkgItem.hasUpdatePkg() && pkgItem.isSameUpdatePackageAs(package_)) {
                            updateOp.keep(pkgItem.getUpdatePkg());
                            updateOp.keep(pkgCategory);
                            continue block4;
                        }
                        switch (pkgItem.getState()) {
                            case NEW: {
                                if (package_.getRevision() < package_2.getRevision()) {
                                    if (updateOp.isKeep(pkgItem)) break;
                                    iterator.remove();
                                    this.addNewItem(updateOp, package_, PkgItem.PkgState.NEW);
                                    bl = true;
                                    break;
                                }
                                if (package_.getRevision() <= package_2.getRevision()) break;
                                iterator.remove();
                                this.addNewItem(updateOp, package_, PkgItem.PkgState.NEW);
                                bl = true;
                                break;
                            }
                            case INSTALLED: {
                                if (package_.getRevision() <= package_2.getRevision() || !pkgItem.mergeUpdate(package_)) break;
                                updateOp.keep(pkgItem.getUpdatePkg());
                                updateOp.keep(pkgCategory);
                                bl = true;
                            }
                        }
                        continue block4;
                    }
                }
            }
            this.addNewItem(updateOp, package_, PkgItem.PkgState.NEW);
            bl = true;
        }
        if (bl) {
            updateOp.postCategoryItemsChanged();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkgItem addNewItem(UpdateOp updateOp, Package package_, PkgItem.PkgState pkgState) {
        Object object;
        Object object2;
        List<PkgCategory> list = updateOp.getCategories();
        PkgCategory pkgCategory = this.findCurrentCategory(list, object2 = updateOp.getCategoryKey(package_));
        if (pkgCategory == null) {
            pkgCategory = updateOp.createCategory(object2);
            object = list;
            synchronized (object) {
                list.add(pkgCategory);
            }
            updateOp.sortCategoryList();
        } else {
            updateOp.adjustCategory(pkgCategory, object2);
        }
        object = new PkgItem(package_, pkgState);
        updateOp.keep((PkgItem)object);
        pkgCategory.getItems().add((PkgItem)object);
        updateOp.keep(pkgCategory);
        return object;
    }

    private PkgCategory findCurrentCategory(List<PkgCategory> list, Object object) {
        for (PkgCategory pkgCategory : list) {
            if (!pkgCategory.getKey().equals(object)) continue;
            return pkgCategory;
        }
        return null;
    }

    private class UpdateOpSource
    extends UpdateOp {
        private UpdateOpSource() {
        }

        public Object getCategoryKey(Package package_) {
            SdkSource sdkSource = package_.getParentSource();
            if (sdkSource == null) {
                return PkgCategorySource.UNKNOWN_SOURCE;
            }
            return sdkSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDefaultCategories() {
            List<PkgCategory> list = this.getCategories();
            for (PkgCategory object2 : list) {
                if (!object2.getKey().equals(PkgCategorySource.UNKNOWN_SOURCE)) continue;
                return;
            }
            PkgCategorySource pkgCategorySource = new PkgCategorySource(PkgCategorySource.UNKNOWN_SOURCE, PackagesDiffLogic.this.mUpdaterData);
            this.dontKeep(pkgCategorySource);
            List<PkgCategory> list2 = list;
            synchronized (list2) {
                list.add(pkgCategorySource);
            }
        }

        public PkgCategory createCategory(Object object) {
            assert (object instanceof SdkSource);
            PkgCategorySource pkgCategorySource = new PkgCategorySource((SdkSource)object, PackagesDiffLogic.this.mUpdaterData);
            return pkgCategorySource;
        }

        public void adjustCategory(PkgCategory pkgCategory, Object object) {
            assert (pkgCategory instanceof PkgCategorySource);
            assert (object instanceof SdkSource);
            if (pkgCategory instanceof PkgCategorySource) {
                ((PkgCategorySource)pkgCategory).adjustLabel((SdkSource)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sortCategoryList() {
            List<PkgCategory> list = this.getCategories();
            synchronized (list) {
                Collections.sort(this.getCategories(), new Comparator<PkgCategory>(){

                    @Override
                    public int compare(PkgCategory pkgCategory, PkgCategory pkgCategory2) {
                        SdkSource sdkSource;
                        assert (pkgCategory instanceof PkgCategorySource);
                        assert (pkgCategory2 instanceof PkgCategorySource);
                        SdkSource sdkSource2 = ((PkgCategorySource)pkgCategory).getSource();
                        if (sdkSource2 == (sdkSource = ((PkgCategorySource)pkgCategory2).getSource())) {
                            return 0;
                        }
                        if (sdkSource2 == PkgCategorySource.UNKNOWN_SOURCE) {
                            return -1;
                        }
                        if (sdkSource == PkgCategorySource.UNKNOWN_SOURCE) {
                            return 1;
                        }
                        assert (sdkSource2 != null);
                        assert (sdkSource != null);
                        return sdkSource2.toString().compareTo(sdkSource.toString());
                    }
                });
            }
        }

        public void postCategoryItemsChanged() {
            for (PkgCategory pkgCategory : this.getCategories()) {
                Collections.sort(pkgCategory.getItems());
            }
        }
    }

    private class UpdateOpApi
    extends UpdateOp {
        private UpdateOpApi() {
        }

        public Object getCategoryKey(Package package_) {
            if (package_ instanceof IPackageVersion) {
                return ((IPackageVersion)package_).getVersion();
            }
            if (package_ instanceof ToolPackage || package_ instanceof PlatformToolPackage) {
                return PkgCategoryApi.KEY_TOOLS;
            }
            return PkgCategoryApi.KEY_EXTRA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDefaultCategories() {
            Object object;
            boolean bl = true;
            boolean bl2 = true;
            List<PkgCategory> list = this.getCategories();
            for (PkgCategory object22 : list) {
                if (object22.getKey().equals(PkgCategoryApi.KEY_TOOLS)) {
                    this.keep(object22);
                    bl = false;
                    continue;
                }
                if (!object22.getKey().equals(PkgCategoryApi.KEY_EXTRA)) continue;
                this.keep(object22);
                bl2 = false;
            }
            if (bl) {
                object = new PkgCategoryApi(PkgCategoryApi.KEY_TOOLS, null, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_other_16.png"));
                List<PkgCategory> list2 = list;
                synchronized (list2) {
                    list.add((PkgCategory)object);
                }
            }
            if (bl2) {
                object = new PkgCategoryApi(PkgCategoryApi.KEY_EXTRA, null, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_other_16.png"));
                List<PkgCategory> list3 = list;
                synchronized (list3) {
                    list.add((PkgCategory)object);
                }
            }
        }

        public PkgCategory createCategory(Object object) {
            PkgCategoryApi pkgCategoryApi = null;
            assert (object instanceof AndroidVersion);
            AndroidVersion androidVersion = (AndroidVersion)object;
            assert (!androidVersion.equals((Object)PkgCategoryApi.KEY_TOOLS) && !androidVersion.equals((Object)PkgCategoryApi.KEY_EXTRA));
            String string = null;
            for (IAndroidTarget iAndroidTarget : PackagesDiffLogic.this.mUpdaterData.getSdkManager().getTargets()) {
                if (!iAndroidTarget.isPlatform() || !androidVersion.equals((Object)iAndroidTarget.getVersion())) continue;
                string = iAndroidTarget.getVersionName();
                break;
            }
            pkgCategoryApi = new PkgCategoryApi(androidVersion, string, (Object)PackagesDiffLogic.this.mUpdaterData.getImageFactory().getImageByName("pkgcat_16.png"));
            return pkgCategoryApi;
        }

        public void adjustCategory(PkgCategory pkgCategory, Object object) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sortCategoryList() {
            List<PkgCategory> list = this.getCategories();
            synchronized (list) {
                Collections.sort(this.getCategories(), new Comparator<PkgCategory>(){

                    @Override
                    public int compare(PkgCategory pkgCategory, PkgCategory pkgCategory2) {
                        assert (pkgCategory instanceof PkgCategoryApi);
                        assert (pkgCategory2 instanceof PkgCategoryApi);
                        assert (pkgCategory.getKey() instanceof AndroidVersion);
                        assert (pkgCategory2.getKey() instanceof AndroidVersion);
                        AndroidVersion androidVersion = (AndroidVersion)pkgCategory.getKey();
                        AndroidVersion androidVersion2 = (AndroidVersion)pkgCategory2.getKey();
                        return androidVersion2.compareTo(androidVersion);
                    }
                });
            }
        }

        public void postCategoryItemsChanged() {
            block0: for (PkgCategory pkgCategory : this.getCategories()) {
                Collections.sort(pkgCategory.getItems());
                assert (pkgCategory instanceof PkgCategoryApi);
                PkgCategoryApi pkgCategoryApi = (PkgCategoryApi)pkgCategory;
                if (pkgCategoryApi.getPlatformName() != null) continue;
                for (PkgItem pkgItem : pkgCategory.getItems()) {
                    String string;
                    Package package_ = pkgItem.getMainPackage();
                    if (!(package_ instanceof PlatformPackage) || (string = ((PlatformPackage)package_).getVersionName()) == null) continue;
                    pkgCategoryApi.setPlatformName(string);
                    continue block0;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class UpdateOp {
        private final Set<SdkSource> mVisitedSources = new HashSet<SdkSource>();
        private final List<PkgCategory> mCategories = new ArrayList<PkgCategory>();
        private final Set<PkgCategory> mCatsToRemove = new HashSet<PkgCategory>();
        private final Set<PkgItem> mItemsToRemove = new HashSet<PkgItem>();
        private final Map<Package, PkgItem> mUpdatesToRemove = new HashMap<Package, PkgItem>();

        UpdateOp() {
        }

        public void clear() {
            this.mVisitedSources.clear();
            this.mCategories.clear();
        }

        public List<PkgCategory> getCategories() {
            return this.mCategories;
        }

        public abstract Object getCategoryKey(Package var1);

        public abstract void addDefaultCategories();

        public abstract PkgCategory createCategory(Object var1);

        public abstract void adjustCategory(PkgCategory var1, Object var2);

        public abstract void sortCategoryList();

        public abstract void postCategoryItemsChanged();

        public void updateStart() {
            this.mVisitedSources.clear();
            this.mCatsToRemove.clear();
            this.mItemsToRemove.clear();
            this.mUpdatesToRemove.clear();
            for (PkgCategory pkgCategory : this.mCategories) {
                this.mCatsToRemove.add(pkgCategory);
                List<PkgItem> list = pkgCategory.getItems();
                this.mItemsToRemove.addAll(list);
                for (PkgItem pkgItem : list) {
                    if (!pkgItem.hasUpdatePkg()) continue;
                    this.mUpdatesToRemove.put(pkgItem.getUpdatePkg(), pkgItem);
                }
            }
            this.addDefaultCategories();
        }

        public boolean updateSourcePackages(SdkSource sdkSource, Package[] packageArray) {
            if (packageArray.length > 0) {
                this.mVisitedSources.add(sdkSource);
            }
            if (sdkSource == null) {
                return PackagesDiffLogic.this.processLocals(this, packageArray);
            }
            return PackagesDiffLogic.this.processSource(this, sdkSource, packageArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateEnd() {
            boolean bl = false;
            List<PkgCategory> list = this.mCategories;
            synchronized (list) {
                for (PkgCategory pkgCategory : this.mCatsToRemove) {
                    if (!this.mCategories.remove(pkgCategory)) continue;
                    bl = true;
                }
            }
            for (PkgCategory pkgCategory : this.mCategories) {
                Iterator<PkgItem> iterator = pkgCategory.getItems().iterator();
                while (iterator.hasNext()) {
                    PkgItem pkgItem = iterator.next();
                    if (this.mItemsToRemove.contains(pkgItem)) {
                        iterator.remove();
                        bl = true;
                        continue;
                    }
                    if (!pkgItem.hasUpdatePkg() || !this.mUpdatesToRemove.containsKey(pkgItem.getUpdatePkg())) continue;
                    pkgItem.removeUpdate();
                    bl = true;
                }
            }
            this.mCatsToRemove.clear();
            this.mItemsToRemove.clear();
            this.mUpdatesToRemove.clear();
            return bl;
        }

        public boolean isKeep(PkgItem pkgItem) {
            return !this.mItemsToRemove.contains(pkgItem);
        }

        public void keep(Package package_) {
            this.mUpdatesToRemove.remove(package_);
        }

        public void keep(PkgItem pkgItem) {
            this.mItemsToRemove.remove(pkgItem);
        }

        public void keep(PkgCategory pkgCategory) {
            this.mCatsToRemove.remove(pkgCategory);
        }

        public void dontKeep(PkgItem pkgItem) {
            this.mItemsToRemove.add(pkgItem);
        }

        public void dontKeep(PkgCategory pkgCategory) {
            this.mCatsToRemove.add(pkgCategory);
        }
    }
}

