/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.sdkman2;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IPackageVersion;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgItem
implements Comparable<PkgItem> {
    private final PkgState mState;
    private final Package mMainPkg;
    private Package mUpdatePkg;
    private boolean mChecked;

    public PkgItem(Package package_, PkgState pkgState) {
        this.mMainPkg = package_;
        this.mState = pkgState;
        assert (this.mMainPkg != null);
    }

    public boolean isObsolete() {
        return this.mMainPkg.isObsolete();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean bl) {
        this.mChecked = bl;
    }

    public Package getUpdatePkg() {
        return this.mUpdatePkg;
    }

    public boolean hasUpdatePkg() {
        return this.mUpdatePkg != null;
    }

    public String getName() {
        return this.mMainPkg.getListDescription();
    }

    public int getRevision() {
        return this.mMainPkg.getRevision();
    }

    public String getDescription() {
        return this.mMainPkg.getDescription();
    }

    public Package getMainPackage() {
        return this.mMainPkg;
    }

    public PkgState getState() {
        return this.mState;
    }

    public SdkSource getSource() {
        return this.mMainPkg.getParentSource();
    }

    public int getApi() {
        return this.mMainPkg instanceof IPackageVersion ? ((IPackageVersion)this.mMainPkg).getVersion().getApiLevel() : -1;
    }

    public Archive[] getArchives() {
        return this.mMainPkg.getArchives();
    }

    @Override
    public int compareTo(PkgItem pkgItem) {
        return this.getMainPackage().compareTo(pkgItem.getMainPackage());
    }

    public boolean hasArchive(Archive archive) {
        if (this.mMainPkg.hasArchive(archive)) {
            return true;
        }
        return this.mUpdatePkg != null && this.mUpdatePkg.hasArchive(archive);
    }

    public boolean hasCompatibleArchive() {
        return this.mMainPkg.hasCompatibleArchive();
    }

    public boolean isSameMainPackageAs(Package package_) {
        if (this.mMainPkg.canBeUpdatedBy(package_) == Package.UpdateInfo.NOT_UPDATE) {
            return this.mMainPkg.getRevision() == package_.getRevision();
        }
        return false;
    }

    public boolean isSameUpdatePackageAs(Package package_) {
        if (this.mUpdatePkg != null && this.mUpdatePkg.canBeUpdatedBy(package_) == Package.UpdateInfo.NOT_UPDATE) {
            return this.mUpdatePkg.getRevision() == package_.getRevision();
        }
        return false;
    }

    public boolean isSameItemAs(PkgItem pkgItem) {
        boolean bl;
        if (this == pkgItem) {
            return true;
        }
        boolean bl2 = bl = this.mState == pkgItem.mState;
        if (bl) {
            bl = this.isSameMainPackageAs(pkgItem.getMainPackage());
        }
        if (bl) {
            Package package_ = this.mUpdatePkg;
            Package package_2 = pkgItem.getUpdatePkg();
            boolean bl3 = bl = package_ == package_2 || package_ == null && package_2 == null || package_ != null && package_2 != null;
            if (bl && package_ != null) {
                bl = package_.canBeUpdatedBy(package_2) == Package.UpdateInfo.NOT_UPDATE;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        return object instanceof PkgItem && this.isSameItemAs((PkgItem)object);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mState == null ? 0 : this.mState.hashCode());
        n = 31 * n + (this.mMainPkg == null ? 0 : this.mMainPkg.hashCode());
        n = 31 * n + (this.mUpdatePkg == null ? 0 : this.mUpdatePkg.hashCode());
        return n;
    }

    public boolean mergeUpdate(Package package_) {
        if (this.mUpdatePkg == package_) {
            return true;
        }
        if (this.mMainPkg.canBeUpdatedBy(package_) == Package.UpdateInfo.UPDATE) {
            if (this.mUpdatePkg == null) {
                this.mUpdatePkg = package_;
            } else if (this.mUpdatePkg.canBeUpdatedBy(package_) == Package.UpdateInfo.UPDATE) {
                this.mUpdatePkg = package_;
            }
            return true;
        }
        return false;
    }

    public void removeUpdate() {
        this.mUpdatePkg = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        if (this.mChecked) {
            stringBuilder.append(" * ");
        }
        stringBuilder.append(this.mState.toString());
        if (this.mMainPkg != null) {
            stringBuilder.append(", pkg:");
            stringBuilder.append(this.mMainPkg.toString());
        }
        if (this.mUpdatePkg != null) {
            stringBuilder.append(", updated by:");
            stringBuilder.append(this.mUpdatePkg.toString());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PkgState {
        INSTALLED,
        NEW;

    }
}

