/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.sdkuilib.internal.tasks.IProgressUiProvider;

class TaskMonitorImpl
implements ITaskMonitor {
    private static final double MAX_COUNT = 10000.0;
    private double mIncCoef = 0.0;
    private double mValue = 0.0;
    private final IProgressUiProvider mUi;

    public static boolean isTaskMonitorImpl(ITaskMonitor iTaskMonitor) {
        return iTaskMonitor instanceof TaskMonitorImpl || iTaskMonitor instanceof SubTaskMonitor;
    }

    public TaskMonitorImpl(IProgressUiProvider iProgressUiProvider) {
        this.mUi = iProgressUiProvider;
    }

    public IProgressUiProvider getUiProvider() {
        return this.mUi;
    }

    public void setDescription(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.mUi.setDescription(string2);
    }

    public void log(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.mUi.log(string2);
    }

    public void logError(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.mUi.logError(string2);
    }

    public void logVerbose(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.mUi.logVerbose(string2);
    }

    public void setProgressMax(int n) {
        assert (n > 0);
        this.mUi.setProgressMax(10000);
        double d = this.mIncCoef = n > 0 ? 10000.0 / (double)n : 0.0;
        assert (this.mIncCoef > 0.0);
    }

    public int getProgressMax() {
        return this.mIncCoef > 0.0 ? (int)(10000.0 / this.mIncCoef) : 0;
    }

    public void incProgress(int n) {
        if (n > 0 && this.mIncCoef > 0.0) {
            this.internalIncProgress((double)n * this.mIncCoef);
        }
    }

    private void internalIncProgress(double d) {
        this.mValue += d;
        this.mUi.setProgress((int)this.mValue);
    }

    public int getProgress() {
        return this.mIncCoef > 0.0 ? (int)((double)this.mUi.getProgress() / this.mIncCoef) : 0;
    }

    public boolean isCancelRequested() {
        return this.mUi.isCancelRequested();
    }

    public boolean displayPrompt(String string, String string2) {
        return this.mUi.displayPrompt(string, string2);
    }

    public UserCredentials displayLoginCredentialsPrompt(String string, String string2) {
        return this.mUi.displayLoginCredentialsPrompt(string, string2);
    }

    public ITaskMonitor createSubMonitor(int n) {
        assert (this.mIncCoef > 0.0);
        assert (n > 0);
        return new SubTaskMonitor(this, null, this.mValue, (double)n * this.mIncCoef);
    }

    public void error(Throwable throwable, String string, Object ... objectArray) {
        if (string != null) {
            this.logError("Error: " + string, objectArray);
        }
        if (throwable != null) {
            this.logError("%s", throwable.getMessage());
        }
    }

    public void warning(String string, Object ... objectArray) {
        this.log("Warning: " + string, objectArray);
    }

    public void printf(String string, Object ... objectArray) {
        this.log(string, objectArray);
    }

    private static class SubTaskMonitor
    implements ISubTaskMonitor {
        private final TaskMonitorImpl mRoot;
        private final ISubTaskMonitor mParent;
        private final double mStart;
        private final double mSpan;
        private double mSubValue;
        private double mSubCoef;

        public SubTaskMonitor(TaskMonitorImpl taskMonitorImpl, ISubTaskMonitor iSubTaskMonitor, double d, double d2) {
            this.mRoot = taskMonitorImpl;
            this.mParent = iSubTaskMonitor;
            this.mStart = d;
            this.mSpan = d2;
            this.mSubValue = d;
        }

        public boolean isCancelRequested() {
            return this.mRoot.isCancelRequested();
        }

        public void setDescription(String string, Object ... objectArray) {
            this.mRoot.setDescription(string, objectArray);
        }

        public void log(String string, Object ... objectArray) {
            this.mRoot.log(string, objectArray);
        }

        public void logError(String string, Object ... objectArray) {
            this.mRoot.logError(string, objectArray);
        }

        public void logVerbose(String string, Object ... objectArray) {
            this.mRoot.logVerbose(string, objectArray);
        }

        public void setProgressMax(int n) {
            assert (n > 0);
            double d = this.mSubCoef = n > 0 ? this.mSpan / (double)n : 0.0;
            assert (this.mSubCoef > 0.0);
        }

        public int getProgressMax() {
            return this.mSubCoef > 0.0 ? (int)(this.mSpan / this.mSubCoef) : 0;
        }

        public int getProgress() {
            assert (this.mSubValue == this.mStart || this.mSubCoef > 0.0);
            return this.mSubCoef > 0.0 ? (int)((this.mSubValue - this.mStart) / this.mSubCoef) : 0;
        }

        public void incProgress(int n) {
            if (n > 0 && this.mSubCoef > 0.0) {
                this.subIncProgress((double)n * this.mSubCoef);
            }
        }

        public void subIncProgress(double d) {
            this.mSubValue += d;
            if (this.mParent != null) {
                this.mParent.subIncProgress(d);
            } else {
                this.mRoot.internalIncProgress(d);
            }
        }

        public boolean displayPrompt(String string, String string2) {
            return this.mRoot.displayPrompt(string, string2);
        }

        public UserCredentials displayLoginCredentialsPrompt(String string, String string2) {
            return this.mRoot.displayLoginCredentialsPrompt(string, string2);
        }

        public ITaskMonitor createSubMonitor(int n) {
            assert (this.mSubCoef > 0.0);
            assert (n > 0);
            return new SubTaskMonitor(this.mRoot, this, this.mSubValue, (double)n * this.mSubCoef);
        }

        public void error(Throwable throwable, String string, Object ... objectArray) {
            this.mRoot.error(throwable, string, objectArray);
        }

        public void warning(String string, Object ... objectArray) {
            this.mRoot.warning(string, objectArray);
        }

        public void printf(String string, Object ... objectArray) {
            this.mRoot.printf(string, objectArray);
        }
    }

    private static interface ISubTaskMonitor
    extends ITaskMonitor {
        public void subIncProgress(double var1);
    }
}

