/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.NullSdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.tasks.ProgressTask;
import com.android.sdkuilib.internal.widgets.AvdCreationDialog;
import com.android.sdkuilib.internal.widgets.AvdDetailsDialog;
import com.android.sdkuilib.internal.widgets.AvdStartDialog;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class AvdSelector {
    private static int NUM_COL = 2;
    private final DisplayMode mDisplayMode;
    private AvdManager mAvdManager;
    private final String mOsSdkPath;
    private Table mTable;
    private Button mDeleteButton;
    private Button mDetailsButton;
    private Button mNewButton;
    private Button mEditButton;
    private Button mRefreshButton;
    private Button mManagerButton;
    private Button mRepairButton;
    private Button mStartButton;
    private SelectionListener mSelectionListener;
    private IAvdFilter mTargetFilter;
    private boolean mIsEnabled = true;
    private ImageFactory mImageFactory;
    private Image mOkImage;
    private Image mBrokenImage;
    private Image mInvalidImage;
    private SettingsController mController;
    private final ISdkLog mSdkLog;

    public AvdSelector(Composite composite, String string, AvdManager avdManager, IAvdFilter iAvdFilter, DisplayMode displayMode, ISdkLog iSdkLog) {
        TableColumn tableColumn;
        TableColumn tableColumn2;
        Composite composite2;
        Composite composite3;
        this.mOsSdkPath = string;
        this.mAvdManager = avdManager;
        this.mTargetFilter = iAvdFilter;
        this.mDisplayMode = displayMode;
        this.mSdkLog = iSdkLog;
        this.mImageFactory = new ImageFactory(composite.getDisplay());
        this.mOkImage = this.mImageFactory.getImageByName("accept_icon16.png");
        this.mBrokenImage = this.mImageFactory.getImageByName("broken_16.png");
        this.mInvalidImage = this.mImageFactory.getImageByName("reject_icon16.png");
        Composite composite4 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(NUM_COL, false);
        composite4.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite4.setLayoutData((Object)new GridData(1808));
        composite4.setFont(composite.getFont());
        composite4.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AvdSelector.this.mImageFactory.dispose();
            }
        });
        int n = 67588;
        if (displayMode == DisplayMode.SIMPLE_CHECK) {
            n |= 0x20;
        }
        this.mTable = new Table(composite4, n);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(false);
        this.setTableHeightHint(0);
        Composite composite5 = new Composite(composite4, 0);
        gridLayout = new GridLayout(1, false);
        composite5.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite5.setLayoutData((Object)new GridData(1040));
        composite5.setFont(composite4.getFont());
        if (displayMode == DisplayMode.MANAGER) {
            this.mNewButton = new Button(composite5, 0x800008);
            this.mNewButton.setLayoutData((Object)new GridData(768));
            this.mNewButton.setText("New...");
            this.mNewButton.setToolTipText("Creates a new AVD.");
            this.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AvdSelector.this.onNew();
                }
            });
            this.mEditButton = new Button(composite5, 0x800008);
            this.mEditButton.setLayoutData((Object)new GridData(768));
            this.mEditButton.setText("Edit...");
            this.mEditButton.setToolTipText("Edit an existing AVD.");
            this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AvdSelector.this.onEdit();
                }
            });
            this.mDeleteButton = new Button(composite5, 0x800008);
            this.mDeleteButton.setLayoutData((Object)new GridData(768));
            this.mDeleteButton.setText("Delete...");
            this.mDeleteButton.setToolTipText("Deletes the selected AVD.");
            this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AvdSelector.this.onDelete();
                }
            });
            this.mRepairButton = new Button(composite5, 0x800008);
            this.mRepairButton.setLayoutData((Object)new GridData(768));
            this.mRepairButton.setText("Repair...");
            this.mRepairButton.setToolTipText("Repairs the selected AVD.");
            this.mRepairButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AvdSelector.this.onRepair();
                }
            });
            composite3 = new Label(composite5, 258);
            composite3.setLayoutData((Object)new GridData(768));
        }
        this.mDetailsButton = new Button(composite5, 0x800008);
        this.mDetailsButton.setLayoutData((Object)new GridData(768));
        this.mDetailsButton.setText("Details...");
        this.mDetailsButton.setToolTipText("Displays details of the selected AVD.");
        this.mDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AvdSelector.this.onDetails();
            }
        });
        this.mStartButton = new Button(composite5, 0x800008);
        this.mStartButton.setLayoutData((Object)new GridData(768));
        this.mStartButton.setText("Start...");
        this.mStartButton.setToolTipText("Starts the selected AVD.");
        this.mStartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AvdSelector.this.onStart();
            }
        });
        composite3 = new Composite(composite5, 0);
        composite3.setLayoutData((Object)new GridData(1040));
        this.mRefreshButton = new Button(composite5, 0x800008);
        this.mRefreshButton.setLayoutData((Object)new GridData(768));
        this.mRefreshButton.setText("Refresh");
        this.mRefreshButton.setToolTipText("Reloads the list of AVD.\nUse this if you create AVDs from the command line.");
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AvdSelector.this.refresh(true);
            }
        });
        if (displayMode != DisplayMode.MANAGER) {
            this.mManagerButton = new Button(composite5, 0x800008);
            this.mManagerButton.setLayoutData((Object)new GridData(768));
            this.mManagerButton.setText("Manager...");
            this.mManagerButton.setToolTipText("Launches the AVD manager.");
            this.mManagerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AvdSelector.this.onManager();
                }
            });
        } else {
            composite2 = new Composite(composite4, 0);
            gridLayout = new GridLayout(4, false);
            composite2.setLayout((Layout)gridLayout);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayoutData((Object)new GridData(4, 1, true, false, NUM_COL, 1));
            composite2.setFont(composite4.getFont());
            new Label(composite2, 0).setImage(this.mOkImage);
            new Label(composite2, 0).setText("A valid Android Virtual Device.");
            new Label(composite2, 0).setImage(this.mBrokenImage);
            new Label(composite2, 0).setText("A repairable Android Virtual Device.");
            new Label(composite2, 0).setImage(this.mInvalidImage);
            tableColumn2 = new Label(composite2, 0);
            tableColumn2.setText("An Android Virtual Device that failed to load. Click 'Details' to see the error.");
            tableColumn = new GridData(768);
            tableColumn2.setLayoutData((Object)tableColumn);
            tableColumn.horizontalSpan = 3;
        }
        composite2 = new TableColumn(this.mTable, 0);
        composite2.setText("AVD Name");
        tableColumn2 = new TableColumn(this.mTable, 0);
        tableColumn2.setText("Target Name");
        tableColumn = new TableColumn(this.mTable, 0);
        tableColumn.setText("Platform");
        TableColumn tableColumn3 = new TableColumn(this.mTable, 0);
        tableColumn3.setText("API Level");
        TableColumn tableColumn4 = new TableColumn(this.mTable, 0);
        tableColumn4.setText("CPU/ABI");
        this.adjustColumnsWidth(this.mTable, (TableColumn)composite2, tableColumn2, tableColumn, tableColumn3, tableColumn4);
        this.setupSelectionListener(this.mTable);
        this.fillTable(this.mTable);
        this.setEnabled(true);
    }

    public AvdSelector(Composite composite, String string, AvdManager avdManager, DisplayMode displayMode, ISdkLog iSdkLog) {
        this(composite, string, avdManager, (IAvdFilter)null, displayMode, iSdkLog);
    }

    public AvdSelector(Composite composite, String string, AvdManager avdManager, IAndroidTarget iAndroidTarget, DisplayMode displayMode, ISdkLog iSdkLog) {
        this(composite, string, avdManager, new TargetBasedFilter(iAndroidTarget), displayMode, iSdkLog);
    }

    public void setSettingsController(SettingsController settingsController) {
        this.mController = settingsController;
    }

    public void setTableHeightHint(int n) {
        GridData gridData = new GridData();
        if (n > 0) {
            gridData.heightHint = n;
        }
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.mTable.setLayoutData((Object)gridData);
    }

    public boolean refresh(boolean bl) {
        if (bl) {
            try {
                this.mAvdManager.reloadAvds(NullSdkLog.getLogger());
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                return false;
            }
        }
        AvdInfo avdInfo = this.getSelected();
        this.fillTable(this.mTable);
        this.setSelection(avdInfo);
        return true;
    }

    public void setManager(AvdManager avdManager) {
        this.mAvdManager = avdManager;
    }

    public void setFilter(IAvdFilter iAvdFilter) {
        this.mTargetFilter = iAvdFilter;
    }

    public void setFilter(IAndroidTarget iAndroidTarget) {
        this.mTargetFilter = iAndroidTarget != null ? new TargetBasedFilter(iAndroidTarget) : null;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListener = selectionListener;
    }

    public boolean setSelection(AvdInfo avdInfo) {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.mTable.getSelectionIndex();
        int n2 = 0;
        for (TableItem tableItem : this.mTable.getItems()) {
            if (this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
                if ((AvdInfo)tableItem.getData() == avdInfo) {
                    bl = true;
                    if (tableItem.getChecked()) continue;
                    bl2 = true;
                    tableItem.setChecked(true);
                    continue;
                }
                if (!tableItem.getChecked()) continue;
                bl2 = true;
                tableItem.setChecked(false);
                continue;
            }
            if ((AvdInfo)tableItem.getData() == avdInfo) {
                bl = true;
                if (n2 == n) break;
                this.mTable.setSelection(n2);
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (bl2 && this.mSelectionListener != null) {
            this.mSelectionListener.widgetSelected(null);
        }
        this.enableActionButtons();
        return bl;
    }

    public AvdInfo getSelected() {
        if (this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
            for (TableItem tableItem : this.mTable.getItems()) {
                if (!tableItem.getChecked()) continue;
                return (AvdInfo)tableItem.getData();
            }
        } else {
            int n = this.mTable.getSelectionIndex();
            if (n >= 0) {
                return (AvdInfo)this.mTable.getItem(n).getData();
            }
        }
        return null;
    }

    public void setEnabled(boolean bl) {
        this.mIsEnabled = bl && this.mAvdManager != null;
        this.mTable.setEnabled(this.mIsEnabled);
        this.mRefreshButton.setEnabled(this.mIsEnabled);
        if (this.mNewButton != null) {
            this.mNewButton.setEnabled(this.mIsEnabled);
        }
        if (this.mManagerButton != null) {
            this.mManagerButton.setEnabled(this.mIsEnabled);
        }
        this.enableActionButtons();
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    private void adjustColumnsWidth(final Table table, final TableColumn tableColumn, final TableColumn tableColumn2, final TableColumn tableColumn3, final TableColumn tableColumn4, final TableColumn tableColumn5) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = table.getClientArea();
                tableColumn.setWidth(rectangle.width * 20 / 100);
                tableColumn2.setWidth(rectangle.width * 30 / 100);
                tableColumn3.setWidth(rectangle.width * 15 / 100);
                tableColumn4.setWidth(rectangle.width * 15 / 100);
                tableColumn5.setWidth(rectangle.width * 20 / 100);
            }
        });
    }

    private void setupSelectionListener(Table table) {
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)selectionEvent.item;
                    this.enforceSingleSelection(tableItem);
                }
                if (AvdSelector.this.mSelectionListener != null) {
                    AvdSelector.this.mSelectionListener.widgetSelected(selectionEvent);
                }
                AvdSelector.this.enableActionButtons();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                boolean bl;
                if (selectionEvent.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)selectionEvent.item;
                    if (AvdSelector.this.mDisplayMode == DisplayMode.SIMPLE_CHECK) {
                        tableItem.setChecked(true);
                    }
                    this.enforceSingleSelection(tableItem);
                }
                boolean bl2 = bl = AvdSelector.this.mDisplayMode != DisplayMode.SIMPLE_CHECK;
                if (AvdSelector.this.mSelectionListener != null) {
                    AvdSelector.this.mSelectionListener.widgetDefaultSelected(selectionEvent);
                    bl &= selectionEvent.doit;
                }
                if (bl) {
                    AvdSelector.this.onDetails();
                }
                AvdSelector.this.enableActionButtons();
            }

            private void enforceSingleSelection(TableItem tableItem) {
                if (AvdSelector.this.mDisplayMode == DisplayMode.SIMPLE_CHECK && tableItem.getChecked()) {
                    Table table = tableItem.getParent();
                    for (TableItem tableItem2 : table.getItems()) {
                        if (tableItem2 == tableItem || !tableItem2.getChecked()) continue;
                        tableItem2.setChecked(false);
                    }
                }
            }
        });
    }

    private void fillTable(Table table) {
        table.removeAll();
        AvdInfo[] avdInfoArray = null;
        if (this.mAvdManager != null) {
            avdInfoArray = this.mDisplayMode == DisplayMode.MANAGER ? this.mAvdManager.getAllAvds() : this.mAvdManager.getValidAvds();
        }
        if (avdInfoArray != null && avdInfoArray.length > 0) {
            Arrays.sort(avdInfoArray, new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo avdInfo, AvdInfo avdInfo2) {
                    return avdInfo.compareTo(avdInfo2);
                }
            });
            table.setEnabled(true);
            if (this.mTargetFilter != null) {
                this.mTargetFilter.prepare();
            }
            for (AvdInfo avdInfo : avdInfoArray) {
                AvdInfo.AvdStatus avdStatus;
                if (this.mTargetFilter != null && !this.mTargetFilter.accept(avdInfo)) continue;
                TableItem tableItem = new TableItem(table, 0);
                tableItem.setData((Object)avdInfo);
                tableItem.setText(0, avdInfo.getName());
                if (this.mDisplayMode == DisplayMode.MANAGER) {
                    avdStatus = avdInfo.getStatus();
                    tableItem.setImage(0, avdStatus == AvdInfo.AvdStatus.OK ? this.mOkImage : (this.isAvdRepairable(avdStatus) ? this.mBrokenImage : this.mInvalidImage));
                }
                if ((avdStatus = avdInfo.getTarget()) != null) {
                    tableItem.setText(1, avdStatus.getFullName());
                    tableItem.setText(2, avdStatus.getVersionName());
                    tableItem.setText(3, avdStatus.getVersion().getApiString());
                    tableItem.setText(4, AvdInfo.getPrettyAbiType((String)avdInfo.getAbiType()));
                    continue;
                }
                tableItem.setText(1, "?");
                tableItem.setText(2, "?");
                tableItem.setText(3, "?");
                tableItem.setText(4, "?");
            }
            if (this.mTargetFilter != null) {
                this.mTargetFilter.cleanup();
            }
        }
        if (table.getItemCount() == 0) {
            table.setEnabled(false);
            AvdInfo[] avdInfoArray2 = new TableItem(table, 0);
            avdInfoArray2.setData(null);
            avdInfoArray2.setText(0, "--");
            avdInfoArray2.setText(1, "No AVD available");
            avdInfoArray2.setText(2, "--");
            avdInfoArray2.setText(3, "--");
        }
    }

    private AvdInfo getTableSelection() {
        int n = this.mTable.getSelectionIndex();
        if (n >= 0) {
            return (AvdInfo)this.mTable.getItem(n).getData();
        }
        return null;
    }

    private void enableActionButtons() {
        if (!this.mIsEnabled) {
            this.mDetailsButton.setEnabled(false);
            this.mStartButton.setEnabled(false);
            if (this.mEditButton != null) {
                this.mEditButton.setEnabled(false);
            }
            if (this.mDeleteButton != null) {
                this.mDeleteButton.setEnabled(false);
            }
            if (this.mRepairButton != null) {
                this.mRepairButton.setEnabled(false);
            }
        } else {
            AvdInfo avdInfo = this.getTableSelection();
            boolean bl = avdInfo != null;
            this.mDetailsButton.setEnabled(bl);
            this.mStartButton.setEnabled(this.mOsSdkPath != null && bl && avdInfo.getStatus() == AvdInfo.AvdStatus.OK);
            if (this.mEditButton != null) {
                this.mEditButton.setEnabled(bl);
            }
            if (this.mDeleteButton != null) {
                this.mDeleteButton.setEnabled(bl);
            }
            if (this.mRepairButton != null) {
                this.mRepairButton.setEnabled(bl && this.isAvdRepairable(avdInfo.getStatus()));
            }
        }
    }

    private void onNew() {
        AvdCreationDialog avdCreationDialog = new AvdCreationDialog(this.mTable.getShell(), this.mAvdManager, this.mImageFactory, this.mSdkLog, null);
        if (avdCreationDialog.open() == 0) {
            this.refresh(false);
        }
    }

    private void onEdit() {
        AvdInfo avdInfo = this.getTableSelection();
        AvdCreationDialog avdCreationDialog = new AvdCreationDialog(this.mTable.getShell(), this.mAvdManager, this.mImageFactory, this.mSdkLog, avdInfo);
        if (avdCreationDialog.open() == 0) {
            this.refresh(false);
        }
    }

    private void onDetails() {
        AvdInfo avdInfo = this.getTableSelection();
        AvdDetailsDialog avdDetailsDialog = new AvdDetailsDialog(this.mTable.getShell(), avdInfo);
        avdDetailsDialog.open();
    }

    private void onDelete() {
        final AvdInfo avdInfo = this.getTableSelection();
        final Display display = this.mTable.getDisplay();
        if (avdInfo.isRunning()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Shell shell = display.getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)"Delete Android Virtual Device", (String)String.format("The Android Virtual Device '%1$s' is currently running in an emulator and cannot be deleted.", avdInfo.getName()));
                }
            });
            return;
        }
        final boolean[] blArray = new boolean[1];
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)"Delete Android Virtual Device", (String)String.format("Please confirm that you want to delete the Android Virtual Device named '%s'. This operation cannot be reverted.", avdInfo.getName()));
            }
        });
        if (!blArray[0]) {
            return;
        }
        ISdkLog iSdkLog = this.mSdkLog;
        if (iSdkLog == null || iSdkLog instanceof MessageBoxLog) {
            iSdkLog = new MessageBoxLog(String.format("Result of deleting AVD '%s':", avdInfo.getName()), display, false);
        }
        boolean bl = this.mAvdManager.deleteAvd(avdInfo, iSdkLog);
        if (iSdkLog instanceof MessageBoxLog) {
            ((MessageBoxLog)iSdkLog).displayResult(bl);
        }
        if (bl) {
            this.refresh(false);
        }
    }

    private void onRepair() {
        block4: {
            AvdInfo avdInfo = this.getTableSelection();
            Display display = this.mTable.getDisplay();
            ISdkLog iSdkLog = this.mSdkLog;
            if (iSdkLog == null || iSdkLog instanceof MessageBoxLog) {
                iSdkLog = new MessageBoxLog(String.format("Result of updating AVD '%s':", avdInfo.getName()), display, false);
            }
            try {
                this.mAvdManager.updateAvd(avdInfo, iSdkLog);
                if (iSdkLog instanceof MessageBoxLog) {
                    ((MessageBoxLog)iSdkLog).displayResult(true);
                }
                this.refresh(false);
            }
            catch (IOException iOException) {
                iSdkLog.error((Throwable)iOException, null, new Object[0]);
                if (!(iSdkLog instanceof MessageBoxLog)) break block4;
                ((MessageBoxLog)iSdkLog).displayResult(false);
            }
        }
    }

    private void onManager() {
        Display display = this.mTable.getDisplay();
        ISdkLog iSdkLog = this.mSdkLog;
        if (iSdkLog == null || iSdkLog instanceof MessageBoxLog) {
            iSdkLog = new MessageBoxLog("Result of SDK Manager", display, true);
        }
        SdkUpdaterWindow sdkUpdaterWindow = new SdkUpdaterWindow(this.mTable.getShell(), iSdkLog, this.mAvdManager.getSdkManager().getLocation(), SdkUpdaterWindow.SdkInvocationContext.AVD_SELECTOR);
        sdkUpdaterWindow.open();
        this.refresh(true);
        if (iSdkLog instanceof MessageBoxLog) {
            ((MessageBoxLog)iSdkLog).displayResult(true);
        }
    }

    private void onStart() {
        AvdInfo avdInfo = this.getTableSelection();
        if (avdInfo == null || this.mOsSdkPath == null) {
            return;
        }
        AvdStartDialog avdStartDialog = new AvdStartDialog(this.mTable.getShell(), avdInfo, this.mOsSdkPath, this.mController);
        if (avdStartDialog.open() == 0) {
            Object object;
            float f;
            String string = this.mOsSdkPath + File.separator + SdkConstants.OS_SDK_TOOLS_FOLDER + SdkConstants.FN_EMULATOR;
            final String string2 = avdInfo.getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add("-avd");
            arrayList.add(string2);
            if (avdStartDialog.hasWipeData()) {
                arrayList.add("-wipe-data");
            }
            if (avdStartDialog.hasSnapshot()) {
                if (!avdStartDialog.hasSnapshotLaunch()) {
                    arrayList.add("-no-snapshot-load");
                }
                if (!avdStartDialog.hasSnapshotSave()) {
                    arrayList.add("-no-snapshot-save");
                }
            }
            if ((f = avdStartDialog.getScale()) != 0.0f) {
                f = Math.round(f * 100.0f);
                arrayList.add("-scale");
                object = new Formatter(Locale.US);
                ((Formatter)object).format("%.2f", Float.valueOf(f /= 100.0f));
                arrayList.add(((Formatter)object).toString());
            }
            object = arrayList.toArray(new String[arrayList.size()]);
            new ProgressTask(this.mTable.getShell(), "Starting Android Emulator", new ITask((String[])object){
                final /* synthetic */ String[] val$command;
                {
                    this.val$command = stringArray;
                }

                public void run(ITaskMonitor iTaskMonitor) {
                    try {
                        iTaskMonitor.setDescription("Starting emulator for AVD '%1$s'", new Object[]{string2});
                        int n = 10;
                        iTaskMonitor.setProgressMax(n);
                        Process process = Runtime.getRuntime().exec(this.val$command);
                        AvdSelector.this.grabEmulatorOutput(process, iTaskMonitor);
                        for (int i = 0; i < n; ++i) {
                            try {
                                Thread.sleep(100L);
                                iTaskMonitor.incProgress(1);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iTaskMonitor.logError("Failed to start emulator: %1$s", new Object[]{iOException.getMessage()});
                    }
                }
            });
        }
    }

    private void grabEmulatorOutput(final Process process, final ITaskMonitor iTaskMonitor) {
        new Thread("emu-stderr"){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        iTaskMonitor.logError("%1$s", new Object[]{string});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        new Thread("emu-stdout"){

            public void run() {
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        iTaskMonitor.log("%1$s", new Object[]{string});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private boolean isAvdRepairable(AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
    }

    private static final class TargetBasedFilter
    implements IAvdFilter {
        private final IAndroidTarget mTarget;

        TargetBasedFilter(IAndroidTarget iAndroidTarget) {
            this.mTarget = iAndroidTarget;
        }

        public void prepare() {
        }

        public boolean accept(AvdInfo avdInfo) {
            if (avdInfo != null) {
                return this.mTarget.canRunOn(avdInfo.getTarget());
            }
            return false;
        }

        public void cleanup() {
        }
    }

    public static interface IAvdFilter {
        public void prepare();

        public boolean accept(AvdInfo var1);

        public void cleanup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        MANAGER,
        SIMPLE_CHECK,
        SIMPLE_SELECTION;

    }
}

