/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdkuilib.ui.GridDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HardwarePropertyChooser
extends GridDialog {
    private final Map<String, HardwareProperties.HardwareProperty> mProperties;
    private final Collection<String> mExceptProperties;
    private HardwareProperties.HardwareProperty mChosenProperty;
    private Label mTypeLabel;
    private Label mDescriptionLabel;

    HardwarePropertyChooser(Shell shell, Map<String, HardwareProperties.HardwareProperty> map, Collection<String> collection) {
        super(shell, 2, false);
        this.mProperties = map;
        this.mExceptProperties = collection;
    }

    public HardwareProperties.HardwareProperty getProperty() {
        return this.mChosenProperty;
    }

    @Override
    public void createDialogContent(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Property:");
        final Combo combo = new Combo(composite, 12);
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, HardwareProperties.HardwareProperty> entry : this.mProperties.entrySet()) {
            if (!entry.getValue().isValidForUi() || this.mExceptProperties.contains(entry.getKey())) continue;
            combo.add(entry.getValue().getAbstract());
            arrayList.add(entry.getKey());
        }
        boolean bl = true;
        if (arrayList.size() == 0) {
            bl = false;
            combo.add("No properties");
            combo.select(0);
            combo.setEnabled(false);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                String string = (String)arrayList.get(n);
                HardwarePropertyChooser.this.processSelection(string, true);
            }
        });
        label = new Label(composite, 0);
        label.setText("Type:");
        this.mTypeLabel = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText("Description:");
        this.mDescriptionLabel = new Label(composite, 0);
        if (bl) {
            combo.select(0);
            this.processSelection((String)arrayList.get(0), false);
        }
    }

    private void processSelection(String string, boolean bl) {
        this.mChosenProperty = string == null ? null : this.mProperties.get(string);
        String string2 = "Unknown";
        String string3 = "Unknown";
        if (this.mChosenProperty != null) {
            string3 = this.mChosenProperty.getDescription();
            HardwareProperties.ValueType valueType = this.mChosenProperty.getType();
            if (valueType != null) {
                string2 = valueType.getValue();
            }
        }
        this.mTypeLabel.setText(string2);
        this.mDescriptionLabel.setText(string3);
        if (bl) {
            this.getShell().pack();
        }
    }
}

