/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.ui;

import com.android.sdklib.SdkConstants;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class SwtBaseDialog
extends Dialog {
    private static final int MIN_Y = SdkConstants.CURRENT_PLATFORM == 3 ? 20 : 0;
    private static Map<Class<?>, Point> sLastSizeMap = new HashMap();
    private volatile boolean mQuitRequested = false;
    private boolean mReturnValue;
    private Shell mShell;

    public SwtBaseDialog(Shell shell, int n, String string) {
        super(shell, n);
        if (string != null) {
            this.setText(string);
        }
    }

    public boolean open() {
        if (!this.mQuitRequested) {
            this.createShell();
        }
        if (!this.mQuitRequested) {
            this.createContents();
        }
        if (!this.mQuitRequested) {
            this.positionShell();
        }
        if (!this.mQuitRequested) {
            this.postCreate();
        }
        if (!this.mQuitRequested) {
            this.mShell.open();
            this.mShell.layout();
            this.eventLoop();
        }
        return this.mReturnValue;
    }

    protected void createShell() {
        this.mShell = new Shell(this.getParent(), 67696);
        this.mShell.setMinimumSize(new Point(450, 300));
        this.mShell.setSize(450, 300);
        if (this.getText() != null) {
            this.mShell.setText(this.getText());
        }
        this.mShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SwtBaseDialog.this.saveSize();
            }
        });
    }

    protected abstract void createContents();

    protected abstract void postCreate();

    protected void eventLoop() {
        Display display = this.getParent().getDisplay();
        while (!this.mQuitRequested && !this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected boolean getReturnValue() {
        return this.mReturnValue;
    }

    protected void setReturnValue(boolean bl) {
        this.mReturnValue = bl;
    }

    protected Shell getShell() {
        return this.mShell;
    }

    protected void close() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.saveSize();
            this.getShell().close();
        }
        this.mQuitRequested = true;
    }

    private void positionShell() {
        Shell shell = this.mShell;
        Shell shell2 = this.getParent();
        if (shell != null && shell2 != null) {
            int n;
            Rectangle rectangle = shell2.getClientArea();
            Point point = shell2.getLocation();
            int n2 = point.x;
            int n3 = point.y;
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            Point point2 = sLastSizeMap.get(((Object)((Object)this)).getClass());
            if (point2 == null) {
                point2 = shell.getSize();
            }
            int n6 = point2.x;
            int n7 = point2.y;
            int n8 = n2 + (n4 - n6) / 2;
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n = n3 + (n5 - n7) / 2) < MIN_Y) {
                n = MIN_Y;
            }
            shell.setLocation(n8, n);
            shell.setSize(n6, n7);
        }
    }

    private void saveSize() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            sLastSizeMap.put(((Object)((Object)this)).getClass(), this.mShell.getSize());
        }
    }
}

