/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ClassLiteralTemplate;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;

public class ClassLiteral
extends AbstractNode
implements Expression,
DescribedNode {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode typeReference = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public TypeReference astTypeReference() {
        if (!(this.typeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.typeReference;
    }

    public ClassLiteral astTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            throw new NullPointerException("typeReference is mandatory");
        }
        return this.rawTypeReference(typeReference);
    }

    public Node rawTypeReference() {
        return this.typeReference;
    }

    public ClassLiteral rawTypeReference(Node typeReference) {
        if (typeReference == this.typeReference) {
            return this;
        }
        if (typeReference != null) {
            this.adopt((AbstractNode)typeReference);
        }
        if (this.typeReference != null) {
            this.disown(this.typeReference);
        }
        this.typeReference = (AbstractNode)typeReference;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.typeReference != null) {
            result.add(this.typeReference);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.typeReference == original) {
            this.rawTypeReference(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.typeReference == child) {
            this.disown((AbstractNode)child);
            this.typeReference = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitClassLiteral(this)) {
            return;
        }
        if (this.typeReference != null) {
            this.typeReference.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ClassLiteral copy() {
        ClassLiteral result = new ClassLiteral();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.typeReference != null) {
            result.rawTypeReference(this.typeReference.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return ClassLiteralTemplate.getDescription(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

