/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBodyTemplate;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;

public class EnumTypeBody
extends AbstractNode
implements TypeBody {
    ListAccessor<EnumConstant, EnumTypeBody> constants = ListAccessor.of(this, EnumConstant.class, "EnumTypeBody.constants");
    ListAccessor<TypeMember, EnumTypeBody> members = ListAccessor.of(this, TypeMember.class, "EnumTypeBody.members");

    public EnumDeclaration upToEnumDeclaration() {
        if (!(this.getParent() instanceof EnumDeclaration)) {
            return null;
        }
        EnumDeclaration out = (EnumDeclaration)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    @Override
    public TypeDeclaration upToTypeDeclaration() {
        if (!(this.getParent() instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration out = (TypeDeclaration)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public RawListAccessor<EnumConstant, EnumTypeBody> rawConstants() {
        return this.constants.asRaw();
    }

    public StrictListAccessor<EnumConstant, EnumTypeBody> astConstants() {
        return this.constants.asStrict();
    }

    public RawListAccessor<TypeMember, EnumTypeBody> rawMembers() {
        return this.members.asRaw();
    }

    public StrictListAccessor<TypeMember, EnumTypeBody> astMembers() {
        return this.members.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.constants.backingList());
        result.addAll(this.members.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.rawConstants().replace(original, replacement)) {
            return true;
        }
        return this.rawMembers().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.rawConstants().remove(child)) {
            return true;
        }
        return this.rawMembers().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitEnumTypeBody(this)) {
            return;
        }
        for (AbstractNode child : this.constants.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.members.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public EnumTypeBody copy() {
        EnumTypeBody result = new EnumTypeBody();
        for (AbstractNode n : this.constants.backingList()) {
            result.rawConstants().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.members.backingList()) {
            result.rawMembers().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    @Override
    public ConstructorInvocation upIfAnonymousClassToConstructorInvocation() {
        return EnumTypeBodyTemplate.upIfAnonymousClassToConstructorInvocation(this);
    }

    @Override
    public EnumConstant upToEnumConstant() {
        return EnumTypeBodyTemplate.upToEnumConstant(this);
    }
}

