/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.InlineIfExpressionTemplate;
import lombok.ast.Node;
import lombok.ast.Position;

public class InlineIfExpression
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode condition = null;
    private AbstractNode ifTrue = null;
    private AbstractNode ifFalse = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astCondition() {
        if (!(this.condition instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.condition);
    }

    public InlineIfExpression astCondition(Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition is mandatory");
        }
        return this.rawCondition(condition);
    }

    public Node rawCondition() {
        return this.condition;
    }

    public InlineIfExpression rawCondition(Node condition) {
        if (condition == this.condition) {
            return this;
        }
        if (condition != null) {
            this.adopt((AbstractNode)condition);
        }
        if (this.condition != null) {
            this.disown(this.condition);
        }
        this.condition = (AbstractNode)condition;
        return this;
    }

    public Expression astIfTrue() {
        if (!(this.ifTrue instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.ifTrue);
    }

    public InlineIfExpression astIfTrue(Expression ifTrue) {
        if (ifTrue == null) {
            throw new NullPointerException("ifTrue is mandatory");
        }
        return this.rawIfTrue(ifTrue);
    }

    public Node rawIfTrue() {
        return this.ifTrue;
    }

    public InlineIfExpression rawIfTrue(Node ifTrue) {
        if (ifTrue == this.ifTrue) {
            return this;
        }
        if (ifTrue != null) {
            this.adopt((AbstractNode)ifTrue);
        }
        if (this.ifTrue != null) {
            this.disown(this.ifTrue);
        }
        this.ifTrue = (AbstractNode)ifTrue;
        return this;
    }

    public Expression astIfFalse() {
        if (!(this.ifFalse instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.ifFalse);
    }

    public InlineIfExpression astIfFalse(Expression ifFalse) {
        if (ifFalse == null) {
            throw new NullPointerException("ifFalse is mandatory");
        }
        return this.rawIfFalse(ifFalse);
    }

    public Node rawIfFalse() {
        return this.ifFalse;
    }

    public InlineIfExpression rawIfFalse(Node ifFalse) {
        if (ifFalse == this.ifFalse) {
            return this;
        }
        if (ifFalse != null) {
            this.adopt((AbstractNode)ifFalse);
        }
        if (this.ifFalse != null) {
            this.disown(this.ifFalse);
        }
        this.ifFalse = (AbstractNode)ifFalse;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.condition != null) {
            result.add(this.condition);
        }
        if (this.ifTrue != null) {
            result.add(this.ifTrue);
        }
        if (this.ifFalse != null) {
            result.add(this.ifFalse);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.condition == original) {
            this.rawCondition(replacement);
            return true;
        }
        if (this.ifTrue == original) {
            this.rawIfTrue(replacement);
            return true;
        }
        if (this.ifFalse == original) {
            this.rawIfFalse(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.condition == child) {
            this.disown((AbstractNode)child);
            this.condition = null;
            return true;
        }
        if (this.ifTrue == child) {
            this.disown((AbstractNode)child);
            this.ifTrue = null;
            return true;
        }
        if (this.ifFalse == child) {
            this.disown((AbstractNode)child);
            this.ifFalse = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitInlineIfExpression(this)) {
            return;
        }
        if (this.condition != null) {
            this.condition.accept(visitor);
        }
        if (this.ifTrue != null) {
            this.ifTrue.accept(visitor);
        }
        if (this.ifFalse != null) {
            this.ifFalse.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public InlineIfExpression copy() {
        InlineIfExpression result = new InlineIfExpression();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.condition != null) {
            result.rawCondition(this.condition.copy());
        }
        if (this.ifTrue != null) {
            result.rawIfTrue(this.ifTrue.copy());
        }
        if (this.ifFalse != null) {
            result.rawIfFalse(this.ifFalse.copy());
        }
        return result;
    }

    @Override
    public boolean needsParentheses() {
        return InlineIfExpressionTemplate.needsParentheses(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

