/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.ast.libs.org.parboiled.BaseParser;
import lombok.ast.libs.org.parboiled.asm.AnnotationVisitor;
import lombok.ast.libs.org.parboiled.asm.Label;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.LabelNode;
import lombok.ast.libs.org.parboiled.asm.tree.LocalVariableNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodNode;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.BasicValue;
import lombok.ast.libs.org.parboiled.asm.tree.analysis.Value;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.support.Var;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.InstructionGroup;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleMethod
extends MethodNode
implements Opcodes,
Types {
    private final List<InstructionGroup> groups = new ArrayList<InstructionGroup>();
    private final List<LabelNode> usedLabels = new ArrayList<LabelNode>();
    private final Class<?> ownerClass;
    private int parameterCount;
    private boolean containsImplicitActions;
    private boolean containsExplicitActions;
    private boolean containsCaptures;
    private boolean containsVars;
    private boolean containsPotentialSuperCalls;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasCachedAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSuppressNodeAnnotation;
    private boolean hasSuppressSubnodesAnnotation;
    private boolean hasSkipNodeAnnotation;
    private boolean hasSkipActionsInPredicatesAnnotation;
    private int numberOfReturns;
    private InstructionGraphNode returnInstructionNode;
    private List<InstructionGraphNode> graphNodes;
    private List<LocalVariableNode> localVarVariables;
    private boolean bodyRewritten;
    private boolean skipGeneration;

    public RuleMethod(Class<?> ownerClass, int access, String name, String desc, String signature, String[] exceptions, boolean hasExplicitActionOnlyAnno, boolean hasDontLabelAnno, boolean hasSkipActionsInPredicates) {
        super(access, name, desc, signature, exceptions);
        this.ownerClass = ownerClass;
        this.parameterCount = Type.getArgumentTypes(desc).length;
        this.hasCachedAnnotation = this.parameterCount == 0;
        this.hasDontLabelAnnotation = hasDontLabelAnno;
        this.hasExplicitActionOnlyAnnotation = hasExplicitActionOnlyAnno;
        this.hasSkipActionsInPredicatesAnnotation = hasSkipActionsInPredicates;
        this.skipGeneration = this.isSuperMethod();
    }

    public List<InstructionGroup> getGroups() {
        return this.groups;
    }

    public List<LabelNode> getUsedLabels() {
        return this.usedLabels;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public boolean containsImplicitActions() {
        return this.containsImplicitActions;
    }

    public void setContainsImplicitActions(boolean containsImplicitActions) {
        this.containsImplicitActions = containsImplicitActions;
    }

    public boolean containsExplicitActions() {
        return this.containsExplicitActions;
    }

    public void setContainsExplicitActions(boolean containsExplicitActions) {
        this.containsExplicitActions = containsExplicitActions;
    }

    public boolean containsCaptures() {
        return this.containsCaptures;
    }

    public boolean containsVars() {
        return this.containsVars;
    }

    public boolean containsPotentialSuperCalls() {
        return this.containsPotentialSuperCalls;
    }

    public boolean hasCachedAnnotation() {
        return this.hasCachedAnnotation;
    }

    public boolean hasDontLabelAnnotation() {
        return this.hasDontLabelAnnotation;
    }

    public boolean hasSuppressNodeAnnotation() {
        return this.hasSuppressNodeAnnotation;
    }

    public boolean hasSuppressSubnodesAnnotation() {
        return this.hasSuppressSubnodesAnnotation;
    }

    public boolean hasSkipActionsInPredicatesAnnotation() {
        return this.hasSkipActionsInPredicatesAnnotation;
    }

    public boolean hasSkipNodeAnnotation() {
        return this.hasSkipNodeAnnotation;
    }

    public int getNumberOfReturns() {
        return this.numberOfReturns;
    }

    public InstructionGraphNode getReturnInstructionNode() {
        return this.returnInstructionNode;
    }

    public void setReturnInstructionNode(InstructionGraphNode returnInstructionNode) {
        this.returnInstructionNode = returnInstructionNode;
    }

    public List<InstructionGraphNode> getGraphNodes() {
        return this.graphNodes;
    }

    public List<LocalVariableNode> getLocalVarVariables() {
        return this.localVarVariables;
    }

    public boolean isBodyRewritten() {
        return this.bodyRewritten;
    }

    public void setBodyRewritten() {
        this.bodyRewritten = true;
    }

    public boolean isSuperMethod() {
        Preconditions.checkState(StringUtils.isNotEmpty(this.name));
        return this.name.charAt(0) == '$';
    }

    public InstructionGraphNode setGraphNode(AbstractInsnNode insn, BasicValue resultValue, List<Value> predecessors) {
        int index;
        InstructionGraphNode node;
        if (this.graphNodes == null) {
            this.graphNodes = new ArrayList<InstructionGraphNode>(Arrays.asList(new InstructionGraphNode[this.instructions.size()]));
        }
        if ((node = this.graphNodes.get(index = this.instructions.indexOf(insn))) == null) {
            node = new InstructionGraphNode(insn, resultValue);
            this.graphNodes.set(index, node);
        }
        node.addPredecessors(predecessors);
        return node;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (EXPLICIT_ACTIONS_ONLY_DESC.equals(desc)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (CACHED_DESC.equals(desc)) {
            this.hasCachedAnnotation = true;
            return null;
        }
        if (SUPPRESS_NODE_DESC.equals(desc)) {
            this.hasSuppressNodeAnnotation = true;
            return null;
        }
        if (SUPPRESS_SUBNODES_DESC.equals(desc)) {
            this.hasSuppressSubnodesAnnotation = true;
            return null;
        }
        if (SUPPRESS_SUBNODES_DESC.equals(desc)) {
            this.hasSuppressSubnodesAnnotation = true;
            return null;
        }
        if (SKIP_NODE_DESC.equals(desc)) {
            this.hasSkipNodeAnnotation = true;
            return null;
        }
        if (SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicatesAnnotation = true;
            return null;
        }
        if (DONT_SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicatesAnnotation = false;
            return null;
        }
        if (DONT_LABEL_DESC.equals(desc)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        return visible ? super.visitAnnotation(desc, true) : null;
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        switch (n) {
            case 184: {
                if (!this.hasExplicitActionOnlyAnnotation && AsmUtils.isBooleanValueOfZ(string, string2, string3)) {
                    this.containsImplicitActions = true;
                    break;
                }
                if (AsmUtils.isActionRoot(string, string2)) {
                    this.containsExplicitActions = true;
                    break;
                }
                if (!AsmUtils.isCaptureRoot(string, string2)) break;
                this.containsCaptures = true;
                break;
            }
            case 183: {
                if ("<init>".equals(string2)) {
                    if (!AsmUtils.isVarRoot(string, string2, string3)) break;
                    this.containsVars = true;
                    break;
                }
                if (!AsmUtils.isAssignableTo(string, BaseParser.class)) break;
                this.containsPotentialSuperCalls = true;
            }
        }
        super.visitMethodInsn(n, string, string2, string3);
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 176) {
            ++this.numberOfReturns;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.usedLabels.add(this.getLabelNode(label));
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (n > this.parameterCount && Var.class.isAssignableFrom(AsmUtils.getClassForType(Type.getType(string2)))) {
            if (this.localVarVariables == null) {
                this.localVarVariables = new ArrayList<LocalVariableNode>();
            }
            this.localVarVariables.add(new LocalVariableNode(string, string2, null, null, null, n));
        }
    }

    public String toString() {
        return this.name;
    }

    public void moveFlagsTo(@NotNull RuleMethod ruleMethod) {
        if (ruleMethod == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.RuleMethod.moveFlagsTo(...) corresponds to @NotNull parameter and must not be null");
        }
        ruleMethod.hasCachedAnnotation |= this.hasCachedAnnotation;
        ruleMethod.hasDontLabelAnnotation |= this.hasDontLabelAnnotation;
        ruleMethod.hasSuppressNodeAnnotation |= this.hasSuppressNodeAnnotation;
        ruleMethod.hasSuppressSubnodesAnnotation |= this.hasSuppressSubnodesAnnotation;
        ruleMethod.hasSkipNodeAnnotation |= this.hasSkipNodeAnnotation;
        this.hasCachedAnnotation = false;
        this.hasDontLabelAnnotation = true;
        this.hasSuppressNodeAnnotation = false;
        this.hasSuppressSubnodesAnnotation = false;
        this.hasSkipNodeAnnotation = false;
    }

    public boolean isGenerationSkipped() {
        return this.skipGeneration;
    }

    public void dontSkipGeneration() {
        this.skipGeneration = false;
    }
}

