/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.NoOpStringInternStrategy;
import com.google.clearsilver.jsilver.data.StringInternStrategy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSilverOptions
implements Cloneable {
    private boolean cacheTemplates = true;
    private boolean compileTemplates = false;
    private int initialBufferSize = 8192;
    private boolean ignoreAttributes = false;
    private Map<Object, String> precompiledTemplateMap = null;
    private boolean useStrongCacheReferences = false;
    private EscapeMode escapeMode = EscapeMode.ESCAPE_NONE;
    private boolean propagateEscapeStatus = false;
    private StringInternStrategy stringInternStrategy = new NoOpStringInternStrategy();
    private boolean logEscapedVariables = false;
    private boolean useOutputBufferPool = false;
    private boolean stripHtmlWhiteSpace = false;
    private boolean stripStructuralWhiteSpace = false;
    private boolean allowGlobalDataModification = false;
    private boolean keepTemplateCacheFresh = false;
    private int loadPathCacheSize = 1000;

    public JSilverOptions setLoadPathCacheSize(int n) {
        this.loadPathCacheSize = n;
        return this;
    }

    public int getLoadPathCacheSize() {
        return this.loadPathCacheSize;
    }

    public JSilverOptions setCacheTemplates(boolean bl) {
        this.cacheTemplates = bl;
        return this;
    }

    public boolean getCacheTemplates() {
        return this.cacheTemplates;
    }

    public JSilverOptions setCompileTemplates(boolean bl) {
        this.compileTemplates = bl;
        return this;
    }

    public boolean getCompileTemplates() {
        return this.compileTemplates;
    }

    public JSilverOptions setIgnoreAttributes(boolean bl) {
        this.ignoreAttributes = bl;
        return this;
    }

    public boolean getIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public JSilverOptions setInitialBufferSize(int n) {
        this.initialBufferSize = n;
        return this;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public JSilverOptions setPrecompiledTemplateMap(Map<Object, String> map) {
        this.precompiledTemplateMap = map;
        return this;
    }

    public Map<Object, String> getPrecompiledTemplateMap() {
        return this.precompiledTemplateMap;
    }

    public JSilverOptions setUseStrongCacheReferences(boolean bl) {
        this.useStrongCacheReferences = bl;
        return this;
    }

    public boolean getUseStrongCacheReferences() {
        return this.useStrongCacheReferences;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    public JSilverOptions setEscapeMode(EscapeMode escapeMode) {
        this.escapeMode = escapeMode;
        return this;
    }

    public boolean getPropagateEscapeStatus() {
        return this.propagateEscapeStatus;
    }

    public JSilverOptions setPropagateEscapeStatus(boolean bl) {
        this.propagateEscapeStatus = bl;
        return this;
    }

    public void setStringInternStrategy(StringInternStrategy stringInternStrategy) {
        if (stringInternStrategy == null) {
            throw new IllegalArgumentException("StringInternStrategy should not be null.");
        }
        this.stringInternStrategy = stringInternStrategy;
    }

    public StringInternStrategy getStringInternStrategy() {
        return this.stringInternStrategy;
    }

    public JSilverOptions setUseOutputBufferPool(boolean bl) {
        this.useOutputBufferPool = bl;
        return this;
    }

    public boolean getUseOutputBufferPool() {
        return this.useOutputBufferPool;
    }

    public JSilverOptions setStripHtmlWhiteSpace(boolean bl) {
        this.stripHtmlWhiteSpace = bl;
        return this;
    }

    public boolean getStripHtmlWhiteSpace() {
        return this.stripHtmlWhiteSpace;
    }

    public JSilverOptions setStripStructuralWhiteSpace(boolean bl) {
        this.stripStructuralWhiteSpace = bl;
        return this;
    }

    public boolean getStripStructuralWhiteSpace() {
        return this.stripStructuralWhiteSpace;
    }

    public JSilverOptions setAllowGlobalDataModification(boolean bl) {
        this.allowGlobalDataModification = bl;
        return this;
    }

    public boolean getAllowGlobalDataModification() {
        return this.allowGlobalDataModification;
    }

    public JSilverOptions setKeepTemplateCacheFresh(boolean bl) {
        this.keepTemplateCacheFresh = bl;
        return this;
    }

    public boolean getKeepTemplateCacheFresh() {
        return this.keepTemplateCacheFresh;
    }

    public JSilverOptions clone() {
        try {
            return (JSilverOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean getLogEscapedVariables() {
        return this.logEscapedVariables;
    }

    public JSilverOptions setLogEscapedVariables(boolean bl) {
        this.logEscapedVariables = bl;
        return this;
    }
}

