/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.data.DefaultDataContext;
import com.google.clearsilver.jsilver.data.TypeConverter;
import com.google.clearsilver.jsilver.exceptions.ExceptionUtil;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.DefaultRenderingContext;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCompiledTemplate
implements Template {
    private FunctionExecutor functionExecutor;
    private String templateName;
    private TemplateLoader templateLoader;
    private EscapeMode escapeMode = EscapeMode.ESCAPE_NONE;
    private AutoEscapeOptions autoEscapeOptions;

    public void setFunctionExecutor(FunctionExecutor functionExecutor) {
        this.functionExecutor = functionExecutor;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setAutoEscapeOptions(AutoEscapeOptions autoEscapeOptions) {
        this.autoEscapeOptions = autoEscapeOptions;
    }

    @Override
    public void render(Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException {
        this.render(this.createRenderingContext(data, appendable, resourceLoader));
    }

    @Override
    public RenderingContext createRenderingContext(Data data, Appendable appendable, ResourceLoader resourceLoader) {
        DefaultDataContext defaultDataContext = new DefaultDataContext(data);
        return new DefaultRenderingContext(defaultDataContext, resourceLoader, appendable, this.functionExecutor, this.autoEscapeOptions);
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setEscapeMode(EscapeMode escapeMode) {
        this.escapeMode = escapeMode;
    }

    @Override
    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    @Override
    public String getDisplayName() {
        return this.templateName;
    }

    public static boolean validateLoopArgs(int n, int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        if (n3 > 0 && n > n2) {
            return false;
        }
        return n3 >= 0 || n >= n2;
    }

    public static boolean exists(Data data) {
        return TypeConverter.exists(data);
    }

    public static int asInt(String string) {
        return TypeConverter.asNumber(string);
    }

    public static int asInt(int n) {
        return n;
    }

    public static int asInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static int asInt(Value value) {
        return value.asNumber();
    }

    public static int asInt(Data data) {
        return TypeConverter.asNumber(data);
    }

    public static String asString(String string) {
        return string;
    }

    public static String asString(int n) {
        return Integer.toString(n);
    }

    public static String asString(boolean bl) {
        return bl ? "1" : "0";
    }

    public static String asString(Value value) {
        return value.asString();
    }

    public static String asString(Data data) {
        return TypeConverter.asString(data);
    }

    public static Value asValue(String string) {
        return Value.literalValue(string, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(int n) {
        return Value.literalValue(n, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(boolean bl) {
        return Value.literalValue(bl, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(Value value) {
        return value;
    }

    public static Value asVariableValue(String string, DataContext dataContext) {
        return Value.variableValue(string, dataContext);
    }

    public static boolean asBoolean(boolean bl) {
        return bl;
    }

    public static boolean asBoolean(String string) {
        return TypeConverter.asBoolean(string);
    }

    public static boolean asBoolean(int n) {
        return n != 0;
    }

    public static boolean asBoolean(Value value) {
        return value.asBoolean();
    }

    public static boolean asBoolean(Data data) {
        return TypeConverter.asBoolean(data);
    }

    public static String getNodeName(Data data) {
        return data == null ? "" : data.getSymlink().getName();
    }

    public Iterable<? extends Data> getChildren(Data data) {
        if (data == null) {
            return Collections.emptySet();
        }
        return data.getChildren();
    }

    protected TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    protected void include(String string, boolean bl, RenderingContext renderingContext) {
        if (!renderingContext.pushIncludeStackEntry(string)) {
            throw new JSilverInterpreterException(this.createIncludeLoopErrorMessage(string, renderingContext.getIncludedTemplateNames()));
        }
        this.loadAndRenderIncludedTemplate(string, bl, renderingContext);
        if (!renderingContext.popIncludeStackEntry(string)) {
            throw new IllegalStateException("Unable to find on include stack: " + string);
        }
    }

    private void loadAndRenderIncludedTemplate(String string, boolean bl, RenderingContext renderingContext) {
        Template template = null;
        try {
            template = this.templateLoader.load(string, renderingContext.getResourceLoader(), renderingContext.getAutoEscapeMode());
        }
        catch (RuntimeException runtimeException) {
            if (bl && ExceptionUtil.isFileNotFoundException(runtimeException)) {
                return;
            }
            throw runtimeException;
        }
        try {
            template.render(renderingContext);
        }
        catch (IOException iOException) {
            throw new JSilverInterpreterException(iOException.getMessage());
        }
    }

    private String createIncludeLoopErrorMessage(String string, Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File included twice: ");
        stringBuilder.append(string);
        stringBuilder.append(" Include stack:");
        for (String string2 : iterable) {
            stringBuilder.append("\n -> ");
            stringBuilder.append(string2);
        }
        stringBuilder.append("\n -> ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public abstract class CompiledMacro
    implements Macro {
        private final String macroName;
        private final String[] argumentsNames;

        protected CompiledMacro(String string, String ... stringArray) {
            this.macroName = string;
            this.argumentsNames = stringArray;
        }

        public void render(Data data, Appendable appendable, ResourceLoader resourceLoader) throws IOException {
            this.render(this.createRenderingContext(data, appendable, resourceLoader));
        }

        public RenderingContext createRenderingContext(Data data, Appendable appendable, ResourceLoader resourceLoader) {
            return BaseCompiledTemplate.this.createRenderingContext(data, appendable, resourceLoader);
        }

        public String getTemplateName() {
            return BaseCompiledTemplate.this.getTemplateName();
        }

        public String getMacroName() {
            return this.macroName;
        }

        public String getArgumentName(int n) {
            if (n >= this.argumentsNames.length) {
                throw new JSilverInterpreterException("Too many arguments supplied to macro " + this.macroName);
            }
            return this.argumentsNames[n];
        }

        public int getArgumentCount() {
            return this.argumentsNames.length;
        }

        protected TemplateLoader getTemplateLoader() {
            return BaseCompiledTemplate.this.templateLoader;
        }

        public EscapeMode getEscapeMode() {
            return BaseCompiledTemplate.this.getEscapeMode();
        }

        public String getDisplayName() {
            return BaseCompiledTemplate.this.getDisplayName() + ":" + this.macroName;
        }
    }
}

