/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilingClassLoader
extends ClassLoader {
    private Map<String, ByteArrayOutputStream> byteCodeForClasses = new HashMap<String, ByteArrayOutputStream>();
    private static final URI EMPTY_URI;

    public CompilingClassLoader(ClassLoader classLoader, String string, CharSequence charSequence, DiagnosticListener<JavaFileObject> diagnosticListener) throws CompilerException {
        super(classLoader);
        if (!this.compileSourceCodeToByteCode(string, charSequence, diagnosticListener)) {
            throw new CompilerException("Could not compile " + string);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteCodeForClasses.get(string);
        if (byteArrayOutputStream == null) {
            throw new ClassNotFoundException(string);
        }
        return this.defineClass(string, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
    }

    private boolean compileSourceCodeToByteCode(String string, CharSequence charSequence, DiagnosticListener<JavaFileObject> diagnosticListener) {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        InMemoryFileManager inMemoryFileManager = new InMemoryFileManager(javaCompiler.getStandardFileManager(null, null, null));
        InMemoryJavaFile inMemoryJavaFile = new InMemoryJavaFile(string, charSequence);
        System.setProperty("useJavaUtilZip", "true");
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("-XDuseJavaUtilZip");
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, inMemoryFileManager, diagnosticListener, linkedList, null, Collections.singleton(inMemoryJavaFile));
        return compilationTask.call();
    }

    static {
        try {
            EMPTY_URI = new URI("");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    private static class InMemoryJavaFile
    extends SimpleJavaFileObject {
        private final CharSequence sourceCode;

        public InMemoryJavaFile(String string, CharSequence charSequence) {
            super(InMemoryJavaFile.makeUri(string), JavaFileObject.Kind.SOURCE);
            this.sourceCode = charSequence;
        }

        private static URI makeUri(String string) {
            try {
                return new URI(string.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public CharSequence getCharContent(boolean bl) throws IOException {
            return this.sourceCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        public InMemoryFileManager(JavaFileManager javaFileManager) {
            super(javaFileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            return new SimpleJavaFileObject(EMPTY_URI, kind){

                public OutputStream openOutputStream() throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)CompilingClassLoader.this.byteCodeForClasses.get(string);
                    if (byteArrayOutputStream != null) {
                        throw new IllegalStateException("Cannot write more than once");
                    }
                    byteArrayOutputStream = new ByteArrayOutputStream(256);
                    CompilingClassLoader.this.byteCodeForClasses.put(string, byteArrayOutputStream);
                    return byteArrayOutputStream;
                }
            };
        }
    }

    public static class CompilerException
    extends Exception {
        public CompilerException(String string) {
            super(string);
        }
    }
}

