/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.compiler.TemplateTranslator;
import com.google.clearsilver.jsilver.compiler.VariableTranslator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AAndExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AExistsExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AGtExpression;
import com.google.clearsilver.jsilver.syntax.node.AGteExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.ALtExpression;
import com.google.clearsilver.jsilver.syntax.node.ALteExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANotExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.AOrExpression;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.AVariableExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import java.util.LinkedList;

public class EscapingEvaluator
extends DepthFirstAdapter {
    private JavaExpression currentEscapingExpression;
    private boolean propagateEscapeStatus;
    private final VariableTranslator variableTranslator;

    public EscapingEvaluator(VariableTranslator variableTranslator) {
        this.variableTranslator = variableTranslator;
    }

    public JavaExpression computeIfExemptFromEscaping(PExpression pExpression, boolean bl) {
        if (bl) {
            return this.computeForPropagateStatus(pExpression);
        }
        return this.computeEscaping(pExpression, bl);
    }

    private JavaExpression computeForPropagateStatus(PExpression pExpression) {
        JavaExpression javaExpression = this.computeEscaping(pExpression, true);
        JavaExpression javaExpression2 = this.computeEscaping(pExpression, false);
        JavaExpression javaExpression3 = JavaExpression.infix(JavaExpression.Type.BOOLEAN, "!=", javaExpression, JavaExpression.symbol("EscapeMode.ESCAPE_NONE"));
        return JavaExpression.infix(JavaExpression.Type.BOOLEAN, "||", javaExpression3, javaExpression2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaExpression computeEscaping(PExpression pExpression, boolean bl) {
        try {
            assert (this.currentEscapingExpression == null) : "Not reentrant";
            this.propagateEscapeStatus = bl;
            pExpression.apply(this);
            assert (this.currentEscapingExpression != null) : "No escaping calculated";
            JavaExpression javaExpression = this.currentEscapingExpression;
            return javaExpression;
        }
        finally {
            this.currentEscapingExpression = null;
        }
    }

    private void setEscaping(JavaExpression javaExpression) {
        this.currentEscapingExpression = javaExpression;
    }

    public void caseAAddExpression(AAddExpression aAddExpression) {
        aAddExpression.getLeft().apply(this);
        JavaExpression javaExpression = this.currentEscapingExpression;
        aAddExpression.getRight().apply(this);
        JavaExpression javaExpression2 = this.currentEscapingExpression;
        this.setEscaping(this.or(javaExpression, javaExpression2));
    }

    public void caseAFunctionExpression(AFunctionExpression aFunctionExpression) {
        LinkedList<PExpression> linkedList = aFunctionExpression.getArgs();
        PExpression[] pExpressionArray = linkedList.toArray(new PExpression[linkedList.size()]);
        final StringBuilder stringBuilder = new StringBuilder();
        aFunctionExpression.getName().apply(new DepthFirstAdapter(){

            public void caseANameVariable(ANameVariable aNameVariable) {
                stringBuilder.append(aNameVariable.getWord().getText());
            }

            public void caseADescendVariable(ADescendVariable aDescendVariable) {
                aDescendVariable.getParent().apply(this);
                stringBuilder.append('.');
                aDescendVariable.getChild().apply(this);
            }
        });
        this.setEscaping(this.function(stringBuilder.toString(), pExpressionArray));
    }

    private JavaExpression function(String string, PExpression ... pExpressionArray) {
        if (this.propagateEscapeStatus) {
            return JavaExpression.inlineIf(JavaExpression.Type.UNKNOWN, JavaExpression.callOn(JavaExpression.Type.BOOLEAN, TemplateTranslator.CONTEXT, "isEscapingFunction", JavaExpression.string(string)), JavaExpression.symbol("EscapeMode.ESCAPE_IS_CONSTANT"), JavaExpression.symbol("EscapeMode.ESCAPE_NONE"));
        }
        JavaExpression javaExpression = JavaExpression.BooleanLiteralExpression.FALSE;
        for (int i = 0; i < pExpressionArray.length; ++i) {
            pExpressionArray[i].apply(this);
            javaExpression = this.or(javaExpression, this.currentEscapingExpression);
        }
        JavaExpression javaExpression2 = JavaExpression.callOn(JavaExpression.Type.BOOLEAN, TemplateTranslator.CONTEXT, "isEscapingFunction", JavaExpression.string(string));
        return this.or(javaExpression, javaExpression2);
    }

    private JavaExpression or(JavaExpression javaExpression, JavaExpression javaExpression2) {
        if (this.propagateEscapeStatus) {
            return JavaExpression.callOn(JavaExpression.symbol("EscapeMode"), "combineModes", javaExpression, javaExpression2);
        }
        if (javaExpression instanceof JavaExpression.BooleanLiteralExpression) {
            JavaExpression.BooleanLiteralExpression booleanLiteralExpression = (JavaExpression.BooleanLiteralExpression)javaExpression;
            if (booleanLiteralExpression.getValue()) {
                return booleanLiteralExpression;
            }
            return javaExpression2;
        }
        if (javaExpression2 instanceof JavaExpression.BooleanLiteralExpression) {
            JavaExpression.BooleanLiteralExpression booleanLiteralExpression = (JavaExpression.BooleanLiteralExpression)javaExpression2;
            if (booleanLiteralExpression.getValue()) {
                return booleanLiteralExpression;
            }
            return javaExpression;
        }
        return JavaExpression.infix(JavaExpression.Type.BOOLEAN, "||", javaExpression, javaExpression2);
    }

    public void caseAVariableExpression(AVariableExpression aVariableExpression) {
        if (this.propagateEscapeStatus) {
            JavaExpression javaExpression = this.variableTranslator.translate(aVariableExpression.getVariable());
            this.setEscaping(JavaExpression.callOn(TemplateTranslator.DATA_CONTEXT, "findVariableEscapeMode", javaExpression));
        } else {
            this.setDefaultEscaping();
        }
    }

    private void setDefaultEscaping() {
        if (this.propagateEscapeStatus) {
            this.setEscaping(JavaExpression.symbol("EscapeMode.ESCAPE_IS_CONSTANT"));
        } else {
            this.setEscaping(JavaExpression.BooleanLiteralExpression.FALSE);
        }
    }

    public void caseAStringExpression(AStringExpression aStringExpression) {
        this.setDefaultEscaping();
    }

    public void caseADecimalExpression(ADecimalExpression aDecimalExpression) {
        this.setDefaultEscaping();
    }

    public void caseAHexExpression(AHexExpression aHexExpression) {
        this.setDefaultEscaping();
    }

    public void caseANumericExpression(ANumericExpression aNumericExpression) {
        this.setDefaultEscaping();
    }

    public void caseANotExpression(ANotExpression aNotExpression) {
        this.setDefaultEscaping();
    }

    public void caseAExistsExpression(AExistsExpression aExistsExpression) {
        this.setDefaultEscaping();
    }

    public void caseAEqExpression(AEqExpression aEqExpression) {
        this.setDefaultEscaping();
    }

    public void caseANumericEqExpression(ANumericEqExpression aNumericEqExpression) {
        this.setDefaultEscaping();
    }

    public void caseANeExpression(ANeExpression aNeExpression) {
        this.setDefaultEscaping();
    }

    public void caseANumericNeExpression(ANumericNeExpression aNumericNeExpression) {
        this.setDefaultEscaping();
    }

    public void caseALtExpression(ALtExpression aLtExpression) {
        this.setDefaultEscaping();
    }

    public void caseAGtExpression(AGtExpression aGtExpression) {
        this.setDefaultEscaping();
    }

    public void caseALteExpression(ALteExpression aLteExpression) {
        this.setDefaultEscaping();
    }

    public void caseAGteExpression(AGteExpression aGteExpression) {
        this.setDefaultEscaping();
    }

    public void caseAAndExpression(AAndExpression aAndExpression) {
        this.setDefaultEscaping();
    }

    public void caseAOrExpression(AOrExpression aOrExpression) {
        this.setDefaultEscaping();
    }

    public void caseANumericAddExpression(ANumericAddExpression aNumericAddExpression) {
        this.setDefaultEscaping();
    }

    public void caseASubtractExpression(ASubtractExpression aSubtractExpression) {
        this.setDefaultEscaping();
    }

    public void caseAMultiplyExpression(AMultiplyExpression aMultiplyExpression) {
        this.setDefaultEscaping();
    }

    public void caseADivideExpression(ADivideExpression aDivideExpression) {
        this.setDefaultEscaping();
    }

    public void caseAModuloExpression(AModuloExpression aModuloExpression) {
        this.setDefaultEscaping();
    }

    public void caseANegativeExpression(ANegativeExpression aNegativeExpression) {
        this.setDefaultEscaping();
    }
}

