/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.ExpressionTranslator;
import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADecNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.AExpandVariable;
import com.google.clearsilver.jsilver.syntax.node.AHexNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableTranslator
extends DepthFirstAdapter {
    private List<JavaExpression> components;
    private final ExpressionTranslator expressionTranslator;
    private static final JavaExpression DOT = new JavaExpression.StringExpression(".");

    public VariableTranslator(ExpressionTranslator expressionTranslator) {
        this.expressionTranslator = expressionTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaExpression translate(PVariable pVariable) {
        try {
            assert (this.components == null);
            this.components = new ArrayList<JavaExpression>();
            pVariable.apply(this);
            this.components = this.joinComponentsWithDots(this.components);
            this.components = this.combineAdjacentStrings(this.components);
            JavaExpression javaExpression = this.concatenate(this.components);
            return javaExpression;
        }
        finally {
            this.components = null;
        }
    }

    @Override
    public void caseANameVariable(ANameVariable aNameVariable) {
        this.components.add(new JavaExpression.StringExpression(aNameVariable.getWord().getText()));
    }

    @Override
    public void caseADecNumberVariable(ADecNumberVariable aDecNumberVariable) {
        this.components.add(new JavaExpression.StringExpression(aDecNumberVariable.getDecNumber().getText()));
    }

    @Override
    public void caseAHexNumberVariable(AHexNumberVariable aHexNumberVariable) {
        this.components.add(new JavaExpression.StringExpression(aHexNumberVariable.getHexNumber().getText()));
    }

    @Override
    public void caseADescendVariable(ADescendVariable aDescendVariable) {
        aDescendVariable.getParent().apply(this);
        aDescendVariable.getChild().apply(this);
    }

    @Override
    public void caseAExpandVariable(AExpandVariable aExpandVariable) {
        aExpandVariable.getParent().apply(this);
        this.components.add(this.expressionTranslator.translateToString(aExpandVariable.getChild()));
    }

    private List<JavaExpression> joinComponentsWithDots(List<JavaExpression> list) {
        ArrayList<JavaExpression> arrayList = new ArrayList<JavaExpression>(list.size() * 2);
        for (JavaExpression javaExpression : list) {
            if (!arrayList.isEmpty()) {
                arrayList.add(DOT);
            }
            arrayList.add(javaExpression);
        }
        return arrayList;
    }

    private List<JavaExpression> combineAdjacentStrings(List<JavaExpression> list) {
        assert (!list.isEmpty());
        ArrayList<JavaExpression> arrayList = new ArrayList<JavaExpression>(list.size());
        JavaExpression javaExpression = null;
        for (JavaExpression javaExpression2 : list) {
            if (javaExpression == null) {
                javaExpression = javaExpression2;
                continue;
            }
            if (javaExpression2 instanceof JavaExpression.StringExpression && javaExpression instanceof JavaExpression.StringExpression) {
                JavaExpression.StringExpression stringExpression = (JavaExpression.StringExpression)javaExpression2;
                JavaExpression.StringExpression stringExpression2 = (JavaExpression.StringExpression)javaExpression;
                javaExpression = new JavaExpression.StringExpression(stringExpression2.getValue() + stringExpression.getValue());
                continue;
            }
            arrayList.add(javaExpression);
            javaExpression = javaExpression2;
        }
        arrayList.add(javaExpression);
        return arrayList;
    }

    private JavaExpression concatenate(List<JavaExpression> list) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean bl = false;
        for (JavaExpression javaExpression : list) {
            if (bl) {
                printWriter.print(" + ");
            }
            bl = true;
            javaExpression.write(printWriter);
        }
        return JavaExpression.literal(JavaExpression.Type.VAR_NAME, stringWriter.toString());
    }
}

