/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedData
implements Data {
    private final Data delegate;
    private final Iterable<DelegatedData> delegatedIterable = new Iterable<DelegatedData>(){

        @Override
        public Iterator<DelegatedData> iterator() {
            return DelegatedData.this.newChildIterator();
        }
    };

    public DelegatedData(Data data) {
        if (data == null) {
            throw new NullPointerException("Delegate Data must not be null.");
        }
        this.delegate = data;
    }

    protected DelegatedData newInstance(Data data) {
        return data == null ? null : new DelegatedData(data);
    }

    protected Data getDelegate() {
        return this.delegate;
    }

    protected static Data unwrap(Data data) {
        if (data instanceof DelegatedData) {
            data = ((DelegatedData)data).getDelegate();
        }
        return data;
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getValue() {
        return this.getDelegate().getValue();
    }

    @Override
    public int getIntValue() {
        return this.getDelegate().getIntValue();
    }

    @Override
    public boolean getBooleanValue() {
        return this.getDelegate().getBooleanValue();
    }

    @Override
    public void setValue(String string) {
        this.getDelegate().setValue(string);
    }

    @Override
    public String getFullPath() {
        return this.getDelegate().getFullPath();
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.getDelegate().setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        return this.getDelegate().getAttribute(string);
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.getDelegate().hasAttribute(string);
    }

    @Override
    public int getAttributeCount() {
        return this.getDelegate().getAttributeCount();
    }

    @Override
    public Iterable<Map.Entry<String, String>> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    @Override
    public Data getRoot() {
        return this.newInstance(this.getDelegate().getRoot());
    }

    @Override
    public Data getParent() {
        return this.newInstance(this.getDelegate().getParent());
    }

    @Override
    public boolean isFirstSibling() {
        return this.getDelegate().isFirstSibling();
    }

    @Override
    public boolean isLastSibling() {
        return this.getDelegate().isLastSibling();
    }

    @Override
    public Data getNextSibling() {
        return this.newInstance(this.getDelegate().getNextSibling());
    }

    @Override
    public int getChildCount() {
        return this.getDelegate().getChildCount();
    }

    protected Iterator<DelegatedData> newChildIterator() {
        return new DelegatedIterator(this.getDelegate().getChildren().iterator());
    }

    @Override
    public Iterable<? extends Data> getChildren() {
        return this.delegatedIterable;
    }

    @Override
    public Data getChild(String string) {
        return this.newInstance(this.getDelegate().getChild(string));
    }

    @Override
    public Data createChild(String string) {
        return this.newInstance(this.getDelegate().createChild(string));
    }

    @Override
    public void removeTree(String string) {
        this.getDelegate().removeTree(string);
    }

    @Override
    public void setSymlink(String string, String string2) {
        this.getDelegate().setSymlink(string, string2);
    }

    @Override
    public void setSymlink(String string, Data data) {
        data = DelegatedData.unwrap(data);
        this.getDelegate().setSymlink(string, data);
    }

    @Override
    public void setSymlink(Data data) {
        data = DelegatedData.unwrap(data);
        this.getDelegate().setSymlink(data);
    }

    @Override
    public Data getSymlink() {
        return this.newInstance(this.getDelegate().getSymlink());
    }

    @Override
    public void copy(String string, Data data) {
        data = DelegatedData.unwrap(data);
        this.getDelegate().copy(string, data);
    }

    @Override
    public void copy(Data data) {
        data = DelegatedData.unwrap(data);
        this.getDelegate().copy(data);
    }

    @Override
    public String getValue(String string, String string2) {
        return this.getDelegate().getValue(string, string2);
    }

    @Override
    public int getIntValue(String string, int n) {
        return this.getDelegate().getIntValue(string, n);
    }

    @Override
    public String getValue(String string) {
        return this.getDelegate().getValue(string);
    }

    @Override
    public int getIntValue(String string) {
        return this.getDelegate().getIntValue(string);
    }

    @Override
    public boolean getBooleanValue(String string) {
        return this.getDelegate().getBooleanValue(string);
    }

    @Override
    public void setValue(String string, String string2) {
        this.getDelegate().setValue(string, string2);
    }

    @Override
    public String toString() {
        return ((Object)this.getDelegate()).toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        this.getDelegate().toString(stringBuilder, n);
    }

    @Override
    public void write(Appendable appendable, int n) throws IOException {
        this.getDelegate().write(appendable, n);
    }

    @Override
    public void optimize() {
        this.getDelegate().optimize();
    }

    @Override
    public void setEscapeMode(EscapeMode escapeMode) {
        this.getDelegate().setEscapeMode(escapeMode);
    }

    @Override
    public EscapeMode getEscapeMode() {
        return this.getDelegate().getEscapeMode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DelegatedIterator
    implements Iterator<DelegatedData> {
        private final Iterator<? extends Data> iterator;

        DelegatedIterator(Iterator<? extends Data> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DelegatedData next() {
            return DelegatedData.this.newInstance(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

